/*
--------------------------------------------------------------------
© 2017 sqlservertutorial.net All Rights Reserved
--------------------------------------------------------------------
Name   : BikeStores
Link   : http://www.sqlservertutorial.net/load-sample-database/
Version: 1.0
--------------------------------------------------------------------
*/

use BikeStores;

SET IDENTITY_INSERT production.brands ON;  

INSERT INTO production.brands(brand_id,brand_name) VALUES(1,'Electra')
INSERT INTO production.brands(brand_id,brand_name) VALUES(2,'Haro')
INSERT INTO production.brands(brand_id,brand_name) VALUES(3,'Heller')
INSERT INTO production.brands(brand_id,brand_name) VALUES(4,'Pure Cycles')
INSERT INTO production.brands(brand_id,brand_name) VALUES(5,'Ritchey')
INSERT INTO production.brands(brand_id,brand_name) VALUES(6,'Strider')
INSERT INTO production.brands(brand_id,brand_name) VALUES(7,'Sun Bicycles')
INSERT INTO production.brands(brand_id,brand_name) VALUES(8,'Surly')
INSERT INTO production.brands(brand_id,brand_name) VALUES(9,'Trek')

SET IDENTITY_INSERT production.brands OFF;  

SET IDENTITY_INSERT production.categories ON;  
INSERT INTO production.categories(category_id,category_name) VALUES(1,'Children Bicycles')
INSERT INTO production.categories(category_id,category_name) VALUES(2,'Comfort Bicycles')
INSERT INTO production.categories(category_id,category_name) VALUES(3,'Cruisers Bicycles')
INSERT INTO production.categories(category_id,category_name) VALUES(4,'Cyclocross Bicycles')
INSERT INTO production.categories(category_id,category_name) VALUES(5,'Electric Bikes')
INSERT INTO production.categories(category_id,category_name) VALUES(6,'Mountain Bikes')
INSERT INTO production.categories(category_id,category_name) VALUES(7,'Road Bikes')

SET IDENTITY_INSERT production.categories OFF;  

SET IDENTITY_INSERT production.products ON;
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(1,'Trek 820 - 2016',9,6,2016,379.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(2,'Ritchey Timberwolf Frameset - 2016',5,6,2016,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(3,'Surly Wednesday Frameset - 2016',8,6,2016,999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(4,'Trek Fuel EX 8 29 - 2016',9,6,2016,2899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(5,'Heller Shagamaw Frame - 2016',3,6,2016,1320.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(6,'Surly Ice Cream Truck Frameset - 2016',8,6,2016,469.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(7,'Trek Slash 8 27.5 - 2016',9,6,2016,3999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(8,'Trek Remedy 29 Carbon Frameset - 2016',9,6,2016,1799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(9,'Trek Conduit+ - 2016',9,5,2016,2999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(10,'Surly Straggler - 2016',8,4,2016,1549)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(11,'Surly Straggler 650b - 2016',8,4,2016,1680.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(12,'Electra Townie Original 21D - 2016',1,3,2016,549.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(13,'Electra Cruiser 1 (24-Inch) - 2016',1,3,2016,269.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(14,'Electra Girl''s Hawaii 1 (16-inch) - 2015/2016',1,3,2016,269.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(15,'Electra Moto 1 - 2016',1,3,2016,529.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(16,'Electra Townie Original 7D EQ - 2016',1,3,2016,599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(17,'Pure Cycles Vine 8-Speed - 2016',4,3,2016,429)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(18,'Pure Cycles Western 3-Speed - Women''s - 2015/2016',4,3,2016,449)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(19,'Pure Cycles William 3-Speed - 2016',4,3,2016,449)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(20,'Electra Townie Original 7D EQ - Women''s - 2016',1,3,2016,599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(21,'Electra Cruiser 1 (24-Inch) - 2016',1,1,2016,269.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(22,'Electra Girl''s Hawaii 1 (16-inch) - 2015/2016',1,1,2016,269.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(23,'Electra Girl''s Hawaii 1 (20-inch) - 2015/2016',1,1,2016,299.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(24,'Electra Townie Original 21D - 2016',1,2,2016,549.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(25,'Electra Townie Original 7D - 2015/2016',1,2,2016,499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(26,'Electra Townie Original 7D EQ - 2016',1,2,2016,599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(27,'Surly Big Dummy Frameset - 2017',8,6,2017,999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(28,'Surly Karate Monkey 27.5+ Frameset - 2017',8,6,2017,2499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(29,'Trek X-Caliber 8 - 2017',9,6,2017,999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(30,'Surly Ice Cream Truck Frameset - 2017',8,6,2017,999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(31,'Surly Wednesday - 2017',8,6,2017,1632.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(32,'Trek Farley Alloy Frameset - 2017',9,6,2017,469.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(33,'Surly Wednesday Frameset - 2017',8,6,2017,469.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(34,'Trek Session DH 27.5 Carbon Frameset - 2017',9,6,2017,469.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(35,'Sun Bicycles Spider 3i - 2017',7,6,2017,832.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(36,'Surly Troll Frameset - 2017',8,6,2017,832.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(37,'Haro Flightline One ST - 2017',2,6,2017,379.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(38,'Haro Flightline Two 26 Plus - 2017',2,6,2017,549.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(39,'Trek Stache 5 - 2017',9,6,2017,1499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(40,'Trek Fuel EX 9.8 29 - 2017',9,6,2017,4999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(41,'Haro Shift R3 - 2017',2,6,2017,1469.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(42,'Trek Fuel EX 5 27.5 Plus - 2017',9,6,2017,2299.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(43,'Trek Fuel EX 9.8 27.5 Plus - 2017',9,6,2017,5299.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(44,'Haro SR 1.1 - 2017',2,6,2017,539.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(45,'Haro SR 1.2 - 2017',2,6,2017,869.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(46,'Haro SR 1.3 - 2017',2,6,2017,1409.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(47,'Trek Remedy 9.8 - 2017',9,6,2017,5299.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(48,'Trek Emonda S 4 - 2017',9,7,2017,1499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(49,'Trek Domane SL 6 - 2017',9,7,2017,3499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(50,'Trek Silque SLR 7 Women''s - 2017',9,7,2017,5999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(51,'Trek Silque SLR 8 Women''s - 2017',9,7,2017,6499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(52,'Surly Steamroller - 2017',8,7,2017,875.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(53,'Surly Ogre Frameset - 2017',8,7,2017,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(54,'Trek Domane SL Disc Frameset - 2017',9,7,2017,3199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(55,'Trek Domane S 6 - 2017',9,7,2017,2699.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(56,'Trek Domane SLR 6 Disc - 2017',9,7,2017,5499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(57,'Trek Emonda S 5 - 2017',9,7,2017,1999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(58,'Trek Madone 9.2 - 2017',9,7,2017,4999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(59,'Trek Domane S 5 Disc - 2017',9,7,2017,2599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(60,'Sun Bicycles ElectroLite - 2017',7,5,2017,1559.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(61,'Trek Powerfly 8 FS Plus - 2017',9,5,2017,4999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(62,'Trek Boone 7 - 2017',9,4,2017,3499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(63,'Trek Boone Race Shop Limited - 2017',9,4,2017,3499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(64,'Electra Townie Original 7D - 2017',1,3,2017,489.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(65,'Sun Bicycles Lil Bolt Type-R - 2017',7,3,2017,346.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(66,'Sun Bicycles Revolutions 24 - 2017',7,3,2017,250.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(67,'Sun Bicycles Revolutions 24 - Girl''s - 2017',7,3,2017,250.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(68,'Sun Bicycles Cruz 3 - 2017',7,3,2017,449.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(69,'Sun Bicycles Cruz 7 - 2017',7,3,2017,416.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(70,'Electra Amsterdam Original 3i - 2015/2017',1,3,2017,659.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(71,'Sun Bicycles Atlas X-Type - 2017',7,3,2017,416.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(72,'Sun Bicycles Biscayne Tandem 7 - 2017',7,3,2017,619.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(73,'Sun Bicycles Brickell Tandem 7 - 2017',7,3,2017,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(74,'Electra Cruiser Lux 1 - 2017',1,3,2017,439.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(75,'Electra Cruiser Lux Fat Tire 1 Ladies - 2017',1,3,2017,599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(76,'Electra Girl''s Hawaii 1 16" - 2017',1,3,2017,299.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(77,'Electra Glam Punk 3i Ladies'' - 2017',1,3,2017,799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(78,'Sun Bicycles Biscayne Tandem CB - 2017',7,3,2017,647.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(79,'Sun Bicycles Boardwalk (24-inch Wheels) - 2017',7,3,2017,402.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(80,'Sun Bicycles Brickell Tandem CB - 2017',7,3,2017,761.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(81,'Electra Amsterdam Fashion 7i Ladies'' - 2017',1,3,2017,1099.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(82,'Electra Amsterdam Original 3i Ladies'' - 2017',1,3,2017,659.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(83,'Trek Boy''s Kickster - 2015/2017',9,1,2017,149.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(84,'Sun Bicycles Lil Kitt''n - 2017',7,1,2017,109.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(85,'Haro Downtown 16 - 2017',2,1,2017,329.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(86,'Trek Girl''s Kickster - 2017',9,1,2017,149.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(87,'Trek Precaliber 12 Boys - 2017',9,1,2017,189.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(88,'Trek Precaliber 12 Girls - 2017',9,1,2017,189.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(89,'Trek Precaliber 16 Boys - 2017',9,1,2017,209.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(90,'Trek Precaliber 16 Girls - 2017',9,1,2017,209.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(91,'Trek Precaliber 24 (21-Speed) - Girls - 2017',9,1,2017,349.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(92,'Haro Shredder 20 - 2017',2,1,2017,209.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(93,'Haro Shredder 20 Girls - 2017',2,1,2017,209.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(94,'Haro Shredder Pro 20 - 2017',2,1,2017,249.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(95,'Electra Girl''s Hawaii 1 16" - 2017',1,1,2017,299.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(96,'Electra Moto 3i (20-inch) - Boy''s - 2017',1,1,2017,349.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(97,'Electra Savannah 3i (20-inch) - Girl''s - 2017',1,1,2017,349.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(98,'Electra Straight 8 3i (20-inch) - Boy''s - 2017',1,1,2017,489.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(99,'Electra Sugar Skulls 1 (20-inch) - Girl''s - 2017',1,1,2017,299.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(100,'Electra Townie 3i EQ (20-inch) - Boys'' - 2017',1,1,2017,489.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(101,'Electra Townie 7D (20-inch) - Boys'' - 2017',1,1,2017,339.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(102,'Electra Townie Original 7D - 2017',1,2,2017,489.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(103,'Sun Bicycles Streamway 3 - 2017',7,2,2017,551.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(104,'Sun Bicycles Streamway - 2017',7,2,2017,481.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(105,'Sun Bicycles Streamway 7 - 2017',7,2,2017,533.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(106,'Sun Bicycles Cruz 3 - 2017',7,2,2017,449.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(107,'Sun Bicycles Cruz 7 - 2017',7,2,2017,416.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(108,'Sun Bicycles Cruz 3 - Women''s - 2017',7,2,2017,449.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(109,'Sun Bicycles Cruz 7 - Women''s - 2017',7,2,2017,416.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(110,'Sun Bicycles Drifter 7 - 2017',7,2,2017,470.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(111,'Sun Bicycles Drifter 7 - Women''s - 2017',7,2,2017,470.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(112,'Trek 820 - 2018',9,6,2018,379.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(113,'Trek Marlin 5 - 2018',9,6,2018,489.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(114,'Trek Marlin 6 - 2018',9,6,2018,579.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(115,'Trek Fuel EX 8 29 - 2018',9,6,2018,3199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(116,'Trek Marlin 7 - 2017/2018',9,6,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(117,'Trek Ticket S Frame - 2018',9,6,2018,1469.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(118,'Trek X-Caliber 8 - 2018',9,6,2018,999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(119,'Trek Kids'' Neko - 2018',9,6,2018,469.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(120,'Trek Fuel EX 7 29 - 2018',9,6,2018,2499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(121,'Surly Krampus Frameset - 2018',8,6,2018,2499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(122,'Surly Troll Frameset - 2018',8,6,2018,2499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(123,'Trek Farley Carbon Frameset - 2018',9,6,2018,999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(124,'Surly Krampus - 2018',8,6,2018,1499)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(125,'Trek Kids'' Dual Sport - 2018',9,6,2018,469.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(126,'Surly Big Fat Dummy Frameset - 2018',8,6,2018,469.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(127,'Surly Pack Rat Frameset - 2018',8,6,2018,469.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(128,'Surly ECR 27.5 - 2018',8,6,2018,1899)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(129,'Trek X-Caliber 7 - 2018',9,6,2018,919.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(130,'Trek Stache Carbon Frameset - 2018',9,6,2018,919.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(131,'Heller Bloodhound Trail - 2018',3,6,2018,2599)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(132,'Trek Procal AL Frameset - 2018',9,6,2018,1499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(133,'Trek Procaliber Frameset - 2018',9,6,2018,1499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(134,'Trek Remedy 27.5 C Frameset - 2018',9,6,2018,1499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(135,'Trek X-Caliber Frameset - 2018',9,6,2018,1499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(136,'Trek Procaliber 6 - 2018',9,6,2018,1799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(137,'Heller Shagamaw GX1 - 2018',3,6,2018,2599)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(138,'Trek Fuel EX 5 Plus - 2018',9,6,2018,2249.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(139,'Trek Remedy 7 27.5 - 2018',9,6,2018,2999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(140,'Trek Remedy 9.8 27.5 - 2018',9,6,2018,4999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(141,'Trek Stache 5 - 2018',9,6,2018,1599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(142,'Trek Fuel EX 8 29 XT - 2018',9,6,2018,3199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(143,'Trek Domane ALR 3 - 2018',9,7,2018,1099.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(144,'Trek Domane ALR 4 Disc - 2018',9,7,2018,1549.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(145,'Trek Domane ALR 5 Disc - 2018',9,7,2018,1799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(146,'Trek Domane SLR 6 - 2018',9,7,2018,4999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(147,'Trek Domane ALR 5 Gravel - 2018',9,7,2018,1799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(148,'Trek Domane SL 8 Disc - 2018',9,7,2018,5499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(149,'Trek Domane SLR 8 Disc - 2018',9,7,2018,7499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(150,'Trek Emonda SL 7 - 2018',9,7,2018,4499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(151,'Trek Domane ALR 4 Disc Women''s - 2018',9,7,2018,1549.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(152,'Trek Domane SL 5 Disc Women''s - 2018',9,7,2018,2499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(153,'Trek Domane SL 7 Women''s - 2018',9,7,2018,4999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(154,'Trek Domane SLR 6 Disc Women''s - 2018',9,7,2018,5499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(155,'Trek Domane SLR 9 Disc - 2018',9,7,2018,11999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(156,'Trek Domane SL Frameset - 2018',9,7,2018,6499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(157,'Trek Domane SL Frameset Women''s - 2018',9,7,2018,6499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(158,'Trek CrossRip 1 - 2018',9,7,2018,959.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(159,'Trek Emonda ALR 6 - 2018',9,7,2018,2299.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(160,'Trek Emonda SLR 6 - 2018',9,7,2018,4499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(161,'Surly ECR - 2018',8,7,2018,1899)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(162,'Trek Emonda SL 6 Disc - 2018',9,7,2018,2999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(163,'Surly Pack Rat - 2018',8,7,2018,1349)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(164,'Surly Straggler 650b - 2018',8,7,2018,1549)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(165,'Trek 1120 - 2018',9,7,2018,2499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(166,'Trek Domane AL 2 Women''s - 2018',9,7,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(167,'Surly ECR Frameset - 2018',8,7,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(168,'Surly Straggler - 2018',8,7,2018,1549)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(169,'Trek Emonda SLR 8 - 2018',9,7,2018,6499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(170,'Trek CrossRip 2 - 2018',9,7,2018,1299.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(171,'Trek Domane SL 6 - 2018',9,7,2018,3199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(172,'Trek Domane ALR Disc Frameset - 2018',9,7,2018,3199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(173,'Trek Domane ALR Frameset - 2018',9,7,2018,3199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(174,'Trek Domane SLR Disc Frameset - 2018',9,7,2018,3199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(175,'Trek Domane SLR Frameset - 2018',9,7,2018,3199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(176,'Trek Madone 9 Frameset - 2018',9,7,2018,3199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(177,'Trek Domane SLR 6 Disc - 2018',9,7,2018,5499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(178,'Trek Domane AL 2 - 2018',9,7,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(179,'Trek Domane AL 3 - 2018',9,7,2018,919.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(180,'Trek Domane AL 3 Women''s - 2018',9,7,2018,919.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(181,'Trek Domane SL 5 - 2018',9,7,2018,2199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(182,'Trek Domane SL 5 Disc - 2018',9,7,2018,2499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(183,'Trek Domane SL 5 Women''s - 2018',9,7,2018,2199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(184,'Trek Domane SL 6 Disc - 2018',9,7,2018,3499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(185,'Trek Conduit+ - 2018',9,5,2018,2799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(186,'Trek CrossRip+ - 2018',9,5,2018,4499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(187,'Trek Neko+ - 2018',9,5,2018,2799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(188,'Trek XM700+ Lowstep - 2018',9,5,2018,3499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(189,'Trek Lift+ Lowstep - 2018',9,5,2018,2799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(190,'Trek Dual Sport+ - 2018',9,5,2018,2799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(191,'Electra Loft Go! 8i - 2018',1,5,2018,2799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(192,'Electra Townie Go! 8i - 2017/2018',1,5,2018,2599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(193,'Trek Lift+ - 2018',9,5,2018,2799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(194,'Trek XM700+ - 2018',9,5,2018,3499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(195,'Electra Townie Go! 8i Ladies'' - 2018',1,5,2018,2599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(196,'Trek Verve+ - 2018',9,5,2018,2299.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(197,'Trek Verve+ Lowstep - 2018',9,5,2018,2299.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(198,'Electra Townie Commute Go! - 2018',1,5,2018,2999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(199,'Electra Townie Commute Go! Ladies'' - 2018',1,5,2018,2999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(200,'Trek Powerfly 5 - 2018',9,5,2018,3499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(201,'Trek Powerfly 5 FS - 2018',9,5,2018,4499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(202,'Trek Powerfly 5 Women''s - 2018',9,5,2018,3499.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(203,'Trek Powerfly 7 FS - 2018',9,5,2018,4999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(204,'Trek Super Commuter+ 7 - 2018',9,5,2018,3599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(205,'Trek Super Commuter+ 8S - 2018',9,5,2018,4999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(206,'Trek Boone 5 Disc - 2018',9,4,2018,3299.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(207,'Trek Boone 7 Disc - 2018',9,4,2018,3999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(208,'Trek Crockett 5 Disc - 2018',9,4,2018,1799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(209,'Trek Crockett 7 Disc - 2018',9,4,2018,2999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(210,'Surly Straggler - 2018',8,4,2018,1549)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(211,'Surly Straggler 650b - 2018',8,4,2018,1549)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(212,'Electra Townie Original 21D - 2018',1,3,2018,559.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(213,'Electra Cruiser 1 - 2016/2017/2018',1,3,2018,269.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(214,'Electra Tiger Shark 3i - 2018',1,3,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(215,'Electra Queen of Hearts 3i - 2018',1,3,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(216,'Electra Super Moto 8i - 2018',1,3,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(217,'Electra Straight 8 3i - 2018',1,3,2018,909.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(218,'Electra Cruiser 7D - 2016/2017/2018',1,3,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(219,'Electra Moto 3i - 2018',1,3,2018,639.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(220,'Electra Cruiser 1 Ladies'' - 2018',1,3,2018,269.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(221,'Electra Cruiser 7D Ladies'' - 2016/2018',1,3,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(222,'Electra Cruiser 1 Tall - 2016/2018',1,3,2018,269.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(223,'Electra Cruiser Lux 3i - 2018',1,3,2018,529.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(224,'Electra Cruiser Lux 7D - 2018',1,3,2018,479.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(225,'Electra Delivery 3i - 2016/2017/2018',1,3,2018,959.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(226,'Electra Townie Original 21D EQ - 2017/2018',1,3,2018,679.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(227,'Electra Cruiser 7D (24-Inch) Ladies'' - 2016/2018',1,3,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(228,'Electra Cruiser 7D Tall - 2016/2018',1,3,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(229,'Electra Cruiser Lux 1 - 2016/2018',1,3,2018,429.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(230,'Electra Cruiser Lux 1 Ladies'' - 2018',1,3,2018,429.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(231,'Electra Cruiser Lux 3i Ladies'' - 2018',1,3,2018,529.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(232,'Electra Cruiser Lux 7D Ladies'' - 2018',1,3,2018,479.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(233,'Electra Cruiser Lux Fat Tire 7D - 2018',1,3,2018,639.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(234,'Electra Daydreamer 3i Ladies'' - 2018',1,3,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(235,'Electra Koa 3i Ladies'' - 2018',1,3,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(236,'Electra Morningstar 3i Ladies'' - 2018',1,3,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(237,'Electra Relic 3i - 2018',1,3,2018,849.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(238,'Electra Townie Balloon 8D EQ - 2016/2017/2018',1,3,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(239,'Electra Townie Balloon 8D EQ Ladies'' - 2016/2017/2018',1,3,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(240,'Electra Townie Commute 27D Ladies - 2018',1,3,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(241,'Electra Townie Commute 8D - 2018',1,3,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(242,'Electra Townie Commute 8D Ladies'' - 2018',1,3,2018,699.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(243,'Electra Townie Original 21D EQ Ladies'' - 2018',1,3,2018,679.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(244,'Electra Townie Original 21D Ladies'' - 2018',1,3,2018,559.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(245,'Electra Townie Original 3i EQ - 2017/2018',1,3,2018,659.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(246,'Electra Townie Original 3i EQ Ladies'' - 2018',1,3,2018,639.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(247,'Electra Townie Original 7D EQ - 2018',1,3,2018,599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(248,'Electra Townie Original 7D EQ Ladies'' - 2017/2018',1,3,2018,599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(249,'Electra White Water 3i - 2018',1,3,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(250,'Electra Townie Go! 8i - 2017/2018',1,3,2018,2599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(251,'Electra Townie Commute Go! - 2018',1,3,2018,2999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(252,'Electra Townie Commute Go! Ladies'' - 2018',1,3,2018,2999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(253,'Electra Townie Go! 8i Ladies'' - 2018',1,3,2018,2599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(254,'Electra Townie Balloon 3i EQ - 2017/2018',1,3,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(255,'Electra Townie Balloon 7i EQ Ladies'' - 2017/2018',1,3,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(256,'Electra Townie Commute 27D - 2018',1,3,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(257,'Electra Amsterdam Fashion 3i Ladies'' - 2017/2018',1,3,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(258,'Electra Amsterdam Royal 8i - 2017/2018',1,3,2018,1259.9)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(259,'Electra Amsterdam Royal 8i Ladies - 2018',1,3,2018,1199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(260,'Electra Townie Balloon 3i EQ Ladies'' - 2018',1,3,2018,799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(261,'Electra Townie Balloon 7i EQ - 2018',1,3,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(262,'Trek MT 201 - 2018',9,1,2018,249.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(263,'Strider Classic 12 Balance Bike - 2018',6,1,2018,89.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(264,'Strider Sport 16 - 2018',6,1,2018,249.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(265,'Strider Strider 20 Sport - 2018',6,1,2018,289.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(266,'Trek Superfly 20 - 2018',9,1,2018,399.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(267,'Trek Precaliber 12 Girl''s - 2018',9,1,2018,199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(268,'Trek Kickster - 2018',9,1,2018,159.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(269,'Trek Precaliber 12 Boy''s - 2018',9,1,2018,199.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(270,'Trek Precaliber 16 Boy''s - 2018',9,1,2018,209.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(271,'Trek Precaliber 16 Girl''s - 2018',9,1,2018,209.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(272,'Trek Precaliber 20 6-speed Boy''s - 2018',9,1,2018,289.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(273,'Trek Precaliber 20 6-speed Girl''s - 2018',9,1,2018,289.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(274,'Trek Precaliber 20 Boy''s - 2018',9,1,2018,229.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(275,'Trek Precaliber 20 Girl''s - 2018',9,1,2018,229.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(276,'Trek Precaliber 24 (7-Speed) - Boys - 2018',9,1,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(277,'Trek Precaliber 24 21-speed Boy''s - 2018',9,1,2018,369.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(278,'Trek Precaliber 24 21-speed Girl''s - 2018',9,1,2018,369.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(279,'Trek Precaliber 24 7-speed Girl''s - 2018',9,1,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(280,'Trek Superfly 24 - 2017/2018',9,1,2018,489.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(281,'Electra Cruiser 7D (24-Inch) Ladies'' - 2016/2018',1,1,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(282,'Electra Cyclosaurus 1 (16-inch) - Boy''s - 2018',1,1,2018,279.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(283,'Electra Heartchya 1 (20-inch) - Girl''s - 2018',1,1,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(284,'Electra Savannah 1 (20-inch) - Girl''s - 2018',1,1,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(285,'Electra Soft Serve 1 (16-inch) - Girl''s - 2018',1,1,2018,279.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(286,'Electra Starship 1 16" - 2018',1,1,2018,279.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(287,'Electra Straight 8 1 (16-inch) - Boy''s - 2018',1,1,2018,279.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(288,'Electra Straight 8 1 (20-inch) - Boy''s - 2018',1,1,2018,389.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(289,'Electra Superbolt 1 20" - 2018',1,1,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(290,'Electra Superbolt 3i 20" - 2018',1,1,2018,369.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(291,'Electra Sweet Ride 1 (20-inch) - Girl''s - 2018',1,1,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(292,'Electra Sweet Ride 3i (20-inch) - Girls'' - 2018',1,1,2018,369.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(293,'Electra Tiger Shark 1 (20-inch) - Boys'' - 2018',1,1,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(294,'Electra Tiger Shark 3i (20-inch) - Boys'' - 2018',1,1,2018,369.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(295,'Electra Treasure 1 20" - 2018',1,1,2018,319.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(296,'Electra Treasure 3i 20" - 2018',1,1,2018,369.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(297,'Electra Under-The-Sea 1 16" - 2018',1,1,2018,279.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(298,'Electra Water Lily 1 (16-inch) - Girl''s - 2018',1,1,2018,279.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(299,'Electra Townie Original 21D - 2018',1,2,2018,559.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(300,'Electra Townie Balloon 3i EQ Ladies'' - 2018',1,2,2018,799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(301,'Electra Townie Balloon 7i EQ - 2018',1,2,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(302,'Electra Townie Original 1 - 2018',1,2,2018,449.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(303,'Electra Townie Go! 8i - 2017/2018',1,2,2018,2599.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(304,'Electra Townie Original 21D EQ - 2017/2018',1,2,2018,679.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(305,'Electra Townie Balloon 3i EQ - 2017/2018',1,2,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(306,'Electra Townie Balloon 7i EQ Ladies'' - 2017/2018',1,2,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(307,'Electra Townie Balloon 8D EQ - 2016/2017/2018',1,2,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(308,'Electra Townie Balloon 8D EQ Ladies'' - 2016/2017/2018',1,2,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(309,'Electra Townie Commute 27D - 2018',1,2,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(310,'Electra Townie Commute 27D Ladies - 2018',1,2,2018,899.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(311,'Electra Townie Commute 8D - 2018',1,2,2018,749.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(312,'Electra Townie Commute 8D Ladies'' - 2018',1,2,2018,699.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(313,'Electra Townie Original 1 Ladies'' - 2018',1,2,2018,449.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(314,'Electra Townie Original 21D EQ Ladies'' - 2018',1,2,2018,679.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(315,'Electra Townie Original 21D Ladies'' - 2018',1,2,2018,559.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(316,'Trek Checkpoint ALR 4 Women''s - 2019',9,7,2019,1699.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(317,'Trek Checkpoint ALR 5 - 2019',9,7,2019,1999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(318,'Trek Checkpoint ALR 5 Women''s - 2019',9,7,2019,1999.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(319,'Trek Checkpoint SL 5 Women''s - 2019',9,7,2019,2799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(320,'Trek Checkpoint SL 6 - 2019',9,7,2019,3799.99)
INSERT INTO production.products(product_id, product_name, brand_id, category_id, model_year, list_price) VALUES(321,'Trek Checkpoint ALR Frameset - 2019',9,7,2019,3199.99)

SET IDENTITY_INSERT production.products OFF;

-- sales.customers table
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Debra','Burks',NULL,'debra.burks@yahoo.com','9273 Thorne Ave. ','Orchard Park','NY',14127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kasha','Todd',NULL,'kasha.todd@yahoo.com','910 Vine Street ','Campbell','CA',95008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tameka','Fisher',NULL,'tameka.fisher@aol.com','769C Honey Creek St. ','Redondo Beach','CA',90278);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Daryl','Spence',NULL,'daryl.spence@aol.com','988 Pearl Lane ','Uniondale','NY',11553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Charolette','Rice','(916) 381-6003','charolette.rice@msn.com','107 River Dr. ','Sacramento','CA',95820);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lyndsey','Bean',NULL,'lyndsey.bean@hotmail.com','769 West Road ','Fairport','NY',14450);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Latasha','Hays','(716) 986-3359','latasha.hays@hotmail.com','7014 Manor Station Rd. ','Buffalo','NY',14215);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jacquline','Duncan',NULL,'jacquline.duncan@yahoo.com','15 Brown St. ','Jackson Heights','NY',11372);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Genoveva','Baldwin',NULL,'genoveva.baldwin@msn.com','8550 Spruce Drive ','Port Washington','NY',11050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Pamelia','Newman',NULL,'pamelia.newman@gmail.com','476 Chestnut Ave. ','Monroe','NY',10950);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Deshawn','Mendoza',NULL,'deshawn.mendoza@yahoo.com','8790 Cobblestone Street ','Monsey','NY',10952);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Robby','Sykes','(516) 583-7761','robby.sykes@hotmail.com','486 Rock Maple Street ','Hempstead','NY',11550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lashawn','Ortiz',NULL,'lashawn.ortiz@msn.com','27 Washington Rd. ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Garry','Espinoza',NULL,'garry.espinoza@hotmail.com','7858 Rockaway Court ','Forney','TX',75126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Linnie','Branch',NULL,'linnie.branch@gmail.com','314 South Columbia Ave. ','Plattsburgh','NY',12901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Emmitt','Sanchez','(212) 945-8823','emmitt.sanchez@hotmail.com','461 Squaw Creek Road ','New York','NY',10002);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Caren','Stephens',NULL,'caren.stephens@msn.com','914 Brook St. ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Georgetta','Hardin',NULL,'georgetta.hardin@aol.com','474 Chapel Dr. ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lizzette','Stein',NULL,'lizzette.stein@yahoo.com','19 Green Hill Lane ','Orchard Park','NY',14127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Aleta','Shepard',NULL,'aleta.shepard@aol.com','684 Howard St. ','Sugar Land','TX',77478);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tobie','Little',NULL,'tobie.little@gmail.com','10 Silver Spear Dr. ','Victoria','TX',77904);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Adelle','Larsen',NULL,'adelle.larsen@gmail.com','683 West Kirkland Dr. ','East Northport','NY',11731);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kaylee','English',NULL,'kaylee.english@msn.com','8786 Fulton Rd. ','Hollis','NY',11423);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Corene','Wall',NULL,'corene.wall@msn.com','9601 Ocean Rd. ','Atwater','CA',95301);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Regenia','Vaughan',NULL,'regenia.vaughan@gmail.com','44 Stonybrook Street ','Mahopac','NY',10541);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Theo','Reese','(562) 215-2907','theo.reese@gmail.com','8755 W. Wild Horse St. ','Long Beach','NY',11561);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Santos','Valencia',NULL,'santos.valencia@yahoo.com','7479 Carpenter Street ','Sunnyside','NY',11104);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeanice','Frost',NULL,'jeanice.frost@hotmail.com','76 Devon Lane ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Syreeta','Hendricks',NULL,'syreeta.hendricks@msn.com','193 Spruce Road ','Mahopac','NY',10541);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jamaal','Albert',NULL,'jamaal.albert@gmail.com','853 Stonybrook Street ','Torrance','CA',90505);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Williemae','Holloway','(510) 246-8375','williemae.holloway@msn.com','69 Cypress St. ','Oakland','CA',94603);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Araceli','Golden',NULL,'araceli.golden@msn.com','12 Ridgeview Ave. ','Fullerton','CA',92831);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Deloris','Burke',NULL,'deloris.burke@hotmail.com','895 Edgemont Drive ','Palos Verdes Peninsula','CA',90274);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Brittney','Woodward',NULL,'brittney.woodward@aol.com','960 River St. ','East Northport','NY',11731);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Guillermina','Noble',NULL,'guillermina.noble@msn.com','6 Del Monte Lane ','Baldwinsville','NY',13027);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bernita','Mcdaniel',NULL,'bernita.mcdaniel@hotmail.com','2 Peg Shop Ave. ','Liverpool','NY',13090);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Melia','Brady',NULL,'melia.brady@gmail.com','907 Shirley Rd. ','Maspeth','NY',11378);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Zelma','Browning',NULL,'zelma.browning@aol.com','296 Second Street ','Astoria','NY',11102);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Janetta','Aguirre','(717) 670-2634','janetta.aguirre@aol.com','214 Second Court ','Lancaster','NY',14086);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ronna','Butler',NULL,'ronna.butler@gmail.com','9438 Plymouth Court ','Encino','CA',91316);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kathie','Freeman',NULL,'kathie.freeman@msn.com','667 Temple Dr. ','Queensbury','NY',12804);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tangela','Quinn',NULL,'tangela.quinn@aol.com','4 S. Purple Finch Road ','Richmond Hill','NY',11418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mozelle','Carter','(281) 489-9656','mozelle.carter@aol.com','895 Chestnut Ave. ','Houston','TX',77016);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Onita','Johns',NULL,'onita.johns@msn.com','32 Glen Creek Lane ','Elmont','NY',11003);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bennett','Armstrong',NULL,'bennett.armstrong@aol.com','688 Walnut Street ','Bethpage','NY',11714);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Monika','Berg',NULL,'monika.berg@gmail.com','369 Vernon Dr. ','Encino','CA',91316);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bridgette','Guerra',NULL,'bridgette.guerra@hotmail.com','9982 Manor Drive ','San Lorenzo','CA',94580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cesar','Jackson',NULL,'cesar.jackson@gmail.com','8068 N. Griffin Ave. ','Liverpool','NY',13090);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Caroll','Hays',NULL,'caroll.hays@yahoo.com','9381 Wrangler St. ','Fairport','NY',14450);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cleotilde','Booth',NULL,'cleotilde.booth@gmail.com','17 Corona St. ','Sugar Land','TX',77478);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gertrud','Rhodes',NULL,'gertrud.rhodes@aol.com','9961 Meadowbrook Street ','Merrick','NY',11566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tu','Ramirez',NULL,'tu.ramirez@hotmail.com','24 W. Courtland Street ','East Elmhurst','NY',11369);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Saturnina','Garner',NULL,'saturnina.garner@gmail.com','8538 Fairground St. ','Glendora','CA',91740);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Fran','Yang',NULL,'fran.yang@hotmail.com','440 Pearl St. ','Utica','NY',13501);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Diana','Guerra',NULL,'diana.guerra@hotmail.com','45 Chapel Ave. ','Merrick','NY',11566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lolita','Mosley','(281) 363-3309','lolita.mosley@hotmail.com','376 S. High Ridge St. ','Houston','TX',77016);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Pamala','Henry',NULL,'pamala.henry@aol.com','197 Bridgeton Ave. ','Bronx','NY',10451);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Damien','Dorsey',NULL,'damien.dorsey@yahoo.com','161 Old York Street ','Central Islip','NY',11722);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Latasha','Stanley',NULL,'latasha.stanley@gmail.com','8068 Fordham Drive ','Rockville Centre','NY',11570);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Neil','Mccall',NULL,'neil.mccall@gmail.com','7476 Oakland Dr. ','San Carlos','CA',94070);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elinore','Aguilar',NULL,'elinore.aguilar@msn.com','9766 Rockcrest Ave. ','San Angelo','TX',76901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alica','Hunter',NULL,'alica.hunter@hotmail.com','8 San Juan Drive ','East Elmhurst','NY',11369);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tenisha','Lyons',NULL,'tenisha.lyons@aol.com','78 E. Rock Creek Street ','Amityville','NY',11701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bobbie','Foster',NULL,'bobbie.foster@yahoo.com','988 Pineknoll Ave. ','Desoto','TX',75115);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kanesha','Vega',NULL,'kanesha.vega@gmail.com','771 E. Oxford Drive ','Rome','NY',13440);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lorrie','Becker',NULL,'lorrie.becker@yahoo.com','19 North Court ','Garland','TX',75043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tommie','Melton','(916) 802-2952','tommie.melton@gmail.com','8 West Old York St. ','Sacramento','CA',95820);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jayne','Kirkland',NULL,'jayne.kirkland@hotmail.com','7800 Second Lane ','Rowlett','TX',75088);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Katelin','Kennedy',NULL,'katelin.kennedy@gmail.com','286 Myrtle Lane ','Rocklin','CA',95677);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tomasa','Carson',NULL,'tomasa.carson@aol.com','10 Clark Avenue ','East Elmhurst','NY',11369);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Takako','Casey',NULL,'takako.casey@aol.com','7548 Court Lane ','Bronx','NY',10451);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Petronila','Norris',NULL,'petronila.norris@aol.com','72 South Marshall Lane ','South El Monte','CA',91733);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Melanie','Hayes',NULL,'melanie.hayes@msn.com','5 N. Hall Dr. ','Liverpool','NY',13090);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Georgeann','Waller',NULL,'georgeann.waller@yahoo.com','9797 Bald Hill Ave. ','North Tonawanda','NY',14120);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Abby','Gamble',NULL,'abby.gamble@aol.com','60 Myers Dr. ','Amityville','NY',11701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Parker','Prince',NULL,'parker.prince@hotmail.com','21 Sulphur Springs Drive ','Port Jefferson Station','NY',11776);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Keri','Bridges',NULL,'keri.bridges@gmail.com','8504 Brickell Ave. ','Richardson','TX',75080);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chi','Goff',NULL,'chi.goff@aol.com','3 W. Glen Ridge Avenue ','Palos Verdes Peninsula','CA',90274);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ashanti','Parks',NULL,'ashanti.parks@hotmail.com','846 N. Helen St. ','Baldwin','NY',11510);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sarai','Mckee','(716) 912-8110','sarai.mckee@msn.com','641 Glenwood Avenue ','Buffalo','NY',14215);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Zina','Bonner',NULL,'zina.bonner@hotmail.com','9312 8th Street ','San Lorenzo','CA',94580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lizzie','Joyner',NULL,'lizzie.joyner@msn.com','8541 Roberts St. ','Coachella','CA',92236);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tiesha','Daniel',NULL,'tiesha.daniel@yahoo.com','6 West Bohemia Lane ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Armand','Whitehead',NULL,'armand.whitehead@hotmail.com','639 Harvey St. ','Lindenhurst','NY',11757);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Teofila','Fischer',NULL,'teofila.fischer@aol.com','1 West Brickyard St. ','Huntington Station','NY',11746);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lissa','Vargas',NULL,'lissa.vargas@yahoo.com','517 Victoria Ave. ','Oswego','NY',13126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yan','Mcgowan',NULL,'yan.mcgowan@msn.com','8960 Newport Ave. ','Duarte','CA',91010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Titus','Bullock',NULL,'titus.bullock@gmail.com','29 Oxford Avenue ','Hollis','NY',11423);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Arvilla','Osborn',NULL,'arvilla.osborn@gmail.com','60 Acacia Lane ','Upland','CA',91784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marjorie','Logan',NULL,'marjorie.logan@msn.com','95 Grandrose St. ','Franklin Square','NY',11010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marvin','Mullins','(619) 635-2027','marvin.mullins@aol.com','7489 Redwood Drive ','San Diego','CA',92111);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tena','Cruz',NULL,'tena.cruz@yahoo.com','1 South St. ','Farmingdale','NY',11735);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Corrina','Sawyer','(248) 370-1364','corrina.sawyer@yahoo.com','95 Briarwood Lane ','Troy','NY',12180);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sharyn','Hopkins',NULL,'sharyn.hopkins@hotmail.com','4 South Temple Ave. ','Baldwinsville','NY',13027);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Letitia','Franco',NULL,'letitia.franco@aol.com','607 Lakeview Drive ','Saratoga Springs','NY',12866);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Floretta','Higgins',NULL,'floretta.higgins@hotmail.com','870 Lilac Dr. ','Bayside','NY',11361);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Louanne','Martin',NULL,'louanne.martin@hotmail.com','1 Campfire Ave. ','Yuba City','CA',95993);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Violet','Valenzuela',NULL,'violet.valenzuela@msn.com','8668 Piper Street ','Plattsburgh','NY',12901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carie','Kidd',NULL,'carie.kidd@yahoo.com','6 East Clinton Street ','Monroe','NY',10950);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kellie','Franco',NULL,'kellie.franco@yahoo.com','444 South Walnut Rd. ','Commack','NY',11725);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nichelle','Howell',NULL,'nichelle.howell@aol.com','7670 Forest St. ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marisol','Goodman',NULL,'marisol.goodman@gmail.com','864 East Cherry St. ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sylvie','Wilkerson',NULL,'sylvie.wilkerson@yahoo.com','750 Central Ave. ','Syosset','NY',11791);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Katharina','Bates',NULL,'katharina.bates@gmail.com','54 South Greenview Drive ','Campbell','CA',95008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marget','Hodge',NULL,'marget.hodge@msn.com','7199 Selby Lane ','Woodhaven','NY',11421);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Raul','Melendez',NULL,'raul.melendez@hotmail.com','9772 Manhattan St. ','Elmhurst','NY',11373);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cecil','Hopper',NULL,'cecil.hopper@yahoo.com','471 Glenlake Ave. ','Central Islip','NY',11722);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shae','Hickman',NULL,'shae.hickman@hotmail.com','740 Pin Oak Street ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Monica','Sears','(408) 704-8863','monica.sears@aol.com','57 Glenholme St. ','San Jose','CA',95127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ollie','Zimmerman','(657) 648-2863','ollie.zimmerman@yahoo.com','69 Wood Rd. ','Anaheim','CA',92806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shila','White',NULL,'shila.white@msn.com','94 Lakeshore Street ','Orchard Park','NY',14127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yuk','Vega',NULL,'yuk.vega@yahoo.com','413 Wood St. ','West Hempstead','NY',11552);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Eliana','Silva',NULL,'eliana.silva@gmail.com','7119 Summer Rd. ','Farmingdale','NY',11735);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Thalia','Horne',NULL,'thalia.horne@yahoo.com','9312 Harvard Street ','Amityville','NY',11701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rey','Lindsay',NULL,'rey.lindsay@gmail.com','16 Philmont St. ','Monroe','NY',10950);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Merlene','Vinson',NULL,'merlene.vinson@gmail.com','431 Vine Dr. ','Euless','TX',76039);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dacia','William',NULL,'dacia.william@msn.com','62 Cypress Drive ','Sugar Land','TX',77478);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Le','Wood',NULL,'le.wood@yahoo.com','90 Primrose Dr. ','Pittsford','NY',14534);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Thalia','Dillard',NULL,'thalia.dillard@yahoo.com','987 NE. Gates Street ','San Angelo','TX',76901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Luz','House','(559) 114-2580','luz.house@gmail.com','491 Railroad Street ','Fresno','CA',93706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lucy','Woods',NULL,'lucy.woods@gmail.com','8437 West Rockaway St. ','Palos Verdes Peninsula','CA',90274);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shena','Carter',NULL,'shena.carter@yahoo.com','72 University Road ','Howard Beach','NY',11414);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Robena','Hill','(361) 598-4414','robena.hill@hotmail.com','263 Cross St. ','Corpus Christi','TX',78418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeni','Booker',NULL,'jeni.booker@gmail.com','546 Railroad Dr. ','South El Monte','CA',91733);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Herlinda','Stone',NULL,'herlinda.stone@msn.com','725 Gulf St. ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lavina','Dejesus',NULL,'lavina.dejesus@msn.com','59 E. Valley Avenue ','Newburgh','NY',12550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Erlinda','Nielsen',NULL,'erlinda.nielsen@aol.com','728 Oxford Lane ','Maspeth','NY',11378);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Terrance','Lynn',NULL,'terrance.lynn@yahoo.com','91 East Buckingham Drive ','Plattsburgh','NY',12901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Walton','Dejesus',NULL,'walton.dejesus@yahoo.com','15 Washington Rd. ','Lockport','NY',14094);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Wes','Stanton','(248) 247-5074','wes.stanton@msn.com','8662 Tunnel Street ','Troy','NY',12180);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tanesha','Hampton',NULL,'tanesha.hampton@hotmail.com','19 Belmont Ave. ','Syosset','NY',11791);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Boyd','Irwin',NULL,'boyd.irwin@hotmail.com','221 Whitemarsh St. ','Hamburg','NY',14075);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Delbert','Wilkins',NULL,'delbert.wilkins@aol.com','420 Greenview St. ','Coram','NY',11727);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Brianna','Moss','(516) 156-8031','brianna.moss@msn.com','4 Longfellow St. ','Hempstead','NY',11550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dorthey','Jackson','(281) 926-8010','dorthey.jackson@msn.com','9768 Brookside St. ','Houston','TX',77016);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sarita','Parks',NULL,'sarita.parks@msn.com','7809 Second Lane ','Forney','TX',75126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shonta','Mercer',NULL,'shonta.mercer@aol.com','319 NE. La Sierra Avenue ','Massapequa','NY',11758);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jone','Bernard','(657) 536-5165','jone.bernard@hotmail.com','99 Longbranch Court ','Anaheim','CA',92806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Wanita','Davenport',NULL,'wanita.davenport@aol.com','525 Dogwood Ave. ','Spring Valley','NY',10977);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cleopatra','Tate',NULL,'cleopatra.tate@aol.com','97 N. Glenwood St. ','East Elmhurst','NY',11369);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ramiro','Byers',NULL,'ramiro.byers@gmail.com','16 Pleasant St. ','Saint Albans','NY',11412);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nicholas','Vazquez',NULL,'nicholas.vazquez@hotmail.com','9 Roosevelt Street ','West Hempstead','NY',11552);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Janae','Doyle',NULL,'janae.doyle@gmail.com','760 Rose Ave. ','Jackson Heights','NY',11372);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hans','Price',NULL,'hans.price@hotmail.com','51 Glendale Road ','Port Chester','NY',10573);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Miquel','Neal',NULL,'miquel.neal@hotmail.com','9564 Deerfield Lane ','Staten Island','NY',10301);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Stefany','Potter',NULL,'stefany.potter@gmail.com','256 South Academy St. ','Saratoga Springs','NY',12866);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bernetta','Marquez',NULL,'bernetta.marquez@hotmail.com','626 E. Dunbar Street ','Smithtown','NY',11787);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Julee','Woodard',NULL,'julee.woodard@yahoo.com','869 Summerhouse Dr. ','Richmond Hill','NY',11418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Meredith','Bryan',NULL,'meredith.bryan@hotmail.com','8935 E. Oxford St. ','Spring Valley','NY',10977);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Weldon','Michael',NULL,'weldon.michael@hotmail.com','9952 Nut Swamp St. ','Huntington','NY',11743);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Joesph','Delacruz',NULL,'joesph.delacruz@aol.com','184 Cypress Street ','Atwater','CA',95301);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Katherina','Odom',NULL,'katherina.odom@yahoo.com','897 N. Oak Drive ','Plainview','NY',11803);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Laraine','Robbins',NULL,'laraine.robbins@yahoo.com','8214 E. Pin Oak Lane ','San Angelo','TX',76901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jenise','Preston',NULL,'jenise.preston@yahoo.com','9 Littleton Drive ','Helotes','TX',78023);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lory','Page',NULL,'lory.page@hotmail.com','58 Summerhouse Street ','Bay Shore','NY',11706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Charlyn','Cantrell',NULL,'charlyn.cantrell@yahoo.com','8756 Euclid St. ','West Islip','NY',11795);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carola','Rodriquez',NULL,'carola.rodriquez@hotmail.com','9433 Heritage Lane ','Banning','CA',92220);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alane','Kennedy',NULL,'alane.kennedy@yahoo.com','34 Green Lake Street ','Spring Valley','NY',10977);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Regina','Burns',NULL,'regina.burns@aol.com','713 Buckingham St. ','Garland','TX',75043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Omer','Estrada',NULL,'omer.estrada@gmail.com','9 Honey Creek Street ','Rowlett','TX',75088);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Crystle','Gilliam',NULL,'crystle.gilliam@yahoo.com','86 Edgewater Road ','Smithtown','NY',11787);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kam','Wilder',NULL,'kam.wilder@hotmail.com','500 West Clay Ave. ','Newburgh','NY',12550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Margert','Stevens',NULL,'margert.stevens@aol.com','502 North Poplar St. ','Rome','NY',13440);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tomika','Larson',NULL,'tomika.larson@yahoo.com','254 Canal St. ','Woodside','NY',11377);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeromy','Burch','(408) 955-8238','jeromy.burch@msn.com','889 Mulberry Street ','San Jose','CA',95127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lena','Mills',NULL,'lena.mills@yahoo.com','42 Homestead St. ','Woodhaven','NY',11421);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Loreta','Johnston',NULL,'loreta.johnston@yahoo.com','39 Lafayette Dr. ','Spring Valley','NY',10977);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nettie','Mcdaniel',NULL,'nettie.mcdaniel@hotmail.com','7004 E. Wakehurst St. ','South Ozone Park','NY',11420);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Karla','Kirk',NULL,'karla.kirk@yahoo.com','9718 Harvard Rd. ','Palos Verdes Peninsula','CA',90274);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Regine','Gonzales','(805) 763-4045','regine.gonzales@gmail.com','798 Court Drive ','Oxnard','CA',93035);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Miriam','Baker',NULL,'miriam.baker@hotmail.com','90 Studebaker St. ','Uniondale','NY',11553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeanie','Kirkland',NULL,'jeanie.kirkland@aol.com','7643 Old Theatre St. ','Santa Clara','CA',95050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marquerite','Dawson',NULL,'marquerite.dawson@gmail.com','37 Hamilton Court ','Garland','TX',75043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Babara','Ochoa',NULL,'babara.ochoa@aol.com','872 Smith Store St. ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nova','Hess',NULL,'nova.hess@msn.com','773 South Lafayette St. ','Duarte','CA',91010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carley','Reynolds',NULL,'carley.reynolds@gmail.com','2 Snake Hill Drive ','South El Monte','CA',91733);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carissa','Foreman',NULL,'carissa.foreman@msn.com','69C N. Ridge Rd. ','Maspeth','NY',11378);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Genoveva','Tyler','(212) 152-6381','genoveva.tyler@gmail.com','8121 Windfall Ave. ','New York','NY',10002);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Deane','Sears',NULL,'deane.sears@hotmail.com','3 Bradford Court ','Pittsford','NY',14534);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Karey','Steele',NULL,'karey.steele@gmail.com','8879 Kent Lane ','Farmingdale','NY',11735);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Olevia','Pitts',NULL,'olevia.pitts@gmail.com','39 Fieldstone Drive ','Redondo Beach','CA',90278);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jenniffer','Bullock',NULL,'jenniffer.bullock@msn.com','38 Oxford Avenue ','Bay Shore','NY',11706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeniffer','Ratliff',NULL,'jeniffer.ratliff@gmail.com','510 Rocky River Court ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Klara','Stanley',NULL,'klara.stanley@aol.com','603 Mechanic St. ','Webster','NY',14580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Morton','Lee',NULL,'morton.lee@yahoo.com','313 Ridge St. ','San Angelo','TX',76901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ken','Charles',NULL,'ken.charles@msn.com','9124 W. Piper Lane ','Monsey','NY',10952);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hedwig','Paul',NULL,'hedwig.paul@msn.com','422 Manor Ave. ','Apple Valley','CA',92307);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sharla','Flynn','(805) 478-7724','sharla.flynn@hotmail.com','7 Brown Drive ','Oxnard','CA',93035);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Damian','Dawson',NULL,'damian.dawson@hotmail.com','528 St Margarets Street ','Liverpool','NY',13090);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Toya','Pratt','(562) 218-6405','toya.pratt@yahoo.com','485 San Pablo Drive ','Long Beach','NY',11561);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Graciela','Barber','(805) 656-6987','graciela.barber@hotmail.com','1 E. Young St. ','Oxnard','CA',93035);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bong','Hebert',NULL,'bong.hebert@gmail.com','545 Brook St. ','Torrance','CA',90505);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ayanna','Rhodes',NULL,'ayanna.rhodes@msn.com','7425 Pheasant St. ','Hicksville','NY',11801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dorine','Roberson',NULL,'dorine.roberson@msn.com','396 Meadowbrook Lane ','Santa Cruz','CA',95060);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Addie','Hahn',NULL,'addie.hahn@hotmail.com','8165 Baker Ave. ','Franklin Square','NY',11010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Edythe','Valencia',NULL,'edythe.valencia@yahoo.com','9346 Wall St. ','North Tonawanda','NY',14120);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Andy','O''neill',NULL,'andy.o''neill@msn.com','9544 Mulberry Drive ','Rego Park','NY',11374);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Luis','Tyler',NULL,'luis.tyler@gmail.com','9568 Campfire Circle ','Amarillo','TX',79106);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Clelia','Workman',NULL,'clelia.workman@yahoo.com','620 North Somerset St. ','New Windsor','NY',12553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ashely','Holmes',NULL,'ashely.holmes@aol.com','45 High Ridge Ave. ','Farmingdale','NY',11735);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Candis','Harding',NULL,'candis.harding@gmail.com','33 NW. Cambridge Ave. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marni','Bolton','(717) 670-6268','marni.bolton@msn.com','7469 Plymouth Ave. ','Lancaster','NY',14086);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Minerva','Decker','(281) 271-6390','minerva.decker@yahoo.com','794 Greenrose Street ','Houston','TX',77016);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alpha','King',NULL,'alpha.king@hotmail.com','14 Henry Smith St. ','Rockville Centre','NY',11570);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Harris','Pittman',NULL,'harris.pittman@yahoo.com','404 Cherry Hill Road ','Jamaica','NY',11432);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Stephaine','Riddle',NULL,'stephaine.riddle@hotmail.com','199 Vermont Court ','Brooklyn','NY',11201);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Michel','Blankenship',NULL,'michel.blankenship@msn.com','382 West Hill Dr. ','Forney','TX',75126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Denis','Logan',NULL,'denis.logan@msn.com','121 Rockcrest Street ','Ridgecrest','CA',93555);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jutta','Everett',NULL,'jutta.everett@gmail.com','27 Taylor Ave. ','Selden','NY',11784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Priscilla','Wilkins','(229) 322-2269','priscilla.wilkins@aol.com','653 Pawnee Rd. ','Albany','NY',12203);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gilma','Dejesus',NULL,'gilma.dejesus@yahoo.com','777 Thompson Ave. ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Buford','Bridges','(248) 604-7346','buford.bridges@msn.com','239 Oak Valley Court ','Troy','NY',12180);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elenore','Hensley',NULL,'elenore.hensley@hotmail.com','7037 Aspen St. ','Hamburg','NY',14075);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ross','Pugh',NULL,'ross.pugh@msn.com','8598 Saxon St. ','North Tonawanda','NY',14120);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Judith','Finley',NULL,'judith.finley@hotmail.com','474 West Bank Road ','Whitestone','NY',11357);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Wai','Soto',NULL,'wai.soto@msn.com','30 Arch Drive ','Bethpage','NY',11714);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carline','Collier','(559) 810-6070','carline.collier@msn.com','28 Trenton Lane ','Fresno','CA',93706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Casey','Gill',NULL,'casey.gill@gmail.com','636 Prospect Avenue ','Port Washington','NY',11050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Darcie','Morgan','(442) 618-7068','darcie.morgan@aol.com','476 East Adams Ave. ','Oceanside','NY',11572);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lucio','Sherman',NULL,'lucio.sherman@gmail.com','842 Corona Ave. ','Smithtown','NY',11787);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Clementine','Mooney',NULL,'clementine.mooney@yahoo.com','678 Charles Court ','Mcallen','TX',78501);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Anya','Contreras',NULL,'anya.contreras@msn.com','38 Old Fairground St. ','East Northport','NY',11731);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Scarlet','Yates',NULL,'scarlet.yates@hotmail.com','687 Shirley St. ','Patchogue','NY',11772);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Moses','Pope',NULL,'moses.pope@yahoo.com','654 Theatre Street ','Lawndale','CA',90260);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Barbera','Riggs',NULL,'barbera.riggs@aol.com','12 Gartner Drive ','Plainview','NY',11803);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kiana','Rivera',NULL,'kiana.rivera@gmail.com','9 Sheffield Dr. ','Richmond Hill','NY',11418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Danielle','Bond',NULL,'danielle.bond@msn.com','8589 Shub Farm Street ','Patchogue','NY',11772);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Whitney','Estes','(631) 315-4020','whitney.estes@gmail.com','454 Bear Hill Street ','Brentwood','NY',11717);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Molly','Langley',NULL,'molly.langley@aol.com','63 Bridgeton Street ','Holbrook','NY',11741);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chelsey','Hardin',NULL,'chelsey.hardin@hotmail.com','13 Brickyard Street ','Deer Park','NY',11729);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jenee','Rasmussen','(916) 219-1774','jenee.rasmussen@hotmail.com','19 George Lane ','Sacramento','CA',95820);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Freddie','Mathis',NULL,'freddie.mathis@hotmail.com','31 Shady St. ','Euless','TX',76039);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mariana','Strong',NULL,'mariana.strong@msn.com','972 Dunbar Dr. ','Santa Clara','CA',95050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Winfred','Harris',NULL,'winfred.harris@msn.com','734 Glen Eagles St. ','East Meadow','NY',11554);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeromy','Elliott',NULL,'jeromy.elliott@gmail.com','7112 Laurel Street ','Bay Shore','NY',11706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Verona','O''neill',NULL,'verona.o''neill@hotmail.com','8279 W. Sussex St. ','Selden','NY',11784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elvera','Peck',NULL,'elvera.peck@yahoo.com','759 Lakewood Street ','Banning','CA',92220);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cindi','Larson',NULL,'cindi.larson@msn.com','896 Golden Star Rd. ','Howard Beach','NY',11414);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Felice','Guzman',NULL,'felice.guzman@hotmail.com','7 Creekside Lane ','Canyon Country','CA',91387);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Le','Deleon',NULL,'le.deleon@msn.com','58 Clark Court ','Banning','CA',92220);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Manie','Sanchez',NULL,'manie.sanchez@hotmail.com','471 Illinois Ave. ','Queensbury','NY',12804);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rutha','Howell',NULL,'rutha.howell@gmail.com','9247 Jones Street ','Canyon Country','CA',91387);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Natosha','Rowland',NULL,'natosha.rowland@aol.com','51 Elmwood St. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jessika','Bray',NULL,'jessika.bray@yahoo.com','37 East Greystone St. ','San Pablo','CA',94806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Delila','Hamilton',NULL,'delila.hamilton@yahoo.com','7451 East James Ave. ','Palos Verdes Peninsula','CA',90274);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dionne','Norris',NULL,'dionne.norris@yahoo.com','9993 Greenview Circle ','Niagara Falls','NY',14304);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Muriel','Juarez',NULL,'muriel.juarez@gmail.com','8073 Cemetery Drive ','Palos Verdes Peninsula','CA',90274);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cecelia','Gill',NULL,'cecelia.gill@aol.com','372 Silver Spear Dr. ','Mcallen','TX',78501);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Magda','Eaton',NULL,'magda.eaton@aol.com','860 Middle River Street ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ivonne','Yang','(915) 181-1950','ivonne.yang@gmail.com','7359 North Lake View St. ','El Paso','TX',79930);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kasie','Rodriquez',NULL,'kasie.rodriquez@aol.com','7 North Beech St. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Eleni','Gordon',NULL,'eleni.gordon@hotmail.com','583 W. San Carlos Street ','Richmond Hill','NY',11418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Maurice','Norton',NULL,'maurice.norton@hotmail.com','32 Mayflower Dr. ','Atwater','CA',95301);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cristobal','Hutchinson',NULL,'cristobal.hutchinson@gmail.com','58 Washington Avenue ','Lawndale','CA',90260);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Flossie','Holder',NULL,'flossie.holder@msn.com','8459 W. Newport Court ','Massapequa Park','NY',11762);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Erma','Salinas',NULL,'erma.salinas@gmail.com','347 Sheffield St. ','Merrick','NY',11566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Earl','Stanley',NULL,'earl.stanley@gmail.com','569 Lake Lane ','Elmhurst','NY',11373);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Maribel','William',NULL,'maribel.william@aol.com','65 Magnolia Ave. ','Torrance','CA',90505);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Johnathan','Velazquez',NULL,'johnathan.velazquez@hotmail.com','9680 E. Somerset Street ','Pleasanton','CA',94566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rodrick','Shelton',NULL,'rodrick.shelton@hotmail.com','7157 Addison Street ','Canyon Country','CA',91387);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ferne','Kline',NULL,'ferne.kline@hotmail.com','303 Shady St. ','Fullerton','CA',92831);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rubin','Decker','(716) 950-9835','rubin.decker@gmail.com','9875 Shady Ave. ','Buffalo','NY',14215);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dortha','Jarvis','(442) 919-8256','dortha.jarvis@yahoo.com','76 Prince Drive ','Oceanside','NY',11572);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mariela','Huffman',NULL,'mariela.huffman@gmail.com','531 Fieldstone Road ','Garden City','NY',11530);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mellisa','Farley',NULL,'mellisa.farley@yahoo.com','21 West Princess St. ','Central Islip','NY',11722);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Myung','Hooper',NULL,'myung.hooper@gmail.com','951 Mill Road ','Elmont','NY',11003);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Angelina','Lloyd',NULL,'angelina.lloyd@yahoo.com','9593 North Sherman Dr. ','Apple Valley','CA',92307);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Trinity','Riddle',NULL,'trinity.riddle@aol.com','23 Oakland Lane ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Barton','Crosby',NULL,'barton.crosby@msn.com','896 Edgewater St. ','Bellmore','NY',11710);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Claudio','Wise',NULL,'claudio.wise@hotmail.com','810 Oxford Ave. ','Kingston','NY',12401);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Katheleen','Marks',NULL,'katheleen.marks@yahoo.com','69 North Tower St. ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Deja','Chaney',NULL,'deja.chaney@hotmail.com','52 Woodside Ave. ','Jamaica','NY',11432);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Queenie','Vance',NULL,'queenie.vance@gmail.com','172 Arcadia Ave. ','Ozone Park','NY',11417);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Josh','Shaw',NULL,'josh.shaw@gmail.com','212 North Leeton Ridge Street ','Hopewell Junction','NY',12533);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Pinkie','Kirkland',NULL,'pinkie.kirkland@yahoo.com','18 Myers St. ','San Angelo','TX',76901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lavette','Wright',NULL,'lavette.wright@msn.com','6 Windsor Street ','Ronkonkoma','NY',11779);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mark','Garrett',NULL,'mark.garrett@msn.com','285 Rosewood Dr. ','Monroe','NY',10950);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Myesha','Burgess',NULL,'myesha.burgess@gmail.com','306 Trenton Rd. ','Campbell','CA',95008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Justina','Long',NULL,'justina.long@aol.com','39 Littleton Ave. ','South El Monte','CA',91733);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Brenda','Tate',NULL,'brenda.tate@msn.com','36 Hilltop Street ','San Angelo','TX',76901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rayna','Perry',NULL,'rayna.perry@hotmail.com','7238 Oakland St. ','Ozone Park','NY',11417);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Randolph','Chase',NULL,'randolph.chase@yahoo.com','828 Bridle Ave. ','San Lorenzo','CA',94580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jaimee','Day',NULL,'jaimee.day@aol.com','7534 Whitemarsh Ave. ','Poughkeepsie','NY',12601);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Susann','Bass',NULL,'susann.bass@msn.com','21 Old Rock Maple Ave. ','Commack','NY',11725);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Leola','Gould',NULL,'leola.gould@gmail.com','8 Kirkland St. ','Astoria','NY',11102);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Virgil','Frost',NULL,'virgil.frost@gmail.com','9798 Beacon St. ','Levittown','NY',11756);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mireille','Puckett','(805) 961-9909','mireille.puckett@hotmail.com','378 Purple Finch Drive ','Oxnard','CA',93035);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Keturah','Massey',NULL,'keturah.massey@msn.com','189 Arnold Drive ','Banning','CA',92220);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Charmain','Webster',NULL,'charmain.webster@hotmail.com','36 East Stonybrook Rd. ','Richardson','TX',75080);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Barry','Buckner',NULL,'barry.buckner@gmail.com','8779 High Noon Rd. ','Centereach','NY',11720);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Boyce','Burks',NULL,'boyce.burks@gmail.com','879 Harvey Dr. ','Sunnyside','NY',11104);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Monty','Frost','(516) 460-5396','monty.frost@aol.com','76 Foxrun Dr. ','Hempstead','NY',11550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tiny','French',NULL,'tiny.french@hotmail.com','7163 Hall St. ','Plainview','NY',11803);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Clementina','Sargent',NULL,'clementina.sargent@hotmail.com','9853 Catherine Road ','Rome','NY',13440);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Danny','Kim',NULL,'danny.kim@msn.com','74 Essex Drive ','South Ozone Park','NY',11420);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sophia','Mcmillan',NULL,'sophia.mcmillan@msn.com','8541 S. Pleasant Street ','Uniondale','NY',11553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Christia','Carson',NULL,'christia.carson@gmail.com','220 Orchard Street ','Helotes','TX',78023);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jennie','Middleton',NULL,'jennie.middleton@gmail.com','95 High Noon Dr. ','Upland','CA',91784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jame','Riggs',NULL,'jame.riggs@hotmail.com','9237 Hudson Drive ','Bay Shore','NY',11706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rayford','Simon',NULL,'rayford.simon@msn.com','998 Whitemarsh Road ','Mountain View','CA',94043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Annett','Garrett',NULL,'annett.garrett@yahoo.com','19 Euclid Lane ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hayden','Cross',NULL,'hayden.cross@gmail.com','90 Pumpkin Hill St. ','Apple Valley','CA',92307);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rolanda','Larsen',NULL,'rolanda.larsen@yahoo.com','5 West University Court ','Woodhaven','NY',11421);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jayme','Zamora',NULL,'jayme.zamora@gmail.com','2 Ridge Lane ','Springfield Gardens','NY',11413);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hope','Cotton',NULL,'hope.cotton@aol.com','9092 Blue Spring Dr. ','Redondo Beach','CA',90278);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vikki','Erickson',NULL,'vikki.erickson@yahoo.com','24 Jones Street ','Kingston','NY',12401);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Fransisca','Nicholson',NULL,'fransisca.nicholson@aol.com','945 Schoolhouse Street ','Glendora','CA',91740);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mazie','Fernandez',NULL,'mazie.fernandez@hotmail.com','583 Harvard Ave. ','Webster','NY',14580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Anderson','Martin',NULL,'anderson.martin@hotmail.com','9051 Hillside Dr. ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gilberto','Parsons',NULL,'gilberto.parsons@gmail.com','8115 North Edgewater Drive ','Middle Village','NY',11379);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Charise','Burt','(559) 888-2229','charise.burt@aol.com','582 Creek St. ','Fresno','CA',93706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cameron','Carroll',NULL,'cameron.carroll@yahoo.com','9133 South Halifax Ave. ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Melani','Jarvis',NULL,'melani.jarvis@hotmail.com','8 Tunnel St. ','Maspeth','NY',11378);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Javier','Nichols',NULL,'javier.nichols@msn.com','8944 Marconi St. ','Rowlett','TX',75088);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Justina','Jenkins',NULL,'justina.jenkins@yahoo.com','8236 Creek St. ','Baldwin','NY',11510);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hortencia','Graham',NULL,'hortencia.graham@aol.com','7764 Greenrose Street ','Euless','TX',76039);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Christia','Wilkins',NULL,'christia.wilkins@msn.com','7062 Willow Court ','Woodside','NY',11377);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Eliz','Whitney',NULL,'eliz.whitney@msn.com','523 Crescent Court ','Fullerton','CA',92831);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Justin','Newton',NULL,'justin.newton@hotmail.com','93 Shore Rd. ','Apple Valley','CA',92307);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Aron','Wiggins','(442) 497-3353','aron.wiggins@aol.com','6 Bradford St. ','Oceanside','NY',11572);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chere','Hardin',NULL,'chere.hardin@yahoo.com','763 Fulton Road ','Brooklyn','NY',11201);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Merideth','Preston',NULL,'merideth.preston@yahoo.com','794 Rockaway St. ','Poughkeepsie','NY',12601);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeniffer','Slater',NULL,'jeniffer.slater@aol.com','30 Old Orange Lane ','Schenectady','NY',12302);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Laureen','Paul',NULL,'laureen.paul@yahoo.com','617 Squaw Creek Rd. ','Bellmore','NY',11710);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Berna','Moore',NULL,'berna.moore@hotmail.com','7230 Lafayette Drive ','Bronx','NY',10451);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shiela','Calderon',NULL,'shiela.calderon@msn.com','844 Albany St. ','Rocklin','CA',95677);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sharie','Alvarez','(212) 211-7621','sharie.alvarez@msn.com','987 West Leatherwood Dr. ','New York','NY',10002);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bettie','Glover',NULL,'bettie.glover@gmail.com','9083 Addison Dr. ','Euless','TX',76039);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marilyn','Frank',NULL,'marilyn.frank@aol.com','8878 Branch Street ','Port Chester','NY',10573);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sheba','Knapp',NULL,'sheba.knapp@aol.com','86 Gates Street ','Woodside','NY',11377);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Aleta','Mack',NULL,'aleta.mack@yahoo.com','8869 W. Edgemont Lane ','Bay Shore','NY',11706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Reena','Higgins',NULL,'reena.higgins@gmail.com','900 South Columbia Street ','Canyon Country','CA',91387);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ami','Mcmahon',NULL,'ami.mcmahon@aol.com','566 Hilldale Drive ','Sunnyside','NY',11104);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Somer','Jordan',NULL,'somer.jordan@msn.com','7046 Helen Avenue ','Huntington Station','NY',11746);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Scarlet','Reed',NULL,'scarlet.reed@hotmail.com','151 S. Myers Court ','Bronx','NY',10451);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Trisha','Johnson','(717) 126-8787','trisha.johnson@msn.com','59 Wild Horse St. ','Lancaster','NY',14086);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Majorie','Wyatt',NULL,'majorie.wyatt@yahoo.com','8507 Miller St. ','South Ozone Park','NY',11420);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Abbey','Pugh',NULL,'abbey.pugh@gmail.com','26 Market Drive ','Forest Hills','NY',11375);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tamela','Harrell',NULL,'tamela.harrell@aol.com','7316 Cypress Rd. ','Central Islip','NY',11722);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yanira','Bradshaw',NULL,'yanira.bradshaw@gmail.com','7484 Ann Court ','Smithtown','NY',11787);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Delana','Scott',NULL,'delana.scott@yahoo.com','7372 Ridgeview St. ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cassondra','Pruitt',NULL,'cassondra.pruitt@aol.com','4 Alderwood Circle ','Merrick','NY',11566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jesica','Fields',NULL,'jesica.fields@yahoo.com','318 Country Dr. ','Commack','NY',11725);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Herta','Rollins',NULL,'herta.rollins@msn.com','287 1st Drive ','Mountain View','CA',94043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mi','Gray','(229) 813-2130','mi.gray@aol.com','27 Roehampton Dr. ','Albany','NY',12203);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jacalyn','Barnett',NULL,'jacalyn.barnett@gmail.com','7537 Swanson Street ','Maspeth','NY',11378);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kanesha','Hudson','(510) 788-7298','kanesha.hudson@gmail.com','8293 Gartner Drive ','Oakland','CA',94603);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Darren','Witt',NULL,'darren.witt@aol.com','916 Hillcrest Ave. ','Coachella','CA',92236);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mable','Pratt',NULL,'mable.pratt@gmail.com','254 SW. Temple Street ','Coachella','CA',92236);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Christoper','Mccall',NULL,'christoper.mccall@msn.com','72 Summit St. ','Bay Shore','NY',11706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Margorie','Wynn',NULL,'margorie.wynn@gmail.com','707 Schoolhouse St. ','Monsey','NY',10952);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Josef','Greer',NULL,'josef.greer@gmail.com','92 Summer Court ','Jamaica','NY',11432);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tisa','Whitney',NULL,'tisa.whitney@yahoo.com','549 Newbridge Dr. ','Monsey','NY',10952);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tonda','Armstrong',NULL,'tonda.armstrong@aol.com','19 Forest Rd. ','Sunnyside','NY',11104);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Arvilla','Weiss',NULL,'arvilla.weiss@msn.com','477 Blue Spring St. ','Bay Shore','NY',11706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vashti','Rosario',NULL,'vashti.rosario@yahoo.com','623 Johnson Circle ','Bronx','NY',10451);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sheri','Cole','(408) 658-2285','sheri.cole@aol.com','479 Chapel Court ','San Jose','CA',95127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kandace','Giles',NULL,'kandace.giles@msn.com','30 NE. Walt Whitman Drive ','Wantagh','NY',11793);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Angie','Powers',NULL,'angie.powers@aol.com','6 Rockland Dr. ','Pomona','CA',91768);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Van','Peters','(281) 658-7772','van.peters@yahoo.com','45 Fifth Dr. ','Houston','TX',77016);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Virgina','Berg',NULL,'virgina.berg@yahoo.com','804 South Purple Finch Drive ','Valley Stream','NY',11580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Olevia','Noel',NULL,'olevia.noel@yahoo.com','39 N. Rosewood Dr. ','Kingston','NY',12401);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kaci','Gallegos',NULL,'kaci.gallegos@gmail.com','8573 Halifax St. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bev','Chang',NULL,'bev.chang@yahoo.com','104 Rockville St. ','Ithaca','NY',14850);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rodger','Rojas',NULL,'rodger.rojas@yahoo.com','8442 Cooper Ave. ','Bayside','NY',11361);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lavonne','Anderson',NULL,'lavonne.anderson@aol.com','9420 Wintergreen Court ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Blanca','Hooper',NULL,'blanca.hooper@msn.com','340 Bald Hill St. ','Ozone Park','NY',11417);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alysha','Powers',NULL,'alysha.powers@msn.com','39 West Marshall Ave. ','Forest Hills','NY',11375);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mary','Singleton',NULL,'mary.singleton@hotmail.com','474 Amerige Ave. ','Woodside','NY',11377);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jina','Cooper',NULL,'jina.cooper@aol.com','8947 W. Lexington Rd. ','Howard Beach','NY',11414);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Loni','Duncan',NULL,'loni.duncan@gmail.com','80 Saxton Lane ','Rosedale','NY',11422);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Collene','Roman',NULL,'collene.roman@aol.com','30 North Argyle Dr. ','Wappingers Falls','NY',12590);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mariette','Trevino',NULL,'mariette.trevino@aol.com','4 Border Court ','Utica','NY',13501);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Candelaria','Coffey',NULL,'candelaria.coffey@aol.com','45 Newport Lane ','Merrick','NY',11566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yan','Trevino',NULL,'yan.trevino@gmail.com','796 Jefferson Rd. ','Uniondale','NY',11553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elanor','Patrick',NULL,'elanor.patrick@aol.com','51 Howard Ave. ','Victoria','TX',77904);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Klara','Mosley',NULL,'klara.mosley@gmail.com','518 Devon Court ','Port Chester','NY',10573);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rosalba','O''neal',NULL,'rosalba.o''neal@yahoo.com','7517 Pennsylvania St. ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mina','Carrillo',NULL,'mina.carrillo@aol.com','8659 Trenton Lane ','Uniondale','NY',11553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alesia','Horne',NULL,'alesia.horne@aol.com','9229 Amherst Lane ','Selden','NY',11784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kristen','Alvarez',NULL,'kristen.alvarez@aol.com','9778 North River St. ','Bronx','NY',10451);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Collin','Webster',NULL,'collin.webster@aol.com','475 Cottage Rd. ','Howard Beach','NY',11414);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ashlee','Pena',NULL,'ashlee.pena@aol.com','966 Highland St. ','Whitestone','NY',11357);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Aimee','Merritt',NULL,'aimee.merritt@yahoo.com','537 East Meadowbrook St. ','Flushing','NY',11354);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rochelle','Ward',NULL,'rochelle.ward@yahoo.com','7855 La Sierra Street ','Glendora','CA',91740);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nelle','Beck',NULL,'nelle.beck@aol.com','8998 Wakehurst Drive ','Upland','CA',91784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kaila','Walters',NULL,'kaila.walters@msn.com','57 Gates Drive ','Elmhurst','NY',11373);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Aleta','Stone',NULL,'aleta.stone@aol.com','8 Elm Dr. ','Whitestone','NY',11357);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Leif','Short',NULL,'leif.short@gmail.com','962 Carpenter Ave. ','San Angelo','TX',76901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lorrie','Pollard',NULL,'lorrie.pollard@yahoo.com','7834 Shore Ave. ','Ronkonkoma','NY',11779);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vernita','Ball',NULL,'vernita.ball@gmail.com','126 Arnold Dr. ','Los Banos','CA',93635);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cyndi','Bush',NULL,'cyndi.bush@gmail.com','18 Smoky Hollow Drive ','Elmhurst','NY',11373);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gertrude','Terry',NULL,'gertrude.terry@hotmail.com','34 Airport Dr. ','Upland','CA',91784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Virgen','Clemons',NULL,'virgen.clemons@gmail.com','354 Cactus Drive ','South El Monte','CA',91733);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Fairy','Robinson',NULL,'fairy.robinson@msn.com','8837 Joy Ridge St. ','Liverpool','NY',13090);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Laverna','Hernandez',NULL,'laverna.hernandez@hotmail.com','34 South Longfellow St. ','Niagara Falls','NY',14304);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeannie','Wilcox',NULL,'jeannie.wilcox@yahoo.com','7744 Miles Dr. ','Franklin Square','NY',11010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Suellen','Mercado',NULL,'suellen.mercado@yahoo.com','3 Taylor Drive ','Sunnyside','NY',11104);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bart','Hess',NULL,'bart.hess@aol.com','799 N. Maiden Street ','Kingston','NY',12401);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alfredo','Dodson',NULL,'alfredo.dodson@hotmail.com','8960 Glenholme Dr. ','Depew','NY',14043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shaunda','Barnett',NULL,'shaunda.barnett@gmail.com','9366 San Carlos Lane ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kerrie','Morton',NULL,'kerrie.morton@hotmail.com','8772 State St. ','Pittsford','NY',14534);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elouise','Fry',NULL,'elouise.fry@aol.com','49 Bohemia Street ','Canyon Country','CA',91387);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Augustus','Steele',NULL,'augustus.steele@aol.com','7474 N. Orchard St. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Greta','Page',NULL,'greta.page@hotmail.com','8316 Augusta Drive ','Commack','NY',11725);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kerrie','O''neill',NULL,'kerrie.o''neill@gmail.com','69 Wellington Ave. ','Shirley','NY',11967);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dannette','Guerrero',NULL,'dannette.guerrero@gmail.com','68 Carriage Street ','San Pablo','CA',94806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Edra','Fitzgerald',NULL,'edra.fitzgerald@msn.com','8892 Birchwood St. ','Central Islip','NY',11722);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jerome','Bolton',NULL,'jerome.bolton@msn.com','9921 Argyle Street ','Carmel','NY',10512);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Conception','Slater',NULL,'conception.slater@gmail.com','5 Sunset Street ','Bellmore','NY',11710);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Octavia','Case','(212) 171-1335','octavia.case@aol.com','40 Charles Road ','New York','NY',10002);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dexter','Roberts',NULL,'dexter.roberts@gmail.com','84 Thatcher Court ','Sunnyside','NY',11104);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ginette','Edwards',NULL,'ginette.edwards@hotmail.com','9262 NW. Center Ave. ','Baldwin','NY',11510);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Romaine','Haley',NULL,'romaine.haley@aol.com','737 Edgefield Drive ','Ithaca','NY',14850);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gwendolyn','Miller',NULL,'gwendolyn.miller@msn.com','90 Fordham Ave. ','Harlingen','TX',78552);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Luke','Fuller','(516) 363-2253','luke.fuller@hotmail.com','576 Cleveland Lane ','Hempstead','NY',11550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Zoraida','Patton',NULL,'zoraida.patton@aol.com','95 Grand Dr. ','Huntington Station','NY',11746);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Georgeanna','Webster','(805) 885-8830','georgeanna.webster@msn.com','40 Creekside Circle ','Oxnard','CA',93035);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Krystin','Marshall',NULL,'krystin.marshall@hotmail.com','10 Old Proctor Lane ','Poughkeepsie','NY',12601);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vince','Schneider',NULL,'vince.schneider@hotmail.com','473 Corona Ave. ','Merrick','NY',11566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Iola','Rasmussen',NULL,'iola.rasmussen@yahoo.com','283 N. Manor Station Dr. ','Monroe','NY',10950);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Valery','Saunders',NULL,'valery.saunders@msn.com','42 Marlborough St. ','Victoria','TX',77904);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Johna','Powers',NULL,'johna.powers@hotmail.com','379 Central Ave. ','Deer Park','NY',11729);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Charleen','Hurst',NULL,'charleen.hurst@yahoo.com','87 Country Avenue ','Utica','NY',13501);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Augustina','Joyner',NULL,'augustina.joyner@aol.com','7931 Honey Creek Court ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Daisy','Ward',NULL,'daisy.ward@msn.com','45 Silver Spear Ave. ','Pomona','CA',91768);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Latonya','Dixon',NULL,'latonya.dixon@hotmail.com','9399 Evergreen Street ','Garland','TX',75043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hipolito','Padilla',NULL,'hipolito.padilla@hotmail.com','311 E. Rose Avenue ','New Rochelle','NY',10801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Emmett','Casey',NULL,'emmett.casey@yahoo.com','893 Logan St. ','Valley Stream','NY',11580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kandi','Mcneil',NULL,'kandi.mcneil@msn.com','402 Border Street ','Massapequa Park','NY',11762);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Luciano','Marsh',NULL,'luciano.marsh@aol.com','7685 South Willow Drive ','Bellmore','NY',11710);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Julius','Holt',NULL,'julius.holt@aol.com','386 Lower River Street ','East Meadow','NY',11554);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Holly','Nieves',NULL,'holly.nieves@aol.com','60 Cleveland St. ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Douglass','Little',NULL,'douglass.little@hotmail.com','294 Harvey Drive ','Duarte','CA',91010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Izola','Hobbs',NULL,'izola.hobbs@gmail.com','685 Beacon Dr. ','Woodhaven','NY',11421);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Honey','Camacho',NULL,'honey.camacho@gmail.com','934 2nd St. ','Bayside','NY',11361);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Laureen','Barry',NULL,'laureen.barry@yahoo.com','909 Ridge St. ','Orchard Park','NY',14127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Katharine','Herrera',NULL,'katharine.herrera@hotmail.com','395 SE. Branch St. ','Queensbury','NY',12804);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sunshine','Rosario',NULL,'sunshine.rosario@aol.com','1 Chestnut Lane ','Jamaica','NY',11432);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yevette','Todd',NULL,'yevette.todd@aol.com','119 Lakewood Rd. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dorthea','Walker',NULL,'dorthea.walker@aol.com','11 Third St. ','Port Washington','NY',11050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alane','Munoz','(914) 706-7576','alane.munoz@gmail.com','8 Strawberry Dr. ','Yonkers','NY',10701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ayana','Keith','(805) 230-2101','ayana.keith@hotmail.com','182 Thorne Road ','Oxnard','CA',93035);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Caridad','Compton',NULL,'caridad.compton@aol.com','9575 SW. Kingston Court ','San Lorenzo','CA',94580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Earline','Ballard',NULL,'earline.ballard@hotmail.com','939 Lyme Road ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nathanael','Bradley',NULL,'nathanael.bradley@aol.com','58 Third St. ','Amsterdam','NY',12010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chasidy','Tran',NULL,'chasidy.tran@msn.com','9286 Anderson Street ','Vista','CA',92083);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Janella','Bright','(507) 616-2958','janella.bright@aol.com','7317 Tower Dr. ','Rochester','NY',14606);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Josie','Schultz',NULL,'josie.schultz@hotmail.com','225 Mammoth Street ','Canyon Country','CA',91387);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ellsworth','Michael',NULL,'ellsworth.michael@yahoo.com','9982 White St. ','Carmel','NY',10512);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jennette','Wooten',NULL,'jennette.wooten@msn.com','8221 Bow Ridge Lane ','Rowlett','TX',75088);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cassandra','Nichols',NULL,'cassandra.nichols@yahoo.com','4 Glenwood Circle ','Hicksville','NY',11801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Courtney','Wyatt',NULL,'courtney.wyatt@gmail.com','369 Arrowhead St. ','Garden City','NY',11530);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Terese','Palmer',NULL,'terese.palmer@hotmail.com','8 Sugar Drive ','Bay Shore','NY',11706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sherita','Cherry',NULL,'sherita.cherry@gmail.com','9636 Old Cedarwood Street ','Liverpool','NY',13090);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Serina','Hensley',NULL,'serina.hensley@yahoo.com','53 Proctor Drive ','Jamaica','NY',11432);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeni','Farley',NULL,'jeni.farley@aol.com','4 Mill Lane ','Richmond Hill','NY',11418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Everett','Vega',NULL,'everett.vega@yahoo.com','7859 James Ave. ','Holbrook','NY',11741);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Latosha','Dalton','(661) 529-4501','latosha.dalton@yahoo.com','59 E. Wintergreen Ave. ','Bakersfield','CA',93306);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Romelia','Myers',NULL,'romelia.myers@msn.com','8630 Brook St. ','Garden City','NY',11530);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Effie','Jenkins','(631) 477-1277','effie.jenkins@msn.com','75 South Glen Eagles Court ','Brentwood','NY',11717);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Efren','Oliver',NULL,'efren.oliver@gmail.com','9343 1st Rd. ','Nanuet','NY',10954);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jerlene','Rios',NULL,'jerlene.rios@yahoo.com','32 Griffin St. ','Plainview','NY',11803);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bess','Mcbride',NULL,'bess.mcbride@yahoo.com','9832 Winchester St. ','Garden City','NY',11530);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Birdie','Kramer','(248) 725-2174','birdie.kramer@hotmail.com','311 Newcastle Dr. ','Troy','NY',12180);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Collen','Hayes',NULL,'collen.hayes@yahoo.com','117 Eagle St. ','Smithtown','NY',11787);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Clare','Neal',NULL,'clare.neal@msn.com','8922 Shady Ave. ','Mahopac','NY',10541);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeanett','Herman',NULL,'jeanett.herman@hotmail.com','839 East Arch Street ','Lindenhurst','NY',11757);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Micki','Rutledge',NULL,'micki.rutledge@aol.com','9868 Marvon Street ','Richmond Hill','NY',11418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Loise','Walker',NULL,'loise.walker@aol.com','201 Glen Eagles St. ','Shirley','NY',11967);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Burma','Summers',NULL,'burma.summers@yahoo.com','890 East Elmwood Street ','Freeport','NY',11520);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Myron','Ruiz',NULL,'myron.ruiz@gmail.com','45 Shadow Brook Lane ','Amityville','NY',11701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lashawna','Richardson',NULL,'lashawna.richardson@hotmail.com','9920 Purple Finch St. ','Baldwin','NY',11510);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lavern','Orr',NULL,'lavern.orr@hotmail.com','913 N. Young Street ','Webster','NY',14580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alec','Peck',NULL,'alec.peck@hotmail.com','4 W. Belmont St. ','Victoria','TX',77904);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Christopher','Richardson',NULL,'christopher.richardson@gmail.com','7846 Windfall Dr. ','Santa Cruz','CA',95060);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Arminda','Weber',NULL,'arminda.weber@yahoo.com','6 Hill Field St. ','Bellmore','NY',11710);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Emmett','Hahn',NULL,'emmett.hahn@hotmail.com','7727 6th St. ','Freeport','NY',11520);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gertha','Mejia',NULL,'gertha.mejia@yahoo.com','518 Orchard St. ','Flushing','NY',11354);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Garland','Weaver',NULL,'garland.weaver@gmail.com','7161 Goldfield Court ','Amsterdam','NY',12010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jayson','Rutledge',NULL,'jayson.rutledge@yahoo.com','8672 Coffee St. ','Lake Jackson','TX',77566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Narcisa','Knapp',NULL,'narcisa.knapp@aol.com','435 Dogwood Dr. ','Amarillo','TX',79106);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gayla','Sims',NULL,'gayla.sims@gmail.com','98 Hall Street ','Lindenhurst','NY',11757);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chelsey','Boyd',NULL,'chelsey.boyd@yahoo.com','9569 Birchpond Ave. ','Euless','TX',76039);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Catherine','Miles',NULL,'catherine.miles@msn.com','7189 Elm Dr. ','East Elmhurst','NY',11369);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Valeri','Marshall',NULL,'valeri.marshall@hotmail.com','494 East Brewery Dr. ','East Meadow','NY',11554);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Grace','Madden',NULL,'grace.madden@gmail.com','606 East Rocky River St. ','San Pablo','CA',94806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Joaquin','Hawkins','(657) 557-1746','joaquin.hawkins@aol.com','3 Oklahoma Lane ','Anaheim','CA',92806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kirstie','Vazquez',NULL,'kirstie.vazquez@gmail.com','8006 Rockland Ave. ','Saratoga Springs','NY',12866);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yu','Mcdonald',NULL,'yu.mcdonald@aol.com','784 Pheasant Rd. ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Celestine','Jacobs',NULL,'celestine.jacobs@gmail.com','87 Hanover Rd. ','Massapequa','NY',11758);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Justa','Thompson',NULL,'justa.thompson@aol.com','43 Manor Ave. ','Corona','NY',11368);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lise','Alvarado',NULL,'lise.alvarado@gmail.com','9816 Newcastle Dr. ','Hamburg','NY',14075);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Pearl','Fox',NULL,'pearl.fox@yahoo.com','9415 Honey Creek Dr. ','Uniondale','NY',11553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Travis','Goodman',NULL,'travis.goodman@yahoo.com','65 Rockcrest Dr. ','Los Banos','CA',93635);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shu','Mays',NULL,'shu.mays@gmail.com','996 St Margarets Lane ','Astoria','NY',11102);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ezra','Fowler',NULL,'ezra.fowler@hotmail.com','16 Pearl St. ','Nanuet','NY',10954);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Edda','Young',NULL,'edda.young@gmail.com','50 S. Airport Street ','North Tonawanda','NY',14120);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lidia','Ashley',NULL,'lidia.ashley@hotmail.com','8436 Meadow St. ','Baldwinsville','NY',13027);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Moira','Lester',NULL,'moira.lester@msn.com','496 Greystone Court ','Jackson Heights','NY',11372);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tony','Hicks','(657) 260-6783','tony.hicks@gmail.com','226 Carriage Street ','Anaheim','CA',92806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Malinda','Baxter',NULL,'malinda.baxter@yahoo.com','7698 Briarwood Ave. ','Whitestone','NY',11357);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marlo','Jefferson',NULL,'marlo.jefferson@gmail.com','39 Trenton Rd. ','Niagara Falls','NY',14304);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tiana','Henderson',NULL,'tiana.henderson@aol.com','62 Orange St. ','Franklin Square','NY',11010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Wilda','Petersen',NULL,'wilda.petersen@aol.com','899 Helen St. ','Jamaica','NY',11432);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Irving','Pitts',NULL,'irving.pitts@msn.com','346 College Court ','Torrance','CA',90505);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sheree','Pena',NULL,'sheree.pena@yahoo.com','822 Virginia Court ','Staten Island','NY',10301);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vance','Taylor','(717) 218-5607','vance.taylor@msn.com','8279 Military Dr. ','Lancaster','NY',14086);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Terra','Pickett',NULL,'terra.pickett@aol.com','7822 Depot Avenue ','Amsterdam','NY',12010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Faustino','Delacruz',NULL,'faustino.delacruz@msn.com','88 West Greenview Street ','South Richmond Hill','NY',11419);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Julienne','Moody','(682) 841-4643','julienne.moody@hotmail.com','35 South Oxford Rd. ','Fort Worth','TX',76110);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hee','Greer',NULL,'hee.greer@hotmail.com','41 North Garfield Ave. ','Selden','NY',11784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Whitney','Cash',NULL,'whitney.cash@gmail.com','8 Surrey Street ','Hamburg','NY',14075);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Clarita','Curry',NULL,'clarita.curry@hotmail.com','661 Tanglewood Street ','Hollis','NY',11423);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Reita','Dickson',NULL,'reita.dickson@hotmail.com','7506 Mechanic Dr. ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rosa','Kinney',NULL,'rosa.kinney@yahoo.com','330 Highland Drive ','Brooklyn','NY',11201);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Buford','Gilbert',NULL,'buford.gilbert@yahoo.com','9 East Ketch Harbour Street ','Bellmore','NY',11710);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Homer','Powers',NULL,'homer.powers@msn.com','8207 East El Dorado Ave. ','Palos Verdes Peninsula','CA',90274);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rudolf','Gilliam',NULL,'rudolf.gilliam@aol.com','17 Marlborough Circle ','Palos Verdes Peninsula','CA',90274);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Andreas','Herman',NULL,'andreas.herman@msn.com','456 Rock Creek Street ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Max','Charles',NULL,'max.charles@gmail.com','695 St Paul Street ','Glen Cove','NY',11542);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tammera','Fischer','(510) 534-8845','tammera.fischer@hotmail.com','405 Olive St. ','Oakland','CA',94603);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Joshua','Robertson',NULL,'joshua.robertson@gmail.com','81 Campfire Court ','Patchogue','NY',11772);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Larraine','Horn',NULL,'larraine.horn@msn.com','368 South Summerhouse Dr. ','Utica','NY',13501);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Andreas','Mayer',NULL,'andreas.mayer@hotmail.com','8577 Galvin Circle ','New Rochelle','NY',10801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lazaro','Moran',NULL,'lazaro.moran@gmail.com','83 E. Buttonwood Street ','Sugar Land','TX',77478);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Afton','Juarez',NULL,'afton.juarez@gmail.com','8330 Riverview Drive ','Coram','NY',11727);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Angele','Schroeder','(845) 804-6312','angele.schroeder@yahoo.com','33 S. Shadow Brook Street ','New City','NY',10956);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ellena','Clements',NULL,'ellena.clements@aol.com','7918 Mulberry Street ','Santa Monica','CA',90403);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Selene','Austin',NULL,'selene.austin@msn.com','9042 Linda Circle ','Duarte','CA',91010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kimberely','Bowen','(248) 199-2582','kimberely.bowen@hotmail.com','88 Belmont Street ','Troy','NY',12180);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mia','Delgado',NULL,'mia.delgado@yahoo.com','850 Wakehurst Drive ','Coachella','CA',92236);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Garret','Clay','(361) 687-9477','garret.clay@yahoo.com','9516 College Drive ','Corpus Christi','TX',78418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alejandro','Haney',NULL,'alejandro.haney@msn.com','3 Griffin Street ','Wantagh','NY',11793);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Inge','Olsen','(562) 719-5041','inge.olsen@msn.com','295 Iroquois Rd. ','Long Beach','NY',11561);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Christiane','Bradford',NULL,'christiane.bradford@gmail.com','9043 Woodland Ave. ','Orchard Park','NY',14127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carter','Bentley',NULL,'carter.bentley@yahoo.com','145 North Bridle Ave. ','Carmel','NY',10512);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sherie','Ayala',NULL,'sherie.ayala@msn.com','5 Beech Ave. ','South El Monte','CA',91733);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jamika','Acevedo',NULL,'jamika.acevedo@yahoo.com','8027 NW. Poplar St. ','Ozone Park','NY',11417);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shery','Randolph',NULL,'shery.randolph@hotmail.com','602 Laurel Street ','Ontario','CA',91762);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lanita','Burton',NULL,'lanita.burton@msn.com','8980 Aspen Avenue ','Coachella','CA',92236);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Timothy','Byers',NULL,'timothy.byers@msn.com','8645 Devonshire Lane ','Ronkonkoma','NY',11779);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jasmin','Young',NULL,'jasmin.young@gmail.com','337 Beach Street ','Helotes','TX',78023);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Catarina','Mendez',NULL,'catarina.mendez@hotmail.com','444 Hanover Court ','West Islip','NY',11795);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tajuana','Rollins',NULL,'tajuana.rollins@msn.com','724 N. Glen Creek Street ','Oswego','NY',13126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Thad','Castro','(631) 943-1407','thad.castro@msn.com','71 Surrey Ave. ','Brentwood','NY',11717);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tena','Huber',NULL,'tena.huber@gmail.com','185 East Littleton St. ','Newburgh','NY',12550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dori','Alvarez',NULL,'dori.alvarez@msn.com','8208 Brandywine St. ','Kingston','NY',12401);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elmo','Arnold','(562) 841-9339','elmo.arnold@aol.com','7616 Lyme Rd. ','Long Beach','NY',11561);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Felicidad','Golden',NULL,'felicidad.golden@yahoo.com','9712 Coffee Ave. ','Lockport','NY',14094);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jenine','Crane','(682) 183-6555','jenine.crane@msn.com','7381 Alderwood Drive ','Fort Worth','TX',76110);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lea','Key',NULL,'lea.key@yahoo.com','7 Ocean St. ','Banning','CA',92220);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rory','Cooper',NULL,'rory.cooper@gmail.com','459 West Street ','Rocklin','CA',95677);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hilde','Nieves',NULL,'hilde.nieves@gmail.com','9437 Fordham Lane ','Campbell','CA',95008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marry','Benjamin',NULL,'marry.benjamin@yahoo.com','33 Amerige Street ','Forney','TX',75126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vernell','Goff',NULL,'vernell.goff@msn.com','77 Cobblestone St. ','Monroe','NY',10950);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Erlene','Cook',NULL,'erlene.cook@gmail.com','89 Blue Spring Street ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carroll','Kelly',NULL,'carroll.kelly@yahoo.com','346 Grant Circle ','Monroe','NY',10950);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Basilia','Thornton','(631) 592-9548','basilia.thornton@hotmail.com','9033 Pine Dr. ','Brentwood','NY',11717);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tricia','Daniels',NULL,'tricia.daniels@gmail.com','8628 Crescent Court ','Forney','TX',75126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kandace','Hughes',NULL,'kandace.hughes@hotmail.com','482 Ryan Ave. ','San Lorenzo','CA',94580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alejandro','Norman',NULL,'alejandro.norman@yahoo.com','8918 Marsh Lane ','Upland','CA',91784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rodney','Odom',NULL,'rodney.odom@yahoo.com','7782 North Deerfield Lane ','Richmond Hill','NY',11418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bettie','Pierce',NULL,'bettie.pierce@gmail.com','787 North Vernon Lane ','Farmingdale','NY',11735);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dagny','Owen',NULL,'dagny.owen@hotmail.com','8028 Thompson Drive ','San Angelo','TX',76901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cinthia','Poole',NULL,'cinthia.poole@aol.com','7 Central Ave. ','Lake Jackson','TX',77566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sheila','Travis',NULL,'sheila.travis@yahoo.com','9285 Front St. ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Arcelia','Vinson',NULL,'arcelia.vinson@gmail.com','40 Dogwood St. ','West Islip','NY',11795);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lucas','Estes',NULL,'lucas.estes@yahoo.com','99 Old Church St. ','Santa Monica','CA',90403);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marissa','Summers',NULL,'marissa.summers@msn.com','81 Carpenter St. ','Saint Albans','NY',11412);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kaley','Blanchard',NULL,'kaley.blanchard@msn.com','74 Evergreen Court ','Palos Verdes Peninsula','CA',90274);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Wm','Pope',NULL,'wm.pope@msn.com','212 Marsh Court ','Auburn','NY',13021);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rubye','Mccall','(248) 764-3359','rubye.mccall@hotmail.com','71 Sherwood Dr. ','Troy','NY',12180);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Adriene','Rivera',NULL,'adriene.rivera@hotmail.com','973 Yukon Avenue ','Encino','CA',91316);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Laurence','Christian',NULL,'laurence.christian@gmail.com','2 Maple St. ','Jamaica','NY',11432);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shirely','Stanley','(915) 437-6113','shirely.stanley@gmail.com','73 White Avenue ','El Paso','TX',79930);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Danille','Mcfarland',NULL,'danille.mcfarland@msn.com','14 Tailwater St. ','Rocklin','CA',95677);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Salena','Day',NULL,'salena.day@msn.com','8067 Park Court ','San Lorenzo','CA',94580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Matilda','Larson',NULL,'matilda.larson@hotmail.com','336 Saxon Court ','Harlingen','TX',78552);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mellisa','Kim','(424) 151-6481','mellisa.kim@aol.com','17 Lyme Dr. ','Los Angeles','CA',90008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vonda','Berger',NULL,'vonda.berger@yahoo.com','615 S. Proctor Ave. ','Santa Clara','CA',95050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Soledad','Moses',NULL,'soledad.moses@yahoo.com','85 Hickory Ave. ','Jackson Heights','NY',11372);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lashandra','Turner','(562) 327-9469','lashandra.turner@hotmail.com','11 Marlborough Rd. ','Long Beach','NY',11561);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lynne','Anderson','(915) 789-6666','lynne.anderson@msn.com','325 Inverness St. ','El Paso','TX',79930);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chasidy','Webster',NULL,'chasidy.webster@msn.com','8296 S. Lookout Lane ','Rocklin','CA',95677);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ulysses','Gaines',NULL,'ulysses.gaines@aol.com','22 Gregory Lane ','Monsey','NY',10952);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Euna','Lopez',NULL,'euna.lopez@gmail.com','7979 South Mountainview Ave. ','Carmel','NY',10512);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cherelle','Key',NULL,'cherelle.key@msn.com','7739 Snake Hill Lane ','Valley Stream','NY',11580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeffry','Church',NULL,'jeffry.church@msn.com','426 Grandrose Ave. ','Pleasanton','CA',94566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cyndi','Dyer',NULL,'cyndi.dyer@msn.com','313 West Argyle Ave. ','Baldwin','NY',11510);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Danilo','Holmes',NULL,'danilo.holmes@gmail.com','657 Manor Station Dr. ','Hicksville','NY',11801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Joni','Lee',NULL,'joni.lee@gmail.com','8573 Proctor Street ','Centereach','NY',11720);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Antony','Atkinson',NULL,'antony.atkinson@msn.com','680 East Birchwood Lane ','Smithtown','NY',11787);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Deanne','Parsons',NULL,'deanne.parsons@aol.com','76 Amherst Drive ','Lindenhurst','NY',11757);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Frederica','Rojas',NULL,'frederica.rojas@yahoo.com','7835 West Jockey Hollow Rd. ','Ithaca','NY',14850);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Emelda','Dickerson',NULL,'emelda.dickerson@aol.com','7457 6th St. ','Hamburg','NY',14075);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rudolf','Moran',NULL,'rudolf.moran@gmail.com','5 Birchwood Rd. ','Maspeth','NY',11378);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Benito','Hendrix',NULL,'benito.hendrix@gmail.com','676 S. Bowman Lane ','Depew','NY',14043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jonell','Rivas',NULL,'jonell.rivas@msn.com','8415 East High Point St. ','Amarillo','TX',79106);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Joi','Reeves','(619) 952-9613','joi.reeves@msn.com','9101 Williams Court ','San Diego','CA',92111);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Leland','Mcdowell',NULL,'leland.mcdowell@gmail.com','8034 E. Washington Lane ','Encino','CA',91316);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Delaine','Estes',NULL,'delaine.estes@yahoo.com','8916 Hartford Rd. ','Amarillo','TX',79106);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Genevieve','Juarez',NULL,'genevieve.juarez@gmail.com','93 Goldfield Drive ','New Hyde Park','NY',11040);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kylee','Dickson',NULL,'kylee.dickson@gmail.com','7908 Sherwood Street ','Amityville','NY',11701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Renita','Henry',NULL,'renita.henry@msn.com','474 Woodland Ave. ','New Rochelle','NY',10801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sarah','Kirkland',NULL,'sarah.kirkland@aol.com','42 N. Glendale Avenue ','Wappingers Falls','NY',12590);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Paul','Lester',NULL,'paul.lester@gmail.com','275 Clay St. ','Vista','CA',92083);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Taisha','Vang',NULL,'taisha.vang@yahoo.com','660 East Foster Lane ','Shirley','NY',11967);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Eliana','Reese',NULL,'eliana.reese@hotmail.com','7079 NE. Cross Drive ','Woodhaven','NY',11421);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Leonore','Dorsey',NULL,'leonore.dorsey@yahoo.com','8213 South Branch Avenue ','Jackson Heights','NY',11372);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ashleigh','Frank',NULL,'ashleigh.frank@gmail.com','9008 Plymouth Street ','Levittown','NY',11756);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gabriel','Wagner',NULL,'gabriel.wagner@msn.com','7921 Manhattan Ave. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Margene','Eaton',NULL,'margene.eaton@yahoo.com','43 Sugar Street ','Wantagh','NY',11793);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Toshia','Cardenas',NULL,'toshia.cardenas@gmail.com','878 Bayberry Street ','Amsterdam','NY',12010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jamika','Blanchard',NULL,'jamika.blanchard@gmail.com','420 Cambridge Street ','Fresh Meadows','NY',11365);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shery','Acosta',NULL,'shery.acosta@yahoo.com','17 Canal Ave. ','Saratoga Springs','NY',12866);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jenna','Saunders',NULL,'jenna.saunders@aol.com','4 Young St. ','Yorktown Heights','NY',10598);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Skye','Pope',NULL,'skye.pope@yahoo.com','121 S. Bay Meadows Ave. ','Richmond Hill','NY',11418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ana','Palmer','(657) 323-8684','ana.palmer@yahoo.com','7 Buckingham St. ','Anaheim','CA',92806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Eric','Hardin',NULL,'eric.hardin@gmail.com','39 S. Parker Drive ','Jamaica','NY',11432);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Basil','Ballard',NULL,'basil.ballard@yahoo.com','7477 Belmont Ave. ','San Lorenzo','CA',94580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gabriel','Pitts',NULL,'gabriel.pitts@gmail.com','8462 Marshall Drive ','Clifton Park','NY',12065);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cayla','Johnson',NULL,'cayla.johnson@msn.com','7091 Rockaway Avenue ','Coram','NY',11727);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sharika','Colon','(562) 452-6136','sharika.colon@gmail.com','509 Henry Smith St. ','Long Beach','NY',11561);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Donnetta','Henson',NULL,'donnetta.henson@hotmail.com','2 Tallwood Drive ','Webster','NY',14580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Leigh','Burke',NULL,'leigh.burke@hotmail.com','7651 Creek St. ','Schenectady','NY',12302);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Deloris','Larson',NULL,'deloris.larson@aol.com','242 Branch Street ','Duarte','CA',91010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ehtel','Cobb',NULL,'ehtel.cobb@hotmail.com','741 Rockville Drive ','Lockport','NY',14094);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Evelina','Byrd','(716) 601-7704','evelina.byrd@msn.com','628 S. Church St. ','Buffalo','NY',14215);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Zulema','Browning',NULL,'zulema.browning@gmail.com','12 NW. Lafayette St. ','Amsterdam','NY',12010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tressa','Weiss',NULL,'tressa.weiss@msn.com','52 Wild Rose Avenue ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yvette','Rogers',NULL,'yvette.rogers@aol.com','3 SE. Oklahoma Drive ','Franklin Square','NY',11010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kiara','Deleon','(657) 378-8011','kiara.deleon@gmail.com','164 Addison Drive ','Anaheim','CA',92806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Taylor','Cole',NULL,'taylor.cole@gmail.com','9408 Holly Lane ','Carmel','NY',10512);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Myrtie','James',NULL,'myrtie.james@yahoo.com','566 North Livingston Ave. ','Merrick','NY',11566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ashton','Lott',NULL,'ashton.lott@hotmail.com','609 Windfall Lane ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kara','Higgins',NULL,'kara.higgins@aol.com','758 Jennings Street ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tomeka','Higgins',NULL,'tomeka.higgins@msn.com','591 W. Corona St. ','Poughkeepsie','NY',12601);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ronald','Parsons',NULL,'ronald.parsons@msn.com','268 Pin Oak Rd. ','Maspeth','NY',11378);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Allison','Nolan','(845) 276-5729','allison.nolan@gmail.com','7421 Victoria St. ','New City','NY',10956);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Derrick','Marks',NULL,'derrick.marks@yahoo.com','7247 East Prairie Lane ','Glendora','CA',91740);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yang','Roth',NULL,'yang.roth@aol.com','234 E. Shub Farm Ave. ','Webster','NY',14580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Melba','Wilkinson',NULL,'melba.wilkinson@gmail.com','255 Harvard Dr. ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Valentin','Mclaughlin',NULL,'valentin.mclaughlin@hotmail.com','56 Squaw Creek Street ','Lindenhurst','NY',11757);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lewis','Garner','(631) 871-2512','lewis.garner@gmail.com','9550 East Greenrose St. ','Brentwood','NY',11717);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ann','Heath',NULL,'ann.heath@msn.com','413 East St. ','South El Monte','CA',91733);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Janelle','Maldonado',NULL,'janelle.maldonado@gmail.com','34 Mammoth Street ','Richmond Hill','NY',11418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Catrice','Hicks',NULL,'catrice.hicks@yahoo.com','403 Inverness Street ','San Pablo','CA',94806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Eli','Contreras',NULL,'eli.contreras@hotmail.com','35 Highland Ave. ','Ronkonkoma','NY',11779);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rita','Bailey',NULL,'rita.bailey@hotmail.com','69 Glenwood Street ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Laure','Pena',NULL,'laure.pena@yahoo.com','9849 West Elmwood St. ','Wappingers Falls','NY',12590);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tilda','Melton','(248) 767-4165','tilda.melton@msn.com','237 Elmwood Drive ','Troy','NY',12180);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Florencio','Davenport',NULL,'florencio.davenport@yahoo.com','8759 Brookside Ave. ','Jamestown','NY',14701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Eun','Harris','(619) 378-2432','eun.harris@gmail.com','623 Jones St. ','San Diego','CA',92111);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marylyn','Browning',NULL,'marylyn.browning@msn.com','915 Lakeshore Street ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Romana','Barnes',NULL,'romana.barnes@yahoo.com','9776 Shipley Rd. ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sam','Lester',NULL,'sam.lester@gmail.com','563 South Beacon Lane ','Baldwin','NY',11510);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nicki','Larson',NULL,'nicki.larson@yahoo.com','8317 West Leatherwood Dr. ','Monsey','NY',10952);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Antonetta','Rocha',NULL,'antonetta.rocha@yahoo.com','9858 Newcastle St. ','Port Chester','NY',10573);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shara','Pope',NULL,'shara.pope@msn.com','194 Amherst Dr. ','Ridgecrest','CA',93555);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Trena','Hudson',NULL,'trena.hudson@hotmail.com','135 Grand Ave. ','Monroe','NY',10950);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Loraine','Sykes',NULL,'loraine.sykes@yahoo.com','9239 Windsor Ave. ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alissa','Hood',NULL,'alissa.hood@gmail.com','8032 Maple Drive ','New Windsor','NY',12553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Augustus','Schmidt',NULL,'augustus.schmidt@msn.com','624 Jones Dr. ','Corona','NY',11368);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Stacie','Sims','(510) 194-5117','stacie.sims@hotmail.com','47 Orange Ave. ','Oakland','CA',94603);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Brittni','Green',NULL,'brittni.green@msn.com','842 El Dorado Lane ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Etsuko','Garrison',NULL,'etsuko.garrison@yahoo.com','1 Arrowhead Street ','Richmond Hill','NY',11418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Calandra','Stanton',NULL,'calandra.stanton@aol.com','36 Livingston Dr. ','Lake Jackson','TX',77566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Willis','Randolph',NULL,'willis.randolph@yahoo.com','332 Constitution St. ','Harlingen','TX',78552);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shawnda','Glover',NULL,'shawnda.glover@gmail.com','138 Belmont Ave. ','Liverpool','NY',13090);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jennette','Baker',NULL,'jennette.baker@gmail.com','798 Marvon St. ','Banning','CA',92220);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elma','Molina',NULL,'elma.molina@msn.com','8565 Devon Ave. ','New Rochelle','NY',10801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Adam','Henderson',NULL,'adam.henderson@hotmail.com','167 James St. ','Los Banos','CA',93635);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ira','Moore',NULL,'ira.moore@gmail.com','1 Pineknoll Court ','Saratoga Springs','NY',12866);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kermit','Bowman','(915) 996-5952','kermit.bowman@gmail.com','3 Airport Street ','El Paso','TX',79930);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gayle','Wilkinson',NULL,'gayle.wilkinson@yahoo.com','4 Riverside Ave. ','Lindenhurst','NY',11757);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Launa','Hull',NULL,'launa.hull@yahoo.com','936 Grove Street ','Helotes','TX',78023);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Myron','Johns',NULL,'myron.johns@msn.com','5 N. Woodsman Rd. ','Whitestone','NY',11357);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tuan','Wolfe',NULL,'tuan.wolfe@aol.com','7641 Oak Meadow Dr. ','West Babylon','NY',11704);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mathilda','Pennington','(845) 407-9524','mathilda.pennington@gmail.com','14 S. Argyle Ave. ','New City','NY',10956);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Reatha','Perez',NULL,'reatha.perez@aol.com','9917 1st St. ','Holbrook','NY',11741);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Arnita','Thomas',NULL,'arnita.thomas@gmail.com','154 2nd St. ','Orchard Park','NY',14127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Amparo','Burks',NULL,'amparo.burks@aol.com','7781 Augusta St. ','Merrick','NY',11566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jenny','Bell',NULL,'jenny.bell@hotmail.com','38 Crescent St. ','Niagara Falls','NY',14304);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Laverne','Craft',NULL,'laverne.craft@aol.com','829 N. Pierce Street ','Forest Hills','NY',11375);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Darcel','Harmon',NULL,'darcel.harmon@msn.com','966 Hickory Street ','Santa Clara','CA',95050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cecilia','Camacho',NULL,'cecilia.camacho@yahoo.com','682 Mountainview Rd. ','Desoto','TX',75115);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Pearlie','Cochran',NULL,'pearlie.cochran@msn.com','23 Homewood Rd. ','Campbell','CA',95008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Deirdre','Ryan',NULL,'deirdre.ryan@yahoo.com','83 Jefferson Lane ','Utica','NY',13501);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yevette','Elliott',NULL,'yevette.elliott@aol.com','182 Euclid Street ','Jackson Heights','NY',11372);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ladawn','Downs','(281) 165-2090','ladawn.downs@yahoo.com','7452 S. Airport Court ','Houston','TX',77016);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dorothea','Chang',NULL,'dorothea.chang@gmail.com','75 Oak Ave. ','Astoria','NY',11102);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Merlin','Foreman','(516) 150-1321','merlin.foreman@msn.com','8198 North Rockaway St. ','Hempstead','NY',11550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lanie','Dunn',NULL,'lanie.dunn@gmail.com','7583 Pilgrim Ave. ','North Tonawanda','NY',14120);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Christoper','Gould',NULL,'christoper.gould@aol.com','8718 South Constitution St. ','Shirley','NY',11967);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Norine','Huffman',NULL,'norine.huffman@aol.com','363 Dunbar Drive ','Encino','CA',91316);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alane','Mccarty','(619) 377-8586','alane.mccarty@hotmail.com','8254 Hilldale Street ','San Diego','CA',92111);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Charleen','Joyner',NULL,'charleen.joyner@aol.com','735 N. John Dr. ','Corona','NY',11368);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Zella','Fernandez',NULL,'zella.fernandez@yahoo.com','8 Marshall Dr. ','Rockville Centre','NY',11570);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Collene','Knox','(361) 760-1523','collene.knox@msn.com','7 North Branch Lane ','Corpus Christi','TX',78418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alysia','Nicholson','(805) 493-7311','alysia.nicholson@hotmail.com','868 Trusel St. ','Oxnard','CA',93035);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sharie','Whitaker',NULL,'sharie.whitaker@hotmail.com','7 Bayport Lane ','Merrick','NY',11566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Diana','Cobb',NULL,'diana.cobb@hotmail.com','558 Vale St. ','Fullerton','CA',92831);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Morton','Barron','(661) 386-4884','morton.barron@msn.com','542 Circle Rd. ','Bakersfield','CA',93306);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Camille','Harvey',NULL,'camille.harvey@hotmail.com','859 Beaver Ridge Ave. ','Huntington','NY',11743);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lolita','O''neill',NULL,'lolita.o''neill@aol.com','36 Prairie Dr. ','Massapequa Park','NY',11762);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Terese','Briggs',NULL,'terese.briggs@msn.com','16 N. Oak Valley St. ','Woodside','NY',11377);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Majorie','Glover',NULL,'majorie.glover@msn.com','4 Garden Ave. ','Apple Valley','CA',92307);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vinnie','Chan',NULL,'vinnie.chan@aol.com','8750 Surrey St. ','Forest Hills','NY',11375);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ezra','Silva',NULL,'ezra.silva@msn.com','8629 Catherine Rd. ','New Windsor','NY',12553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jovita','Bishop',NULL,'jovita.bishop@aol.com','8123 Wild Horse St. ','Staten Island','NY',10301);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kecia','Olsen',NULL,'kecia.olsen@msn.com','8389 Central St. ','Santa Cruz','CA',95060);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ilona','Spears',NULL,'ilona.spears@gmail.com','984 Canterbury Lane ','Port Jefferson Station','NY',11776);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Senaida','Thompson',NULL,'senaida.thompson@msn.com','578 Golf Drive ','Bronx','NY',10451);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Larae','Carney',NULL,'larae.carney@msn.com','9322 Glen Ridge Dr. ','Sunnyside','NY',11104);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sebrina','Hart',NULL,'sebrina.hart@yahoo.com','7679 Pacific St. ','Coram','NY',11727);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kristofer','Craig',NULL,'kristofer.craig@yahoo.com','6 Delaware Lane ','Plainview','NY',11803);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Luciana','Mcgee',NULL,'luciana.mcgee@msn.com','8002 Cross St. ','Selden','NY',11784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nicki','Fry',NULL,'nicki.fry@hotmail.com','950 Snake Hill Lane ','Endicott','NY',13760);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Devin','Shaffer','(507) 557-2191','devin.shaffer@gmail.com','382 Third Ave. ','Rochester','NY',14606);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Erlinda','Osborne',NULL,'erlinda.osborne@yahoo.com','148 Elm St. ','West Islip','NY',11795);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Camila','Carroll','(210) 436-8676','camila.carroll@yahoo.com','72 Shub Farm Avenue ','San Antonio','TX',78213);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vicki','Wiggins',NULL,'vicki.wiggins@hotmail.com','71 Broad Ave. ','Wappingers Falls','NY',12590);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lois','Steele',NULL,'lois.steele@yahoo.com','7501 South Marlborough Street ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carola','Mcpherson',NULL,'carola.mcpherson@hotmail.com','578 Shirley Dr. ','Rego Park','NY',11374);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rochell','Cantrell',NULL,'rochell.cantrell@yahoo.com','437 Water Dr. ','Port Jefferson Station','NY',11776);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kasha','Sullivan',NULL,'kasha.sullivan@hotmail.com','48 Foster Rd. ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Viva','Dawson',NULL,'viva.dawson@yahoo.com','446 Princess Ave. ','Orchard Park','NY',14127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hue','Dalton',NULL,'hue.dalton@hotmail.com','7940 Oakwood Street ','Apple Valley','CA',92307);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Andria','Rivers',NULL,'andria.rivers@aol.com','183 Ohio Ave. ','Amarillo','TX',79106);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hilary','Savage','(805) 753-6881','hilary.savage@yahoo.com','696 Howard Court ','Oxnard','CA',93035);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lavona','Austin',NULL,'lavona.austin@yahoo.com','926 South Euclid St. ','Utica','NY',13501);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Doreatha','Ford',NULL,'doreatha.ford@yahoo.com','9413 Ryan Ave. ','Huntington','NY',11743);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alina','Mcleod',NULL,'alina.mcleod@msn.com','20 Winchester Street ','Patchogue','NY',11772);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Aide','Franco',NULL,'aide.franco@msn.com','8017 Lake Forest St. ','Atwater','CA',95301);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Genny','Hensley',NULL,'genny.hensley@yahoo.com','8849 Marconi Ave. ','Redondo Beach','CA',90278);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Melita','Dominguez',NULL,'melita.dominguez@msn.com','9903 Santa Clara Lane ','Auburn','NY',13021);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Fannie','Jenkins','(805) 774-5696','fannie.jenkins@msn.com','7858 E. Pawnee Dr. ','Oxnard','CA',93035);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bobbi','Banks',NULL,'bobbi.banks@yahoo.com','396 Wagon Rd. ','Bayside','NY',11361);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gwenn','Melton',NULL,'gwenn.melton@yahoo.com','9545 Wakehurst Drive ','Centereach','NY',11720);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Laci','Castro',NULL,'laci.castro@hotmail.com','130 Birchpond Street ','Saint Albans','NY',11412);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Evelina','Manning',NULL,'evelina.manning@aol.com','7515 Spring St. ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tania','Swanson',NULL,'tania.swanson@yahoo.com','8646 Glen Eagles Ave. ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Laurel','Schultz',NULL,'laurel.schultz@hotmail.com','812 E. 1st Lane ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carolyne','Conley',NULL,'carolyne.conley@gmail.com','431 Lees Creek Drive ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Eldridge','Greer',NULL,'eldridge.greer@aol.com','131 E. Madison St. ','Central Islip','NY',11722);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Margret','Barnett',NULL,'margret.barnett@gmail.com','7509 Depot Rd. ','Forney','TX',75126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Oliva','Blackwell',NULL,'oliva.blackwell@hotmail.com','54 Ramblewood St. ','Elmhurst','NY',11373);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Oralia','Farley',NULL,'oralia.farley@hotmail.com','747B E. Coffee Street ','Upland','CA',91784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Romaine','Salazar',NULL,'romaine.salazar@yahoo.com','7700 Wentworth Rd. ','Monsey','NY',10952);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hermila','Mckay',NULL,'hermila.mckay@yahoo.com','23 Garfield Dr. ','Coachella','CA',92236);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lloyd','Miranda',NULL,'lloyd.miranda@hotmail.com','9098 Jennings St. ','Encino','CA',91316);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mandi','Gibbs',NULL,'mandi.gibbs@gmail.com','80 Sycamore Drive ','East Elmhurst','NY',11369);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hue','May',NULL,'hue.may@aol.com','19 S. Lawrence Dr. ','Valley Stream','NY',11580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tomika','Wilder',NULL,'tomika.wilder@aol.com','142 South Ocean St. ','New Hyde Park','NY',11040);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Graig','Roth',NULL,'graig.roth@aol.com','7516 Wrangler Street ','West Babylon','NY',11704);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lamar','Greer',NULL,'lamar.greer@gmail.com','7909 Golden Star Ave. ','Levittown','NY',11756);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Raymonde','Garcia',NULL,'raymonde.garcia@aol.com','55 NE. North St. ','Queensbury','NY',12804);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cira','Downs','(510) 788-4456','cira.downs@gmail.com','672 Sussex Ave. ','Oakland','CA',94603);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marisa','Chambers',NULL,'marisa.chambers@msn.com','15 E. Rock Creek Ave. ','Amityville','NY',11701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rod','Hatfield',NULL,'rod.hatfield@hotmail.com','7090 Bridge Dr. ','Ronkonkoma','NY',11779);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Quyen','Houston',NULL,'quyen.houston@gmail.com','7758 Homewood Dr. ','Central Islip','NY',11722);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Han','Schneider',NULL,'han.schneider@gmail.com','40 Holly Street ','Elmhurst','NY',11373);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Terrell','Mathis',NULL,'terrell.mathis@aol.com','9320 Center Ave. ','Selden','NY',11784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Spring','Hayes',NULL,'spring.hayes@hotmail.com','8591 Wentworth St. ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lecia','Hancock',NULL,'lecia.hancock@hotmail.com','9167 Pineknoll St. ','Schenectady','NY',12302);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Twana','Arnold','(657) 988-1904','twana.arnold@msn.com','47 North Fairground Lane ','Anaheim','CA',92806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yvone','Yates',NULL,'yvone.yates@gmail.com','9269 Blue Spring Ave. ','San Pablo','CA',94806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Agatha','Melton',NULL,'agatha.melton@yahoo.com','89 East Illinois Street ','Springfield Gardens','NY',11413);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lavonda','Stephenson',NULL,'lavonda.stephenson@gmail.com','37 Birchwood Dr. ','Bay Shore','NY',11706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Agnes','Sims','(716) 780-9901','agnes.sims@aol.com','170 Queen Lane ','Buffalo','NY',14215);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Latricia','Lindsey',NULL,'latricia.lindsey@hotmail.com','288 Campfire Dr. ','Yorktown Heights','NY',10598);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yolando','Wade',NULL,'yolando.wade@hotmail.com','310 Wilson Ave. ','Massapequa','NY',11758);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nenita','Mooney',NULL,'nenita.mooney@hotmail.com','10 W. Bishop Street ','Lawndale','CA',90260);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kermit','Hyde',NULL,'kermit.hyde@hotmail.com','87 SE. Carson St. ','Patchogue','NY',11772);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Angelique','Merrill',NULL,'angelique.merrill@gmail.com','8490 West High Noon Ave. ','South El Monte','CA',91733);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ilda','Roberson',NULL,'ilda.roberson@aol.com','8853 Lake St. ','Kingston','NY',12401);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Corrinne','Garrison',NULL,'corrinne.garrison@yahoo.com','81 East Glenwood Ave. ','Victoria','TX',77904);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Major','Merrill',NULL,'major.merrill@aol.com','78 Thatcher Court ','Astoria','NY',11102);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ouida','Gregory',NULL,'ouida.gregory@aol.com','7984 8th Street ','Merrick','NY',11566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tajuana','Riddle',NULL,'tajuana.riddle@hotmail.com','24 St Margarets Ave. ','Bayside','NY',11361);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ricki','Bullock',NULL,'ricki.bullock@hotmail.com','79 Pennington Rd. ','Woodside','NY',11377);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Celestine','Kent','(717) 890-4260','celestine.kent@aol.com','697 Fordham Street ','Lancaster','NY',14086);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Debbra','Jacobson',NULL,'debbra.jacobson@yahoo.com','8316 West Bedford Ave. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kandis','Mills',NULL,'kandis.mills@hotmail.com','64 Beechwood Drive ','Hamburg','NY',14075);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Wallace','Lane',NULL,'wallace.lane@aol.com','901 Liberty St. ','South Richmond Hill','NY',11419);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Malisa','Mitchell',NULL,'malisa.mitchell@msn.com','87 Ridgewood Court ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lilliam','Nolan',NULL,'lilliam.nolan@msn.com','8976 Berkshire Court ','Copperas Cove','TX',76522);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tad','Gardner',NULL,'tad.gardner@hotmail.com','9745 E. Wilson St. ','Niagara Falls','NY',14304);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Petronila','Gallegos',NULL,'petronila.gallegos@gmail.com','8053 Aspen St. ','Howard Beach','NY',11414);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yun','Nelson',NULL,'yun.nelson@hotmail.com','529 Durham Street ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Edgar','Horn',NULL,'edgar.horn@aol.com','7270 W. Cherry Hill Lane ','West Babylon','NY',11704);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chantay','Maynard',NULL,'chantay.maynard@gmail.com','7483 1st Ave. ','Elmhurst','NY',11373);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Donette','Mccarthy',NULL,'donette.mccarthy@yahoo.com','500 NW. Maiden Dr. ','Redondo Beach','CA',90278);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mariam','Miranda',NULL,'mariam.miranda@aol.com','18 East Washington Avenue ','Franklin Square','NY',11010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rosalie','Coffey',NULL,'rosalie.coffey@gmail.com','789 Amerige Dr. ','Upland','CA',91784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cathey','Lamb',NULL,'cathey.lamb@msn.com','9621 Ryan Drive ','Bayside','NY',11361);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alyse','Jacobson',NULL,'alyse.jacobson@yahoo.com','10 West Devon Lane ','Massapequa Park','NY',11762);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('India','Barron',NULL,'india.barron@msn.com','834 W. Pleasant Rd. ','Huntington','NY',11743);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cris','Dunn',NULL,'cris.dunn@yahoo.com','1 Pawnee Street ','Pittsford','NY',14534);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ophelia','Rodgers',NULL,'ophelia.rodgers@gmail.com','133 Joy Ridge Drive ','Hopewell Junction','NY',12533);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Barrett','Sanders',NULL,'barrett.sanders@aol.com','32 Hawthorne St. ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bernardina','Cooper',NULL,'bernardina.cooper@msn.com','223 Glen Creek Ave. ','Whitestone','NY',11357);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Douglas','Richards',NULL,'douglas.richards@hotmail.com','221 Arcadia Lane ','Valley Stream','NY',11580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Phillis','Fowler',NULL,'phillis.fowler@aol.com','8976 N. Hall Street ','Clifton Park','NY',12065);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Reyes','Merritt',NULL,'reyes.merritt@yahoo.com','48 Lexington Rd. ','Staten Island','NY',10301);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nathalie','Knowles',NULL,'nathalie.knowles@aol.com','4 Cactus Street ','West Islip','NY',11795);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vallie','Dixon',NULL,'vallie.dixon@yahoo.com','85 E. Ann Drive ','Rowlett','TX',75088);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elnora','Simpson',NULL,'elnora.simpson@yahoo.com','7157 Shore Ave. ','Bellmore','NY',11710);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ivelisse','Nixon','(281) 941-4933','ivelisse.nixon@aol.com','782 Boston Ave. ','Houston','TX',77016);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shanti','Johnston',NULL,'shanti.johnston@gmail.com','722 Alderwood Drive ','Staten Island','NY',10301);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Martha','Burgess',NULL,'martha.burgess@msn.com','9631 St Margarets Lane ','Woodhaven','NY',11421);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Neville','Mcclain',NULL,'neville.mcclain@yahoo.com','781 Buttonwood Ave. ','West Hempstead','NY',11552);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ghislaine','Compton',NULL,'ghislaine.compton@aol.com','8930 Princess St. ','Lindenhurst','NY',11757);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Leanna','Manning',NULL,'leanna.manning@yahoo.com','39 E. Stillwater Ave. ','Hicksville','NY',11801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marshall','Johnson',NULL,'marshall.johnson@yahoo.com','44 Greenview St. ','Vista','CA',92083);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Zelda','Pratt','(717) 428-4018','zelda.pratt@gmail.com','74 Trusel Drive ','Lancaster','NY',14086);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Joel','Wynn','(619) 210-6032','joel.wynn@aol.com','7 North Oak Ave. ','San Diego','CA',92111);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yahaira','Robertson',NULL,'yahaira.robertson@yahoo.com','142 Roehampton Dr. ','Endicott','NY',13760);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sandy','Mills',NULL,'sandy.mills@gmail.com','333 Olive Ave. ','Schenectady','NY',12302);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cassidy','Clark',NULL,'cassidy.clark@hotmail.com','9879 Old Kingston Road ','Astoria','NY',11102);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kristy','Watkins',NULL,'kristy.watkins@gmail.com','977 South Brook Ave. ','Howard Beach','NY',11414);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tina','Bush',NULL,'tina.bush@aol.com','8038 Bellevue Street ','Maspeth','NY',11378);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Veronika','Rollins',NULL,'veronika.rollins@yahoo.com','94 Arnold Ave. ','Webster','NY',14580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kristel','Byrd',NULL,'kristel.byrd@hotmail.com','9967 Piper Street ','Hicksville','NY',11801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shay','Stephenson',NULL,'shay.stephenson@aol.com','9569 4th Lane ','Smithtown','NY',11787);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('George','Pickett',NULL,'george.pickett@msn.com','691 Rocky River St. ','Sunnyside','NY',11104);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Renato','Morton',NULL,'renato.morton@msn.com','8526 Sherwood Street ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marcy','Rodriguez',NULL,'marcy.rodriguez@gmail.com','97 Trusel Drive ','Lockport','NY',14094);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Edmund','Gaines',NULL,'edmund.gaines@gmail.com','8643 Gartner St. ','Copperas Cove','TX',76522);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lory','Berg',NULL,'lory.berg@aol.com','64 Vine Drive ','Oswego','NY',13126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Pamala','Fowler',NULL,'pamala.fowler@gmail.com','399 Leatherwood St. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Leone','Emerson',NULL,'leone.emerson@msn.com','460 Smith Store Ave. ','Whitestone','NY',11357);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Brain','Skinner',NULL,'brain.skinner@hotmail.com','8676 Ketch Harbour Ave. ','Euless','TX',76039);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Roseanne','Maynard',NULL,'roseanne.maynard@yahoo.com','219 Old Paris Hill Dr. ','Euless','TX',76039);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Corinna','Adams',NULL,'corinna.adams@msn.com','38 Trenton Court ','Rosedale','NY',11422);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kellye','Campbell',NULL,'kellye.campbell@gmail.com','75 Marsh St. ','Baldwinsville','NY',13027);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Erna','Sloan',NULL,'erna.sloan@aol.com','9449 Fifth Avenue ','Howard Beach','NY',11414);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carolann','Russell',NULL,'carolann.russell@hotmail.com','9308 Selby Ave. ','Glen Cove','NY',11542);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gilbert','Calhoun',NULL,'gilbert.calhoun@msn.com','7339 Summer Drive ','East Elmhurst','NY',11369);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Manie','Maxwell',NULL,'manie.maxwell@gmail.com','85 Brickell Ave. ','Ronkonkoma','NY',11779);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Giselle','Robles',NULL,'giselle.robles@hotmail.com','9747 N. El Dorado Dr. ','San Angelo','TX',76901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tessie','Farmer',NULL,'tessie.farmer@msn.com','870 Cottage Ave. ','Plattsburgh','NY',12901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Felica','Munoz',NULL,'felica.munoz@aol.com','24 West Rockwell Dr. ','South Ozone Park','NY',11420);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kathyrn','Bush',NULL,'kathyrn.bush@gmail.com','90 Devon St. ','Bronx','NY',10451);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sylvester','Chan',NULL,'sylvester.chan@hotmail.com','659 Arcadia Street ','Rocklin','CA',95677);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lizette','Ellison',NULL,'lizette.ellison@hotmail.com','865 Sunbeam Street ','Port Washington','NY',11050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ernestina','Skinner',NULL,'ernestina.skinner@hotmail.com','52 Spring Drive ','Elmhurst','NY',11373);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Phyllis','Hill',NULL,'phyllis.hill@yahoo.com','576 Devon Ave. ','Syosset','NY',11791);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Stephanie','Browning',NULL,'stephanie.browning@yahoo.com','9156 Lantern St. ','Rowlett','TX',75088);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Arlena','Buckner',NULL,'arlena.buckner@hotmail.com','629 Locust Ave. ','New Hyde Park','NY',11040);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lezlie','Thompson',NULL,'lezlie.thompson@yahoo.com','73 Vernon St. ','Freeport','NY',11520);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Brittney','Rojas',NULL,'brittney.rojas@aol.com','2 E. Overlook Ave. ','Kingston','NY',12401);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Phylis','Adkins','(212) 325-9145','phylis.adkins@msn.com','7781 James Ave. ','New York','NY',10002);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lean','Stark',NULL,'lean.stark@msn.com','215 Old Pumpkin Hill St. ','Upland','CA',91784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lara','Guy',NULL,'lara.guy@aol.com','9809 E. Walnut Drive ','Ronkonkoma','NY',11779);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Inga','Koch',NULL,'inga.koch@msn.com','8445 South New Court ','New Windsor','NY',12553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Klara','Kim',NULL,'klara.kim@gmail.com','9660 Sherman Lane ','Rome','NY',13440);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Julianne','Shannon',NULL,'julianne.shannon@hotmail.com','28 Applegate Street ','Sugar Land','TX',77478);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Loni','Mullen',NULL,'loni.mullen@msn.com','55 Thompson Avenue ','South Ozone Park','NY',11420);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Olympia','Figueroa',NULL,'olympia.figueroa@hotmail.com','587 Surrey St. ','Hopewell Junction','NY',12533);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mellie','Puckett',NULL,'mellie.puckett@yahoo.com','64 Van Dyke St. ','Fresh Meadows','NY',11365);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shonta','Preston',NULL,'shonta.preston@msn.com','74 Division St. ','Utica','NY',13501);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lore','Sykes','(716) 382-5169','lore.sykes@aol.com','7050 Beach Drive ','Buffalo','NY',14215);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Julia','Joyner',NULL,'julia.joyner@msn.com','2 Valley View Dr. ','Astoria','NY',11102);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lynwood','Jackson',NULL,'lynwood.jackson@aol.com','9449 Linda Street ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rosalva','Hamilton',NULL,'rosalva.hamilton@aol.com','9883 Cedar Dr. ','Campbell','CA',95008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Domingo','Casey','(408) 761-9212','domingo.casey@msn.com','8665 Cypress Street ','San Jose','CA',95127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rodrigo','Durham',NULL,'rodrigo.durham@aol.com','82 Old Church Road ','Richmond Hill','NY',11418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dwain','Carlson',NULL,'dwain.carlson@gmail.com','951 North Trusel Ave. ','Smithtown','NY',11787);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Erlinda','Humphrey',NULL,'erlinda.humphrey@hotmail.com','532 South Victoria St. ','New Windsor','NY',12553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Silas','Tate','(361) 219-2149','silas.tate@yahoo.com','9754 53rd Court ','Corpus Christi','TX',78418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Patience','Clayton',NULL,'patience.clayton@hotmail.com','68 Chestnut Dr. ','Niagara Falls','NY',14304);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mila','Good',NULL,'mila.good@yahoo.com','812 East Longbranch Ave. ','Plattsburgh','NY',12901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tanesha','Sawyer',NULL,'tanesha.sawyer@aol.com','9B Kingston Lane ','Rosedale','NY',11422);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Onita','Macdonald',NULL,'onita.macdonald@yahoo.com','94 Wood St. ','Glen Cove','NY',11542);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Janine','Manning',NULL,'janine.manning@gmail.com','9118B Campfire St. ','Howard Beach','NY',11414);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Melodie','Melton',NULL,'melodie.melton@yahoo.com','12 S. 8th Road ','Smithtown','NY',11787);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ethelyn','Ray',NULL,'ethelyn.ray@yahoo.com','80 South Sutor Lane ','Garden City','NY',11530);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Phebe','Turner',NULL,'phebe.turner@aol.com','4 West York Street ','Sunnyside','NY',11104);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chloe','Patel',NULL,'chloe.patel@yahoo.com','407 Homewood Street ','Santa Monica','CA',90403);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hilda','Harvey',NULL,'hilda.harvey@gmail.com','9808 W. Cleveland Ave. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gilberte','Duke','(915) 903-7860','gilberte.duke@gmail.com','12 Birchwood Dr. ','El Paso','TX',79930);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Willian','Hardin',NULL,'willian.hardin@msn.com','836 West Street ','Oswego','NY',13126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Janna','Hayden',NULL,'janna.hayden@msn.com','32 Hilldale Street ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Letisha','May',NULL,'letisha.may@yahoo.com','9965 Princeton Lane ','North Tonawanda','NY',14120);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Graig','Cannon',NULL,'graig.cannon@gmail.com','36 Oklahoma Ave. ','Syosset','NY',11791);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Coleen','Navarro',NULL,'coleen.navarro@aol.com','990 Broad Rd. ','Webster','NY',14580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lucilla','Williams',NULL,'lucilla.williams@hotmail.com','42 Cedar Street ','San Carlos','CA',94070);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rosanne','George',NULL,'rosanne.george@yahoo.com','38 Pleasant St. ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ashlie','Parrish',NULL,'ashlie.parrish@hotmail.com','48 Mill Drive ','Monsey','NY',10952);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alissa','Craft',NULL,'alissa.craft@hotmail.com','249 Maple Street ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Letty','Cobb',NULL,'letty.cobb@msn.com','8652 Wellington Street ','Depew','NY',14043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nathaniel','Richard',NULL,'nathaniel.richard@gmail.com','3 Nicolls Lane ','New Windsor','NY',12553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elaina','Key',NULL,'elaina.key@msn.com','1 Main St. ','Plainview','NY',11803);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Stefani','Gamble','(845) 724-2996','stefani.gamble@aol.com','9119 W. Victoria St. ','New City','NY',10956);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bettyann','Acosta','(717) 746-6658','bettyann.acosta@gmail.com','7949 Chapel St. ','Lancaster','NY',14086);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Crysta','Velez','(281) 529-3469','crysta.velez@yahoo.com','64 South Front Street ','Houston','TX',77016);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carisa','Carpenter',NULL,'carisa.carpenter@hotmail.com','551 Belmont Lane ','Victoria','TX',77904);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jule','Davenport',NULL,'jule.davenport@aol.com','19 River St. ','San Carlos','CA',94070);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lonna','Franks',NULL,'lonna.franks@yahoo.com','667 Brickyard Street ','Ontario','CA',91762);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elease','Dejesus',NULL,'elease.dejesus@gmail.com','7800 Magnolia Street ','Oswego','NY',13126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Maira','Long',NULL,'maira.long@msn.com','7587 Bear Hill Street ','Hicksville','NY',11801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jana','Thomas','(408) 624-8137','jana.thomas@yahoo.com','283 E. Spring Dr. ','San Jose','CA',95127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hae','Ramirez',NULL,'hae.ramirez@hotmail.com','9367 Lake Street ','Baldwinsville','NY',13027);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Erik','Leblanc',NULL,'erik.leblanc@aol.com','7 East Nut Swamp Street ','Sugar Land','TX',77478);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Daina','Sampson',NULL,'daina.sampson@msn.com','556 Wellington St. ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Delmar','Wise',NULL,'delmar.wise@yahoo.com','8355 Kingston Avenue ','Lockport','NY',14094);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alita','Salinas',NULL,'alita.salinas@hotmail.com','8550 Bear Hill Ave. ','Uniondale','NY',11553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elenore','William',NULL,'elenore.william@msn.com','23 Rockland St. ','Mcallen','TX',78501);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nikita','Roy',NULL,'nikita.roy@aol.com','9703 N. Snake Hill St. ','Pittsford','NY',14534);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Inocencia','Key',NULL,'inocencia.key@hotmail.com','36 Wild Rose Ave. ','Massapequa Park','NY',11762);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Liliana','Kerr',NULL,'liliana.kerr@yahoo.com','3 Cherry Drive ','Desoto','TX',75115);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hortencia','O''neil',NULL,'hortencia.o''neil@hotmail.com','1 Gulf Rd. ','Rockville Centre','NY',11570);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Beryl','Bennett','(916) 422-6956','beryl.bennett@aol.com','9563 Edgemont St. ','Sacramento','CA',95820);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alishia','Elliott',NULL,'alishia.elliott@aol.com','8905 Courtland Ave. ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vernia','Madden','(248) 206-3697','vernia.madden@aol.com','5 Iroquois Street ','Troy','NY',12180);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kristel','Bullock',NULL,'kristel.bullock@yahoo.com','7292 Armstrong Drive ','Smithtown','NY',11787);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ruthanne','Hoover',NULL,'ruthanne.hoover@aol.com','835 Paris Hill Road ','Torrance','CA',90505);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('James','Robles',NULL,'james.robles@aol.com','9 Chapel Lane ','North Tonawanda','NY',14120);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Evelin','Vargas',NULL,'evelin.vargas@msn.com','7049 Pin Oak Ave. ','Webster','NY',14580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elvia','Cardenas',NULL,'elvia.cardenas@hotmail.com','8 Paris Hill St. ','Massapequa','NY',11758);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Randee','Pitts',NULL,'randee.pitts@msn.com','7371B Essex Street ','Canyon Country','CA',91387);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lea','Irwin',NULL,'lea.irwin@gmail.com','845 Adams Lane ','New Windsor','NY',12553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bryce','Monroe',NULL,'bryce.monroe@aol.com','52 Cooper Lane ','Kingston','NY',12401);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Katina','Mcintosh','(661) 464-1523','katina.mcintosh@yahoo.com','263 Swanson Dr. ','Bakersfield','CA',93306);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Guillermo','Hart','(212) 652-7198','guillermo.hart@hotmail.com','81 Indian Summer Drive ','New York','NY',10002);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Joann','Barber',NULL,'joann.barber@gmail.com','8945 Courtland Street ','Santa Monica','CA',90403);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Thurman','Ellis',NULL,'thurman.ellis@gmail.com','20 Augusta Road ','Pleasanton','CA',94566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Delana','Wagner',NULL,'delana.wagner@aol.com','8499 Mill Pond Road ','Clifton Park','NY',12065);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Porter','Bass',NULL,'porter.bass@hotmail.com','370 North Alderwood Dr. ','San Angelo','TX',76901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yvonne','Bean',NULL,'yvonne.bean@yahoo.com','20 W. Marsh Ave. ','Wappingers Falls','NY',12590);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lurline','Rivers',NULL,'lurline.rivers@msn.com','69 Pine Street ','Howard Beach','NY',11414);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ocie','Slater',NULL,'ocie.slater@msn.com','7799 W. Bohemia Dr. ','Hamburg','NY',14075);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Genevie','Miles',NULL,'genevie.miles@aol.com','45 West Sulphur Springs Ave. ','Monroe','NY',10950);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sherilyn','Wilcox',NULL,'sherilyn.wilcox@gmail.com','905 North Buckingham Lane ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Aida','Koch',NULL,'aida.koch@gmail.com','9778 3rd Drive ','West Hempstead','NY',11552);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Emory','O''connor','(507) 606-2192','emory.o''connor@gmail.com','34 Foxrun Street ','Rochester','NY',14606);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Maximina','Hutchinson','(361) 164-3098','maximina.hutchinson@hotmail.com','53 Stillwater Avenue ','Corpus Christi','TX',78418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marina','Hinton',NULL,'marina.hinton@yahoo.com','7440 North Oxford St. ','Encino','CA',91316);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Danyell','Dickerson',NULL,'danyell.dickerson@msn.com','8306 Fieldstone Dr. ','Central Islip','NY',11722);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Davis','Long','(717) 653-1755','davis.long@msn.com','929 Elmwood Dr. ','Lancaster','NY',14086);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lynn','Mcmahon',NULL,'lynn.mcmahon@msn.com','9 Surrey St. ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tonja','Henderson',NULL,'tonja.henderson@aol.com','82 Alton St. ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Krissy','Ochoa',NULL,'krissy.ochoa@msn.com','80 Queen Ave. ','Port Washington','NY',11050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Angella','Bridges',NULL,'angella.bridges@yahoo.com','8708 Sycamore St. ','Pittsford','NY',14534);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Angele','Castro',NULL,'angele.castro@yahoo.com','15 Acacia Drive ','Palos Verdes Peninsula','CA',90274);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Siobhan','Lang',NULL,'siobhan.lang@gmail.com','3 Monroe Lane ','Levittown','NY',11756);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Venessa','Frost',NULL,'venessa.frost@msn.com','621 West School Rd. ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Verna','Solis','(507) 115-1633','verna.solis@yahoo.com','7 Lincoln Lane ','Rochester','NY',14606);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Steve','Bender',NULL,'steve.bender@gmail.com','908 N. Pennington Dr. ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Aileen','Marquez',NULL,'aileen.marquez@msn.com','8899 Newbridge Street ','Torrance','CA',90505);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kattie','Stevenson',NULL,'kattie.stevenson@aol.com','52 Carson Street ','Helotes','TX',78023);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hassan','Nash',NULL,'hassan.nash@yahoo.com','8105 University Lane ','Hicksville','NY',11801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Delfina','Gilliam',NULL,'delfina.gilliam@hotmail.com','9463 Bayberry Rd. ','West Babylon','NY',11704);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Venus','Hewitt',NULL,'venus.hewitt@msn.com','9835 Old Cemetery Lane ','Farmingdale','NY',11735);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Stephen','Vega','(657) 288-3778','stephen.vega@msn.com','5 Briarwood St. ','Anaheim','CA',92806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ciera','Koch',NULL,'ciera.koch@gmail.com','881 Lawrence Drive ','Euless','TX',76039);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Christel','Barber','(916) 679-3547','christel.barber@hotmail.com','320 Briarwood Lane ','Sacramento','CA',95820);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Arline','Lawson','(516) 792-3395','arline.lawson@gmail.com','48 Whitemarsh Lane ','Hempstead','NY',11550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Iva','Wilcox',NULL,'iva.wilcox@aol.com','452 South Mayflower Drive ','Kingston','NY',12401);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Maple','Griffin',NULL,'maple.griffin@gmail.com','20 Glendale Drive ','Copperas Cove','TX',76522);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Anisha','Lang',NULL,'anisha.lang@aol.com','265 Peachtree St. ','Rome','NY',13440);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Brent','Calderon','(361) 981-8725','brent.calderon@aol.com','3 Thomas St. ','Corpus Christi','TX',78418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Margit','Osborn',NULL,'margit.osborn@yahoo.com','909 Gulf Drive ','Plainview','NY',11803);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Novella','Patel',NULL,'novella.patel@gmail.com','500 Livingston Street ','Glen Cove','NY',11542);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Laurette','Hebert',NULL,'laurette.hebert@msn.com','18 South Constitution Court ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jonna','Brown',NULL,'jonna.brown@aol.com','1 Spring Drive ','Mahopac','NY',10541);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jennell','Solis','(507) 421-7354','jennell.solis@hotmail.com','194 2nd Rd. ','Rochester','NY',14606);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ruth','Horton',NULL,'ruth.horton@gmail.com','488 Mulberry Ave. ','Hollis','NY',11423);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Samual','Warner','(631) 151-4988','samual.warner@gmail.com','8735 Thatcher Dr. ','Brentwood','NY',11717);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Damian','Mills','(562) 924-3079','damian.mills@yahoo.com','7747 Elm Dr. ','Long Beach','NY',11561);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Margaretta','Clayton',NULL,'margaretta.clayton@yahoo.com','524 San Pablo Ave. ','Ridgecrest','CA',93555);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marcell','Barrett',NULL,'marcell.barrett@gmail.com','266 Elm Drive ','Astoria','NY',11102);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Annis','Sanchez','(424) 352-6275','annis.sanchez@aol.com','4 Edgewater Road ','Los Angeles','CA',90008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ayanna','Cherry',NULL,'ayanna.cherry@yahoo.com','8829 Galvin Rd. ','Smithtown','NY',11787);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Barton','Cox',NULL,'barton.cox@yahoo.com','8220 Creekside Street ','Amityville','NY',11701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Diana','Reyes',NULL,'diana.reyes@msn.com','7415 Annadale St. ','Bronx','NY',10451);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ingeborg','Ellison',NULL,'ingeborg.ellison@yahoo.com','360 Trusel St. ','Ithaca','NY',14850);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carter','Booth',NULL,'carter.booth@msn.com','82 Beech Drive ','Port Chester','NY',10573);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Christel','Cardenas','(562) 342-8083','christel.cardenas@aol.com','428 S. Swanson Drive ','Long Beach','NY',11561);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Orval','Hunter',NULL,'orval.hunter@aol.com','35 Wagon Drive ','San Angelo','TX',76901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marguerite','Berger',NULL,'marguerite.berger@aol.com','875 Arch Lane ','Fullerton','CA',92831);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ivette','Warren',NULL,'ivette.warren@gmail.com','8408 Thomas Street ','Franklin Square','NY',11010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Milagros','Weber',NULL,'milagros.weber@hotmail.com','7591 Glendale Ave. ','Harlingen','TX',78552);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marcel','Lindsay',NULL,'marcel.lindsay@hotmail.com','249 Peninsula St. ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Louis','Powell',NULL,'louis.powell@aol.com','368 Sugar Rd. ','Staten Island','NY',10301);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vanda','Holmes',NULL,'vanda.holmes@aol.com','9835 Wild Rose Drive ','Syosset','NY',11791);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Loreen','Byers',NULL,'loreen.byers@yahoo.com','83 S. Rockledge Circle ','South Ozone Park','NY',11420);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Casimira','Chapman',NULL,'casimira.chapman@yahoo.com','67 Snake Hill St. ','Monroe','NY',10950);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Brigida','Larson',NULL,'brigida.larson@hotmail.com','8789 Sycamore Lane ','Canyon Country','CA',91387);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chere','Alston',NULL,'chere.alston@gmail.com','16 Lower River Street ','Patchogue','NY',11772);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Giovanna','Jefferson',NULL,'giovanna.jefferson@gmail.com','9394 Riverside St. ','Ridgecrest','CA',93555);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Demarcus','Reese',NULL,'demarcus.reese@gmail.com','8087 Armstrong Dr. ','Yorktown Heights','NY',10598);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Amina','Salazar',NULL,'amina.salazar@aol.com','944 Wellington Street ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Serafina','Clemons',NULL,'serafina.clemons@gmail.com','851 Brown Ave. ','Shirley','NY',11967);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Trinidad','Mcclain',NULL,'trinidad.mcclain@msn.com','98 Tunnel Drive ','Baldwin','NY',11510);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Heather','Chaney',NULL,'heather.chaney@yahoo.com','4 Morris Dr. ','Jamestown','NY',14701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Latoya','Johns',NULL,'latoya.johns@hotmail.com','7914 W. Woodsman St. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shiloh','Reeves',NULL,'shiloh.reeves@msn.com','818 Kirkland Lane ','West Babylon','NY',11704);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lee','Roman','(631) 913-6967','lee.roman@gmail.com','4 Canal Ave. ','Brentwood','NY',11717);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cami','Williamson',NULL,'cami.williamson@hotmail.com','9511A Windsor Drive ','Massapequa','NY',11758);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sharell','Ross',NULL,'sharell.ross@msn.com','7830 Devonshire Ave. ','Vista','CA',92083);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jerald','Blackwell',NULL,'jerald.blackwell@hotmail.com','8364 South Wakehurst Ave. ','East Elmhurst','NY',11369);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ruthanne','Franco',NULL,'ruthanne.franco@yahoo.com','61 Applegate St. ','Astoria','NY',11102);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marjory','Leonard',NULL,'marjory.leonard@msn.com','800 Greystone Lane ','Apple Valley','CA',92307);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jimmy','Russell',NULL,'jimmy.russell@hotmail.com','33 Iroquois Ave. ','Howard Beach','NY',11414);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Berneice','Pollard',NULL,'berneice.pollard@hotmail.com','607 Bohemia Street ','Forney','TX',75126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Deangelo','Cooley',NULL,'deangelo.cooley@aol.com','3 NE. Edgewood Rd. ','Rosedale','NY',11422);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Katia','Henry',NULL,'katia.henry@msn.com','69 E. Columbia Ave. ','Bethpage','NY',11714);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sebrina','Gross',NULL,'sebrina.gross@yahoo.com','993 Glendale Drive ','Garland','TX',75043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Josephine','Dale',NULL,'josephine.dale@aol.com','8214 West Drive ','Baldwinsville','NY',13027);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alma','Peck',NULL,'alma.peck@aol.com','298 South Bay Meadows Drive ','Corona','NY',11368);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ling','Newman',NULL,'ling.newman@msn.com','832 Spring Road ','South Richmond Hill','NY',11419);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nichelle','Rosario',NULL,'nichelle.rosario@hotmail.com','709 Dunbar Ave. ','Garden City','NY',11530);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shenna','Benton','(212) 578-2912','shenna.benton@msn.com','57 Shadow Brook Road ','New York','NY',10002);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Philip','Bryan','(510) 533-4262','philip.bryan@hotmail.com','914 Devonshire Court ','Oakland','CA',94603);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carita','Salinas',NULL,'carita.salinas@yahoo.com','90 Griffin Street ','Maspeth','NY',11378);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Janie','Herrera',NULL,'janie.herrera@gmail.com','652 Westport Street ','Elmhurst','NY',11373);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lorraine','Marks',NULL,'lorraine.marks@msn.com','160 North Pearl Street ','San Carlos','CA',94070);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nicolas','Carlson',NULL,'nicolas.carlson@yahoo.com','7899 Spruce Street ','Saint Albans','NY',11412);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hye','Mercer',NULL,'hye.mercer@gmail.com','9681 Redwood St. ','Mahopac','NY',10541);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Adena','Blake',NULL,'adena.blake@hotmail.com','684 Westport Drive ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Coleman','Boyd','(915) 607-6336','coleman.boyd@yahoo.com','9740 Bay Meadows Drive ','El Paso','TX',79930);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Daphine','Willis',NULL,'daphine.willis@msn.com','152 Shady St. ','Farmingdale','NY',11735);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jenine','Dawson',NULL,'jenine.dawson@msn.com','17 Park Street ','Endicott','NY',13760);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shanita','Wiley',NULL,'shanita.wiley@yahoo.com','121 Bridge Lane ','Saint Albans','NY',11412);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shanna','Bonner',NULL,'shanna.bonner@msn.com','386 Lafayette Road ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ping','Quinn',NULL,'ping.quinn@gmail.com','9051 Hanover Dr. ','Rowlett','TX',75088);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Saran','Moses',NULL,'saran.moses@yahoo.com','94 Hall Dr. ','Brooklyn','NY',11201);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tonja','Bean',NULL,'tonja.bean@aol.com','9 Middle River St. ','Fairport','NY',14450);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vernon','Knowles',NULL,'vernon.knowles@yahoo.com','5 Olive Lane ','Huntington Station','NY',11746);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeannette','Skinner',NULL,'jeannette.skinner@yahoo.com','8886 High Point Drive ','Forest Hills','NY',11375);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rico','Salas',NULL,'rico.salas@msn.com','8041 Walt Whitman St. ','Centereach','NY',11720);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tangela','Hurley',NULL,'tangela.hurley@msn.com','49 North Cross St. ','Campbell','CA',95008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Randee','Lester',NULL,'randee.lester@gmail.com','81 Bear Hill Street ','Centereach','NY',11720);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ashanti','Hammond',NULL,'ashanti.hammond@msn.com','9202 W. Lyme Ave. ','Nanuet','NY',10954);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Garry','Juarez',NULL,'garry.juarez@hotmail.com','670 Nut Swamp Drive ','Forest Hills','NY',11375);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bee','Baker',NULL,'bee.baker@aol.com','307 E. Magnolia St. ','Liverpool','NY',13090);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shantae','Hammond',NULL,'shantae.hammond@hotmail.com','526 Harvard Drive ','Victoria','TX',77904);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bettye','Espinoza',NULL,'bettye.espinoza@yahoo.com','76 Rockwell Street ','Oswego','NY',13126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Larissa','Hays',NULL,'larissa.hays@aol.com','66 2nd Drive ','Elmont','NY',11003);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Diane','Jones',NULL,'diane.jones@gmail.com','859 Prince St. ','Fresh Meadows','NY',11365);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Zenia','Bruce',NULL,'zenia.bruce@aol.com','349 James Road ','Rosedale','NY',11422);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Pasquale','Hogan',NULL,'pasquale.hogan@aol.com','403 Bank St. ','Vista','CA',92083);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dane','Mcdaniel',NULL,'dane.mcdaniel@hotmail.com','891 Court Ave. ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jamaal','Baker',NULL,'jamaal.baker@hotmail.com','186 Big Rock Cove Ave. ','Elmhurst','NY',11373);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ji','Burt',NULL,'ji.burt@hotmail.com','40 S. Roberts Street ','Apple Valley','CA',92307);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marcelino','Mcbride',NULL,'marcelino.mcbride@hotmail.com','29 Oxford Ave. ','Clifton Park','NY',12065);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rozella','Fitzgerald',NULL,'rozella.fitzgerald@yahoo.com','7795 Myers Ave. ','Shirley','NY',11967);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tonisha','Fowler',NULL,'tonisha.fowler@msn.com','9270 Valley View Lane ','Huntington Station','NY',11746);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Zora','Ford','(916) 192-3196','zora.ford@gmail.com','7416 La Sierra Dr. ','Sacramento','CA',95820);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Parthenia','Figueroa',NULL,'parthenia.figueroa@msn.com','550 Theatre Dr. ','Mahopac','NY',10541);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Arielle','Levine',NULL,'arielle.levine@yahoo.com','7100 High Ridge St. ','Garland','TX',75043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hildegarde','Christensen',NULL,'hildegarde.christensen@hotmail.com','488 East Mill Pond Ave. ','Maspeth','NY',11378);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rebbecca','Espinoza',NULL,'rebbecca.espinoza@hotmail.com','8266 Valley Farms Road ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Conchita','Boone',NULL,'conchita.boone@gmail.com','814 Birchpond Lane ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Aisha','Woods',NULL,'aisha.woods@gmail.com','9292 Bear Hill Ave. ','Webster','NY',14580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Season','Harvey',NULL,'season.harvey@yahoo.com','388 Arnold Court ','East Northport','NY',11731);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tommie','Cooley','(717) 634-4113','tommie.cooley@yahoo.com','92 Hickory St. ','Lancaster','NY',14086);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alanna','Barry',NULL,'alanna.barry@yahoo.com','33 Laurel Avenue ','Euless','TX',76039);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jerri','Guthrie',NULL,'jerri.guthrie@msn.com','95 Sugar Dr. ','Carmel','NY',10512);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tammy','Austin',NULL,'tammy.austin@yahoo.com','182 Stillwater Ave. ','Lake Jackson','TX',77566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Patsy','Russo',NULL,'patsy.russo@gmail.com','8438 Fairway Avenue ','Rowlett','TX',75088);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Desiree','Branch',NULL,'desiree.branch@msn.com','67 Bayport Drive ','San Lorenzo','CA',94580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Raeann','Duncan','(657) 256-2008','raeann.duncan@aol.com','126 Edgewood St. ','Anaheim','CA',92806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lillia','Gillespie',NULL,'lillia.gillespie@hotmail.com','382 Cardinal Dr. ','Rego Park','NY',11374);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Doris','Kaufman',NULL,'doris.kaufman@gmail.com','69 Fairground Dr. ','Duarte','CA',91010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rodolfo','Buck',NULL,'rodolfo.buck@gmail.com','8359 Brewery Street ','Shirley','NY',11967);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Olimpia','Mays',NULL,'olimpia.mays@aol.com','42 Nichols Lane ','Oakland Gardens','NY',11364);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shemeka','Lyons',NULL,'shemeka.lyons@msn.com','97 South Jockey Hollow St. ','Pomona','CA',91768);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Maryalice','Henry',NULL,'maryalice.henry@msn.com','85 Prince Street ','Richardson','TX',75080);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Leeanne','Cross',NULL,'leeanne.cross@yahoo.com','424 Newcastle Road ','Bayside','NY',11361);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lanelle','Guerra',NULL,'lanelle.guerra@yahoo.com','989 Wrangler St. ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dann','Huff',NULL,'dann.huff@gmail.com','475 S. Rockville St. ','Huntington Station','NY',11746);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sherise','Mercer',NULL,'sherise.mercer@gmail.com','9401 Catherine Dr. ','Vista','CA',92083);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Heather','Perry',NULL,'heather.perry@gmail.com','982 Durham Street ','Sunnyside','NY',11104);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Theresia','Barron',NULL,'theresia.barron@aol.com','951 Wild Rose Street ','Forest Hills','NY',11375);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cindi','Ellis',NULL,'cindi.ellis@yahoo.com','6 Cypress Lane ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mirella','Duffy',NULL,'mirella.duffy@yahoo.com','43 University Ave. ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carson','Macias',NULL,'carson.macias@gmail.com','7 Pennington St. ','New Rochelle','NY',10801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Divina','Madden','(562) 264-3998','divina.madden@gmail.com','7314 Armstrong St. ','Long Beach','NY',11561);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cher','Alston',NULL,'cher.alston@msn.com','38 Wild Horse Road ','Wantagh','NY',11793);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Regine','Odom',NULL,'regine.odom@msn.com','684 N. Mayfield Ave. ','Franklin Square','NY',11010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Adam','Thornton',NULL,'adam.thornton@hotmail.com','755 East Henry Lane ','Central Islip','NY',11722);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cori','Schwartz',NULL,'cori.schwartz@msn.com','43 Lancaster Lane ','Jamaica','NY',11432);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Willow','Gardner',NULL,'willow.gardner@gmail.com','57 S. Lakewood Dr. ','Pleasanton','CA',94566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jane','Henderson',NULL,'jane.henderson@hotmail.com','46 Carson Drive ','Apple Valley','CA',92307);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chere','Mcfadden',NULL,'chere.mcfadden@yahoo.com','695 San Pablo Drive ','Orchard Park','NY',14127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ira','Erickson',NULL,'ira.erickson@aol.com','6 Lake Forest St. ','Port Jefferson Station','NY',11776);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Risa','Gallagher',NULL,'risa.gallagher@yahoo.com','8281 Edgefield Drive ','Rocklin','CA',95677);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lavinia','Cotton',NULL,'lavinia.cotton@yahoo.com','7485 Bridle Street ','East Northport','NY',11731);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alejandrina','Hodges',NULL,'alejandrina.hodges@msn.com','7598 Shadow Brook St. ','Deer Park','NY',11729);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Keitha','Black',NULL,'keitha.black@yahoo.com','7670 Hilldale Ave. ','Lindenhurst','NY',11757);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Corene','Swanson',NULL,'corene.swanson@aol.com','597 Lakeshore Lane ','Rego Park','NY',11374);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tonda','Webb',NULL,'tonda.webb@yahoo.com','53 SW. Edgemont Rd. ','Baldwinsville','NY',13027);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Collen','Dennis',NULL,'collen.dennis@gmail.com','284 E. Mill Street ','San Pablo','CA',94806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Treasa','Dickerson',NULL,'treasa.dickerson@hotmail.com','70 W. Creekside Road ','Rockville Centre','NY',11570);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jewell','Reyes',NULL,'jewell.reyes@hotmail.com','8711 Glen Creek Drive ','Jackson Heights','NY',11372);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Penny','Acevedo',NULL,'penny.acevedo@yahoo.com','318 Mulberry Drive ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Louise','Flowers',NULL,'louise.flowers@yahoo.com','28 N. Gregory Court ','Depew','NY',14043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Henrietta','Wagner','(682) 143-2224','henrietta.wagner@hotmail.com','54 Brickyard St. ','Fort Worth','TX',76110);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ardelia','Cooley',NULL,'ardelia.cooley@aol.com','59 Henry Smith St. ','Canyon Country','CA',91387);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Khalilah','Robertson',NULL,'khalilah.robertson@aol.com','22 Longbranch Rd. ','Spring Valley','NY',10977);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Armando','Black',NULL,'armando.black@gmail.com','8611 N. Poor House St. ','Richardson','TX',75080);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jerri','Henry',NULL,'jerri.henry@msn.com','141 N. Purple Finch Avenue ','Spring Valley','NY',10977);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lynda','Newman',NULL,'lynda.newman@msn.com','44 SW. Thomas Ave. ','Saratoga Springs','NY',12866);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bao','Wade',NULL,'bao.wade@gmail.com','7587 Church St. ','Desoto','TX',75115);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gussie','Harding',NULL,'gussie.harding@gmail.com','41 Edgefield Avenue ','Deer Park','NY',11729);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shirely','Cantrell',NULL,'shirely.cantrell@aol.com','6 Kent Street ','West Hempstead','NY',11552);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Caroline','Jenkins',NULL,'caroline.jenkins@msn.com','86 River Lane ','Richardson','TX',75080);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hollis','Rasmussen',NULL,'hollis.rasmussen@yahoo.com','8949 S. Gates Road ','Massapequa','NY',11758);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kendra','Harrington',NULL,'kendra.harrington@yahoo.com','768 Cooper Street ','Jamestown','NY',14701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Douglass','Blankenship','(229) 891-2087','douglass.blankenship@hotmail.com','409 W. Rock Maple Lane ','Albany','NY',12203);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lina','Meadows',NULL,'lina.meadows@aol.com','7020 Ashley Rd. ','Glen Cove','NY',11542);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Patria','Harper',NULL,'patria.harper@msn.com','90 Arlington St. ','Astoria','NY',11102);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jeffrey','Hill',NULL,'jeffrey.hill@gmail.com','2 Shub Farm St. ','Rosedale','NY',11422);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ja','Dillard',NULL,'ja.dillard@yahoo.com','25 Orchard St. ','Canyon Country','CA',91387);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tora','Dunlap',NULL,'tora.dunlap@hotmail.com','9903 North Halifax Ave. ','Monsey','NY',10952);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Karole','Alvarez',NULL,'karole.alvarez@gmail.com','69 Woodland St. ','East Northport','NY',11731);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shasta','Combs',NULL,'shasta.combs@yahoo.com','726 James Dr. ','Yorktown Heights','NY',10598);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cicely','Deleon',NULL,'cicely.deleon@yahoo.com','751 Newbridge Ave. ','Massapequa Park','NY',11762);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Raphael','O''neil',NULL,'raphael.o''neil@aol.com','762 East Lantern Dr. ','Fairport','NY',14450);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hubert','Reilly',NULL,'hubert.reilly@hotmail.com','9004 N. Lake Rd. ','Amityville','NY',11701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Caleb','England',NULL,'caleb.england@gmail.com','649 Marvon St. ','Pleasanton','CA',94566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elmira','Levy',NULL,'elmira.levy@gmail.com','6 Columbia Dr. ','Spring Valley','NY',10977);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Waldo','Hart',NULL,'waldo.hart@yahoo.com','9782 Pineknoll Lane ','Queensbury','NY',12804);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bea','Kane',NULL,'bea.kane@aol.com','398 Green Lake Ave. ','Mahopac','NY',10541);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gilberto','Sanders',NULL,'gilberto.sanders@hotmail.com','186 Roehampton Ave. ','Woodside','NY',11377);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Benny','Bender',NULL,'benny.bender@aol.com','520 W. Hamilton St. ','Elmont','NY',11003);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Desmond','Rose',NULL,'desmond.rose@hotmail.com','9956 Lexington Rd. ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Parthenia','Holman',NULL,'parthenia.holman@gmail.com','17 Orange Court ','Ithaca','NY',14850);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dung','King',NULL,'dung.king@aol.com','523 Prairie St. ','West Islip','NY',11795);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sherril','Alvarado',NULL,'sherril.alvarado@hotmail.com','9434 Cypress Court ','Desoto','TX',75115);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alisia','Albert',NULL,'alisia.albert@gmail.com','9490 Coffee St. ','Garland','TX',75043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kallie','Best','(507) 997-4112','kallie.best@aol.com','9842 Fairview St. ','Rochester','NY',14606);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dottie','Roberts',NULL,'dottie.roberts@aol.com','8252 Theatre St. ','Port Washington','NY',11050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hubert','Stone',NULL,'hubert.stone@hotmail.com','203 Penn St. ','Ridgecrest','CA',93555);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gabriella','Jones',NULL,'gabriella.jones@hotmail.com','9100 Gates Ave. ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Penney','Hall',NULL,'penney.hall@msn.com','8306 Jockey Hollow Street ','Liverpool','NY',13090);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mallie','Osborn',NULL,'mallie.osborn@gmail.com','9022 Bridgeton St. ','Newburgh','NY',12550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Britteny','Schroeder',NULL,'britteny.schroeder@aol.com','855 Bohemia Dr. ','Pittsford','NY',14534);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sommer','Hopkins',NULL,'sommer.hopkins@gmail.com','827 Laurel Ave. ','Tonawanda','NY',14150);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jewel','Sparks',NULL,'jewel.sparks@aol.com','12 Vine Road ','Oakland Gardens','NY',11364);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Deandrea','Vega','(914) 818-7312','deandrea.vega@gmail.com','613 Mill Pond St. ','Yonkers','NY',10701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Charlsie','Carson',NULL,'charlsie.carson@hotmail.com','3 South Grant Avenue ','Saint Albans','NY',11412);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kandace','Ayers',NULL,'kandace.ayers@gmail.com','9005 Lookout Lane ','Santa Monica','CA',90403);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lenore','Valdez',NULL,'lenore.valdez@msn.com','829 Birchpond Street ','Spring Valley','NY',10977);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Drucilla','Gilliam',NULL,'drucilla.gilliam@hotmail.com','8257 E. Westminster Ave. ','Santa Clara','CA',95050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Keturah','Reid','(361) 394-2024','keturah.reid@yahoo.com','747 SE. Beech Ave. ','Corpus Christi','TX',78418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Herminia','Reyes',NULL,'herminia.reyes@gmail.com','782 Stonybrook Street ','Centereach','NY',11720);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tuyet','Rosa',NULL,'tuyet.rosa@aol.com','9038 Golden Star Street ','South El Monte','CA',91733);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ara','Vazquez',NULL,'ara.vazquez@msn.com','343 2nd Court ','San Carlos','CA',94070);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Barry','Albert',NULL,'barry.albert@gmail.com','13 Grand St. ','Auburn','NY',13021);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Verdell','Joyner',NULL,'verdell.joyner@aol.com','9191 Sierra St. ','Far Rockaway','NY',11691);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Han','Wade',NULL,'han.wade@hotmail.com','587 Sulphur Springs St. ','Howard Beach','NY',11414);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Anton','Barton','(716) 472-3707','anton.barton@msn.com','7284 East Indian Spring Rd. ','Buffalo','NY',14215);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vito','Pickett',NULL,'vito.pickett@hotmail.com','93 High Point Street ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Charlene','Norris',NULL,'charlene.norris@msn.com','972 South Sierra Drive ','Syosset','NY',11791);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Efren','Whitfield',NULL,'efren.whitfield@gmail.com','139 Union Rd. ','Euless','TX',76039);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Santa','Larson',NULL,'santa.larson@gmail.com','5 Bellevue Dr. ','Valley Stream','NY',11580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carmelina','Sellers',NULL,'carmelina.sellers@hotmail.com','12 Race St. ','Ithaca','NY',14850);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carmela','Hays',NULL,'carmela.hays@aol.com','149 Pennington Ave. ','Lawndale','CA',90260);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Patrina','Tanner',NULL,'patrina.tanner@gmail.com','7136 Selby Road ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rikki','Morrow','(682) 936-1482','rikki.morrow@hotmail.com','7096 Plumb Branch Road ','Fort Worth','TX',76110);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Junita','Reese',NULL,'junita.reese@gmail.com','8773 North Walt Whitman Court ','Bay Shore','NY',11706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ryan','Carter',NULL,'ryan.carter@yahoo.com','8684 Studebaker Road ','Nanuet','NY',10954);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Almeta','Benjamin',NULL,'almeta.benjamin@aol.com','8456 Oakwood St. ','Sunnyside','NY',11104);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Beatris','Joyner',NULL,'beatris.joyner@gmail.com','7463 Gonzales Rd. ','Spring Valley','NY',10977);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mechelle','Chan',NULL,'mechelle.chan@gmail.com','458 Overlook Street ','Richmond Hill','NY',11418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Earlean','Pena',NULL,'earlean.pena@yahoo.com','7698 Fulton St. ','Rome','NY',13440);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Katherin','Clark',NULL,'katherin.clark@yahoo.com','996 Iroquois Street ','Pittsford','NY',14534);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chanel','May',NULL,'chanel.may@msn.com','806 Saxton Court ','Garden City','NY',11530);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Aaron','Knapp','(914) 402-4335','aaron.knapp@yahoo.com','807 Grandrose Ave. ','Yonkers','NY',10701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sindy','Anderson',NULL,'sindy.anderson@gmail.com','543 Halifax Ave. ','Pomona','CA',91768);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sheree','Blanchard',NULL,'sheree.blanchard@gmail.com','41 Glenwood Ave. ','Queensbury','NY',12804);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Charlesetta','Soto',NULL,'charlesetta.soto@yahoo.com','25 South Colonial Drive ','Poughkeepsie','NY',12601);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Wendie','Nash','(805) 389-2549','wendie.nash@hotmail.com','9 South Road ','Oxnard','CA',93035);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vernetta','Banks',NULL,'vernetta.banks@aol.com','7633 Albany St. ','Brooklyn','NY',11201);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Myrtle','Gardner',NULL,'myrtle.gardner@aol.com','303 Creekside Street ','Farmingdale','NY',11735);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Agustina','Lawrence',NULL,'agustina.lawrence@yahoo.com','9347 Delaware Ave. ','Brooklyn','NY',11201);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Trinidad','Chapman',NULL,'trinidad.chapman@aol.com','7371 Glen Eagles Street ','Ronkonkoma','NY',11779);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kim','Clark',NULL,'kim.clark@msn.com','19 Liberty St. ','Merrick','NY',11566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Annabelle','Hebert',NULL,'annabelle.hebert@aol.com','9745 Nicolls Lane ','Spring Valley','NY',10977);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Corine','Stuart',NULL,'corine.stuart@msn.com','5 Penn Street ','Clifton Park','NY',12065);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kiesha','Bond',NULL,'kiesha.bond@aol.com','29 Marvon St. ','San Carlos','CA',94070);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kenyetta','Mason',NULL,'kenyetta.mason@msn.com','98 Poplar Ave. ','Flushing','NY',11354);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marcene','Curtis','(914) 361-6045','marcene.curtis@msn.com','7699 Illinois Lane ','Yonkers','NY',10701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sheila','Goodman',NULL,'sheila.goodman@msn.com','9586 Chestnut St. ','Uniondale','NY',11553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Romeo','Steele',NULL,'romeo.steele@msn.com','162 Crescent Lane ','Port Jefferson Station','NY',11776);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tam','Fisher','(507) 351-9375','tam.fisher@aol.com','8000 Woodsman Lane ','Rochester','NY',14606);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gena','Owens',NULL,'gena.owens@gmail.com','43 Buckingham St. ','Desoto','TX',75115);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Phebe','Soto',NULL,'phebe.soto@hotmail.com','9239 Leatherwood Rd. ','South Ozone Park','NY',11420);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Leticia','Snyder',NULL,'leticia.snyder@yahoo.com','173 Lyme Dr. ','Pittsford','NY',14534);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chantell','Bridges','(716) 941-6072','chantell.bridges@yahoo.com','8478 N. Wrangler Dr. ','Buffalo','NY',14215);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ileana','Holt',NULL,'ileana.holt@msn.com','817 Adams St. ','Patchogue','NY',11772);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nakisha','Clay',NULL,'nakisha.clay@gmail.com','8996 Beechwood Ave. ','Port Washington','NY',11050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cheryll','Snyder',NULL,'cheryll.snyder@yahoo.com','77 E. Liberty St. ','Brooklyn','NY',11201);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Consuela','Collier',NULL,'consuela.collier@msn.com','338 S. Holly Avenue ','North Tonawanda','NY',14120);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Aubrey','Durham',NULL,'aubrey.durham@aol.com','14 Foster Ave. ','Port Washington','NY',11050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nita','Guy',NULL,'nita.guy@hotmail.com','75 Academy Street ','Port Chester','NY',10573);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carmina','Emerson',NULL,'carmina.emerson@hotmail.com','7137 Monroe Road ','Banning','CA',92220);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Georgeann','Rojas',NULL,'georgeann.rojas@msn.com','691 Devon Ave. ','Desoto','TX',75115);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Leslie','Higgins',NULL,'leslie.higgins@hotmail.com','805 Logan Ave. ','Saratoga Springs','NY',12866);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Emmaline','Huber',NULL,'emmaline.huber@gmail.com','7975 Harrison Rd. ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mercy','Brown',NULL,'mercy.brown@msn.com','8207 Central Street ','Hollis','NY',11423);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jenell','Crosby','(631) 544-4772','jenell.crosby@hotmail.com','507 Fulton Street ','Brentwood','NY',11717);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Leila','Barr',NULL,'leila.barr@yahoo.com','120 Fremont Rd. ','Carmel','NY',10512);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Deandrea','Cox',NULL,'deandrea.cox@msn.com','617 Sycamore Street ','Huntington','NY',11743);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shawnna','Frank',NULL,'shawnna.frank@hotmail.com','17 NW. Cottage Lane ','Woodside','NY',11377);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Brenton','Whitaker',NULL,'brenton.whitaker@gmail.com','25 Elmwood Rd. ','Niagara Falls','NY',14304);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jaqueline','Cummings',NULL,'jaqueline.cummings@hotmail.com','478 Wrangler St. ','Huntington Station','NY',11746);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yang','Giles',NULL,'yang.giles@gmail.com','25 Bridle Lane ','San Angelo','TX',76901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Brigid','Sharp',NULL,'brigid.sharp@hotmail.com','495 Sleepy Hollow Court ','Santa Clara','CA',95050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Karl','Stephens',NULL,'karl.stephens@gmail.com','208 Thatcher Rd. ','Rockville Centre','NY',11570);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elvina','Gates',NULL,'elvina.gates@hotmail.com','112 Smith St. ','Pleasanton','CA',94566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carlie','Terrell','(914) 517-8036','carlie.terrell@yahoo.com','7437 Snake Hill Road ','Yonkers','NY',10701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Donovan','Cantrell','(510) 624-3824','donovan.cantrell@msn.com','601 Winchester Dr. ','Oakland','CA',94603);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alden','Atkinson',NULL,'alden.atkinson@gmail.com','46 Valley St. ','Shirley','NY',11967);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carissa','Cross',NULL,'carissa.cross@yahoo.com','9335 West Main Dr. ','Huntington Station','NY',11746);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Joy','Underwood',NULL,'joy.underwood@gmail.com','7297 Armstrong Dr. ','Apple Valley','CA',92307);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Geraldine','O''donnell',NULL,'geraldine.o''donnell@hotmail.com','8241 Lookout Rd. ','Flushing','NY',11354);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bronwyn','Vargas',NULL,'bronwyn.vargas@msn.com','35 James Street ','New Windsor','NY',12553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Abram','Copeland',NULL,'abram.copeland@gmail.com','9782 Indian Spring Lane ','Harlingen','TX',78552);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mellisa','Griffin',NULL,'mellisa.griffin@msn.com','49 Alton Circle ','Los Banos','CA',93635);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Qiana','Jackson',NULL,'qiana.jackson@gmail.com','56 Galvin Street ','East Northport','NY',11731);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Magali','Dixon','(248) 279-5331','magali.dixon@msn.com','815 Del Monte Court ','Troy','NY',12180);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Zulema','Clemons','(510) 565-8496','zulema.clemons@aol.com','75 W. Howard St. ','Oakland','CA',94603);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carina','Lynch',NULL,'carina.lynch@gmail.com','64 Jennings Road ','Wappingers Falls','NY',12590);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jesus','Burch',NULL,'jesus.burch@hotmail.com','7024 Squaw Creek Street ','Desoto','TX',75115);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Selene','Vega',NULL,'selene.vega@gmail.com','11 Sierra St. ','Campbell','CA',95008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jong','Guthrie',NULL,'jong.guthrie@hotmail.com','889 Leatherwood Drive ','Bethpage','NY',11714);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lise','Hebert',NULL,'lise.hebert@gmail.com','140 East Broad Lane ','Vista','CA',92083);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Joshua','Berg',NULL,'joshua.berg@hotmail.com','16 East St. ','Ossining','NY',10562);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Georgina','Gonzales',NULL,'georgina.gonzales@yahoo.com','307 Chapel St. ','Endicott','NY',13760);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rudolph','Velez',NULL,'rudolph.velez@yahoo.com','9397 Pleasant Drive ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Luke','Kramer',NULL,'luke.kramer@hotmail.com','7955 Delaware Drive ','Bethpage','NY',11714);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Edgar','Quinn',NULL,'edgar.quinn@aol.com','556 Dogwood Ave. ','Harlingen','TX',78552);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tara','Maynard',NULL,'tara.maynard@hotmail.com','9375 Fordham Street ','Lindenhurst','NY',11757);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bella','Perez',NULL,'bella.perez@msn.com','43 Green Lake Street ','Duarte','CA',91010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nathaniel','Davidson',NULL,'nathaniel.davidson@hotmail.com','7476 Henry Smith Street ','Rome','NY',13440);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Chauncey','Donaldson',NULL,'chauncey.donaldson@aol.com','7412 Golf Ave. ','Franklin Square','NY',11010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Heide','Reed',NULL,'heide.reed@yahoo.com','9174 Coffee Drive ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Trang','Hardin',NULL,'trang.hardin@yahoo.com','9255 Myers Drive ','Depew','NY',14043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gabriela','Warren','(562) 986-2247','gabriela.warren@aol.com','9947 Brewery Ave. ','Long Beach','NY',11561);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dale','Rasmussen',NULL,'dale.rasmussen@aol.com','8590 Adams Street ','Kingston','NY',12401);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tammie','Cherry',NULL,'tammie.cherry@hotmail.com','791 Wakehurst Dr. ','Massapequa','NY',11758);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bethany','Herring',NULL,'bethany.herring@yahoo.com','7563 High Point Street ','Port Jefferson Station','NY',11776);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Barbra','Dickerson',NULL,'barbra.dickerson@gmail.com','8424 E. Rockcrest Dr. ','Ridgecrest','CA',93555);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Neoma','Daugherty',NULL,'neoma.daugherty@gmail.com','80 Spring Street ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nanette','Roman',NULL,'nanette.roman@yahoo.com','8254 North Riverview Street ','Glendora','CA',91740);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Adriene','Rollins',NULL,'adriene.rollins@msn.com','55 Cambridge Street ','Plainview','NY',11803);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Susannah','Fields',NULL,'susannah.fields@hotmail.com','17 Railroad Street ','Far Rockaway','NY',11691);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dung','Reid',NULL,'dung.reid@msn.com','468 West Washington Ave. ','Canyon Country','CA',91387);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ben','Stone',NULL,'ben.stone@gmail.com','8855 University St. ','Ithaca','NY',14850);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nubia','Anderson',NULL,'nubia.anderson@aol.com','584 NW. Hilldale Drive ','Ronkonkoma','NY',11779);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rosamaria','Meyer',NULL,'rosamaria.meyer@yahoo.com','446 Elizabeth St. ','Webster','NY',14580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Todd','Waters',NULL,'todd.waters@yahoo.com','92 Cedar Swamp Street ','Bay Shore','NY',11706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kimbery','Nieves',NULL,'kimbery.nieves@msn.com','768 Roehampton St. ','San Carlos','CA',94070);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Phuong','Wolf',NULL,'phuong.wolf@yahoo.com','7765 N. Annadale Dr. ','Schenectady','NY',12302);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Adelaida','Hancock',NULL,'adelaida.hancock@aol.com','669 S. Gartner Street ','San Pablo','CA',94806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Brianne','Hays',NULL,'brianne.hays@gmail.com','88 Tailwater Ave. ','San Pablo','CA',94806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rufina','Chandler',NULL,'rufina.chandler@aol.com','7985 Alderwood Street ','New Hyde Park','NY',11040);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Devin','Velazquez','(631) 254-8497','devin.velazquez@aol.com','61 Redwood St. ','Brentwood','NY',11717);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bonita','Marshall',NULL,'bonita.marshall@msn.com','48 Bald Hill Drive ','Endicott','NY',13760);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Myrl','Gay',NULL,'myrl.gay@hotmail.com','8708 Taylor Lane ','Garland','TX',75043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Earline','Gordon',NULL,'earline.gordon@gmail.com','81 Railroad Drive ','Ronkonkoma','NY',11779);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sung','Chambers',NULL,'sung.chambers@gmail.com','369 N. Virginia Street ','Kingston','NY',12401);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Gustavo','Gamble',NULL,'gustavo.gamble@msn.com','8054 W. Meadowbrook Street ','Port Washington','NY',11050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ciera','Webb',NULL,'ciera.webb@yahoo.com','958 Anderson Ave. ','Orchard Park','NY',14127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Roy','Chan',NULL,'roy.chan@hotmail.com','7578 Middle River St. ','Pomona','CA',91768);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Houston','Vasquez',NULL,'houston.vasquez@msn.com','845 Aspen Street ','Fullerton','CA',92831);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cheree','Hale',NULL,'cheree.hale@yahoo.com','95 Lyme Avenue ','Oswego','NY',13126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Odette','Moses',NULL,'odette.moses@gmail.com','899 Overlook Lane ','Newburgh','NY',12550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lenita','Bonner',NULL,'lenita.bonner@aol.com','7286 Swanson Drive ','Los Banos','CA',93635);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shona','Mcmillan',NULL,'shona.mcmillan@msn.com','57 West Maple Dr. ','Apple Valley','CA',92307);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Piedad','Irwin',NULL,'piedad.irwin@hotmail.com','581 Garden St. ','Coram','NY',11727);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Loan','Graham',NULL,'loan.graham@yahoo.com','57 Glen Eagles St. ','Jackson Heights','NY',11372);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Stan','Saunders',NULL,'stan.saunders@yahoo.com','407 Essex Dr. ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jackeline','Colon',NULL,'jackeline.colon@msn.com','9916 Cedarwood Drive ','Wappingers Falls','NY',12590);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Marlen','Dawson',NULL,'marlen.dawson@msn.com','67 Oak Valley Street ','Woodside','NY',11377);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alexis','Mack','(845) 707-6088','alexis.mack@aol.com','7767 Sutor Ave. ','New City','NY',10956);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mica','Barry',NULL,'mica.barry@yahoo.com','3 SE. Sugar St. ','Hopewell Junction','NY',12533);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shanice','Spears',NULL,'shanice.spears@msn.com','5 Piper Ave. ','Brooklyn','NY',11201);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Garth','Huff',NULL,'garth.huff@yahoo.com','794 East University St. ','Glendora','CA',91740);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dione','Pratt',NULL,'dione.pratt@msn.com','864 Winding Way St. ','Pleasanton','CA',94566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Victor','Pittman',NULL,'victor.pittman@aol.com','9294 Devon Dr. ','Astoria','NY',11102);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Allie','Conley',NULL,'allie.conley@msn.com','96 High Point Road ','Lawndale','CA',90260);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shanelle','Anderson',NULL,'shanelle.anderson@yahoo.com','646 Surrey Street ','Bethpage','NY',11714);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Minnie','Compton',NULL,'minnie.compton@gmail.com','185 Hudson Street ','South Richmond Hill','NY',11419);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shiloh','Bates',NULL,'shiloh.bates@msn.com','15 Wellington Dr. ','Monsey','NY',10952);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lakenya','Oliver',NULL,'lakenya.oliver@yahoo.com','82 Bayport Court ','San Lorenzo','CA',94580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sally','Kinney',NULL,'sally.kinney@msn.com','7565 High Dr. ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Edith','Davenport',NULL,'edith.davenport@gmail.com','685 Alton Road ','Ontario','CA',91762);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alline','Beasley',NULL,'alline.beasley@yahoo.com','8704 NE. Olive Ave. ','North Tonawanda','NY',14120);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Travis','Whitley',NULL,'travis.whitley@aol.com','60 Euclid Ave. ','Saint Albans','NY',11412);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vanessa','West',NULL,'vanessa.west@gmail.com','34 Prairie Lane ','New Rochelle','NY',10801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Trudy','Riddle',NULL,'trudy.riddle@aol.com','8943 Johnson Street ','Schenectady','NY',12302);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shauna','Edwards',NULL,'shauna.edwards@msn.com','8 Dogwood Ave. ','Yorktown Heights','NY',10598);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Clorinda','Donovan',NULL,'clorinda.donovan@msn.com','9690 E. Morris Ave. ','Jamestown','NY',14701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Raven','Curtis',NULL,'raven.curtis@aol.com','18 Summit Lane ','Lawndale','CA',90260);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Verda','Gilbert',NULL,'verda.gilbert@gmail.com','54 Hillcrest Drive ','East Northport','NY',11731);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Renay','Atkins',NULL,'renay.atkins@aol.com','7146 Leeton Ridge Ave. ','Woodside','NY',11377);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tama','Berg',NULL,'tama.berg@hotmail.com','3 Cardinal Avenue ','Hollis','NY',11423);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dalia','Carson','(507) 186-2004','dalia.carson@aol.com','7175 Galvin St. ','Rochester','NY',14606);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('America','Swanson',NULL,'america.swanson@msn.com','83 South Arlington Lane ','Webster','NY',14580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cinda','Rocha',NULL,'cinda.rocha@hotmail.com','926 North Oklahoma Dr. ','Los Banos','CA',93635);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shea','Howell',NULL,'shea.howell@msn.com','67 Arch Rd. ','South El Monte','CA',91733);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kimberli','Cline',NULL,'kimberli.cline@yahoo.com','7115 Stonybrook Court ','Centereach','NY',11720);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Emanuel','Mckee',NULL,'emanuel.mckee@yahoo.com','9411 Lake Dr. ','Schenectady','NY',12302);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Whitley','Cannon',NULL,'whitley.cannon@msn.com','614 High Point Lane ','Coram','NY',11727);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tereasa','Bird',NULL,'tereasa.bird@aol.com','7526 Vine Drive ','Ronkonkoma','NY',11779);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dante','Grimes',NULL,'dante.grimes@yahoo.com','23 Shore St. ','Duarte','CA',91010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Joeann','Garrison',NULL,'joeann.garrison@yahoo.com','1 Harrison St. ','Ontario','CA',91762);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Omega','Johnston',NULL,'omega.johnston@gmail.com','9935 Tarkiln Hill St. ','Canyon Country','CA',91387);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Conrad','Mueller',NULL,'conrad.mueller@yahoo.com','3 Myrtle St. ','Massapequa','NY',11758);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Glady','Wells',NULL,'glady.wells@gmail.com','627 Ramblewood Ave. ','Syosset','NY',11791);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tisha','Petty','(210) 851-3122','tisha.petty@msn.com','9083 Lake View Ave. ','San Antonio','TX',78213);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Claris','Santiago',NULL,'claris.santiago@msn.com','763 Mountainview Dr. ','Newburgh','NY',12550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Obdulia','Barber',NULL,'obdulia.barber@gmail.com','878 Lexington Rd. ','Newburgh','NY',12550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shantel','Gregory',NULL,'shantel.gregory@yahoo.com','7722 Second Lane ','West Islip','NY',11795);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ai','Forbes',NULL,'ai.forbes@yahoo.com','254 Central St. ','Franklin Square','NY',11010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ebony','Cotton',NULL,'ebony.cotton@yahoo.com','8979 Miller St. ','West Babylon','NY',11704);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Arla','Ellis',NULL,'arla.ellis@yahoo.com','127 Crescent Ave. ','Utica','NY',13501);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Magdalena','Sherman',NULL,'magdalena.sherman@gmail.com','176 Sunbeam St. ','Oswego','NY',13126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tarra','Guerrero',NULL,'tarra.guerrero@aol.com','10 Baker St. ','Auburn','NY',13021);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Consuela','Romero',NULL,'consuela.romero@hotmail.com','54 Elm Court ','Monroe','NY',10950);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cindie','Franklin',NULL,'cindie.franklin@yahoo.com','7249 Franklin St. ','Lawndale','CA',90260);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sharyn','Brewer',NULL,'sharyn.brewer@aol.com','70 Columbia Ave. ','Hollis','NY',11423);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Karren','Stevenson',NULL,'karren.stevenson@aol.com','155 Old York St. ','San Carlos','CA',94070);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Divina','Reeves',NULL,'divina.reeves@hotmail.com','767 Bradford Dr. ','Newburgh','NY',12550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Novella','Ross',NULL,'novella.ross@gmail.com','9418 Acacia Drive ','Glendora','CA',91740);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Omega','Huff',NULL,'omega.huff@aol.com','63 Devon St. ','Santa Monica','CA',90403);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ashleigh','Finch',NULL,'ashleigh.finch@yahoo.com','82 Hudson Court ','Newburgh','NY',12550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Corina','Lynch',NULL,'corina.lynch@msn.com','44 Sunbeam Dr. ','Rosedale','NY',11422);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Joe','Melton',NULL,'joe.melton@gmail.com','8998 Hartford Street ','New Windsor','NY',12553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Bernetta','Summers',NULL,'bernetta.summers@aol.com','1 Young Ave. ','Longview','TX',75604);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Inez','Snider',NULL,'inez.snider@gmail.com','837 Catherine Lane ','Ronkonkoma','NY',11779);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Neida','King','(442) 778-1121','neida.king@aol.com','137 Bohemia St. ','Oceanside','NY',11572);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tona','Velasquez',NULL,'tona.velasquez@msn.com','9166 Trout St. ','Whitestone','NY',11357);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rozanne','Reyes',NULL,'rozanne.reyes@aol.com','11 W. Surrey Drive ','Garden City','NY',11530);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lekisha','Pope',NULL,'lekisha.pope@msn.com','390 Livingston Avenue ','Freeport','NY',11520);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jama','Rodriquez',NULL,'jama.rodriquez@msn.com','681 Smith Dr. ','Upland','CA',91784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Eloisa','Tucker',NULL,'eloisa.tucker@hotmail.com','7268 Leatherwood Ave. ','Howard Beach','NY',11414);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Arie','Hunter',NULL,'arie.hunter@msn.com','66 Old State Rd. ','Flushing','NY',11354);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sanora','Webster','(424) 464-7290','sanora.webster@msn.com','74 Beach St. ','Los Angeles','CA',90008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kate','Barber',NULL,'kate.barber@hotmail.com','46 W. Oak Valley Ave. ','Saratoga Springs','NY',12866);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Yvone','Guerrero',NULL,'yvone.guerrero@aol.com','8548 Jackson Ave. ','Merrick','NY',11566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kami','Rios',NULL,'kami.rios@yahoo.com','8400 8th Dr. ','Encino','CA',91316);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Annett','Rush',NULL,'annett.rush@hotmail.com','758 Fordham Lane ','Rosedale','NY',11422);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carman','Hardy',NULL,'carman.hardy@yahoo.com','800 Whitemarsh St. ','Jamestown','NY',14701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dorothea','Miranda',NULL,'dorothea.miranda@aol.com','7882 Parker St. ','Upland','CA',91784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Agatha','Daniels',NULL,'agatha.daniels@yahoo.com','125 Canal St. ','South El Monte','CA',91733);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Alexandria','Zamora',NULL,'alexandria.zamora@yahoo.com','95 Cherry Circle ','Schenectady','NY',12302);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Thad','Gilliam',NULL,'thad.gilliam@hotmail.com','8844 Gonzales Court ','Levittown','NY',11756);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Inger','Jennings',NULL,'inger.jennings@yahoo.com','38 NW. Shore Lane ','Patchogue','NY',11772);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Karren','Lamb','(559) 628-2239','karren.lamb@aol.com','35 N. Chapel St. ','Fresno','CA',93706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Noble','Glover',NULL,'noble.glover@gmail.com','728 W. Rocky River Street ','Orchard Park','NY',14127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Octavia','Donaldson',NULL,'octavia.donaldson@hotmail.com','8095 Wayne Ave. ','Levittown','NY',11756);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Latashia','Travis',NULL,'latashia.travis@yahoo.com','7877 King Rd. ','Upland','CA',91784);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Destiny','Goodman',NULL,'destiny.goodman@msn.com','29 Smoky Hollow St. ','Westbury','NY',11590);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Christiana','Gross',NULL,'christiana.gross@yahoo.com','645 North Richardson Road ','Orchard Park','NY',14127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nestor','Haynes','(281) 969-4579','nestor.haynes@msn.com','27 Nut Swamp Street ','Houston','TX',77016);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Grisel','Maynard',NULL,'grisel.maynard@msn.com','353 North Arch St. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shenna','Espinoza',NULL,'shenna.espinoza@gmail.com','202 North George Street ','Queensbury','NY',12804);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Trena','Rogers',NULL,'trena.rogers@aol.com','502 Sherwood St. ','Campbell','CA',95008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lucile','Manning',NULL,'lucile.manning@yahoo.com','511 Livingston Lane ','Campbell','CA',95008);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Veronique','Fulton',NULL,'veronique.fulton@yahoo.com','81 Hilldale Ave. ','Ballston Spa','NY',12020);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Starr','Schneider',NULL,'starr.schneider@aol.com','77 Mulberry Street ','Shirley','NY',11967);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Rona','Rojas','(408) 611-3553','rona.rojas@gmail.com','815 Riverview St. ','San Jose','CA',95127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Pandora','Estes',NULL,'pandora.estes@aol.com','228 Shadow Brook Drive ','New Hyde Park','NY',11040);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Renna','Williams',NULL,'renna.williams@hotmail.com','7398 SW. Glen Ridge Road ','South Ozone Park','NY',11420);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lanora','Robbins',NULL,'lanora.robbins@hotmail.com','31 W. Maiden Lane ','West Babylon','NY',11704);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Juliane','Dillard',NULL,'juliane.dillard@aol.com','63 Birchwood Court ','Glendora','CA',91740);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carlena','Salinas',NULL,'carlena.salinas@gmail.com','1 Wagon Street ','Jamaica','NY',11432);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kimberley','Reynolds',NULL,'kimberley.reynolds@aol.com','8475 Homewood Street ','Port Washington','NY',11050);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Johana','Jacobson','(507) 407-9384','johana.jacobson@gmail.com','29 San Juan St. ','Rochester','NY',14606);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Enoch','Rosario','(559) 329-7615','enoch.rosario@hotmail.com','186 Arlington St. ','Fresno','CA',93706);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dorine','Thornton',NULL,'dorine.thornton@gmail.com','8730 N. Atlantic Street ','Sunnyside','NY',11104);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Eliz','Lynch',NULL,'eliz.lynch@hotmail.com','717 West Deerfield Ave. ','Uniondale','NY',11553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mercedez','Brooks',NULL,'mercedez.brooks@hotmail.com','7483 Ann St. ','Duarte','CA',91010);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Wynona','Douglas',NULL,'wynona.douglas@msn.com','6 Country Ave. ','Harlingen','TX',78552);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Desire','Mcgowan','(661) 800-8091','desire.mcgowan@msn.com','942 North Ohio Road ','Bakersfield','CA',93306);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elmo','Sweeney',NULL,'elmo.sweeney@yahoo.com','43 Arch Ave. ','San Carlos','CA',94070);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kenton','Hughes',NULL,'kenton.hughes@gmail.com','632 Sleepy Hollow Drive ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cesar','Wilkins','(619) 685-5786','cesar.wilkins@hotmail.com','7 Inverness St. ','San Diego','CA',92111);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Phylicia','Stout',NULL,'phylicia.stout@aol.com','8842 Littleton Lane ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nanette','Harris',NULL,'nanette.harris@hotmail.com','26 Pin Oak Lane ','East Meadow','NY',11554);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ulrike','Chan',NULL,'ulrike.chan@aol.com','7949 Lancaster St. ','Port Chester','NY',10573);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Genoveva','Lloyd',NULL,'genoveva.lloyd@aol.com','706 Devonshire St. ','Bayside','NY',11361);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sheryl','Chase',NULL,'sheryl.chase@gmail.com','388 Cedar Avenue ','Floral Park','NY',11001);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Trista','Lambert',NULL,'trista.lambert@gmail.com','79 River Street ','Fairport','NY',14450);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Vivian','Deleon',NULL,'vivian.deleon@msn.com','9925 Hamilton Street ','Jamaica','NY',11432);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Genny','Fields',NULL,'genny.fields@msn.com','9145 San Juan Dr. ','Amityville','NY',11701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Eliseo','Knight',NULL,'eliseo.knight@msn.com','693 Holly Street ','Woodhaven','NY',11421);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Delma','Bailey','(657) 454-8493','delma.bailey@gmail.com','9883 West King Lane ','Anaheim','CA',92806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dewayne','Herring',NULL,'dewayne.herring@aol.com','9015 Willow Lane ','Webster','NY',14580);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nevada','Hood',NULL,'nevada.hood@aol.com','515 Bank Rd. ','Hopewell Junction','NY',12533);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Angelika','Perry',NULL,'angelika.perry@msn.com','7684 South Branch Drive ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shayla','Hart',NULL,'shayla.hart@msn.com','9092 Aspen St. ','Woodhaven','NY',11421);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Willetta','Murphy',NULL,'willetta.murphy@msn.com','436 Devonshire Street ','East Elmhurst','NY',11369);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sandee','Alvarado',NULL,'sandee.alvarado@aol.com','69 Bowman Street ','Depew','NY',14043);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mila','Moody','(248) 234-5902','mila.moody@gmail.com','675 Williams St. ','Troy','NY',12180);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Loyce','Conway',NULL,'loyce.conway@aol.com','729 State Lane ','Central Islip','NY',11722);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Thanh','Figueroa',NULL,'thanh.figueroa@yahoo.com','6 Roberts Drive ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Farrah','Orr',NULL,'farrah.orr@msn.com','8711 W. Ashley St. ','New Hyde Park','NY',11040);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Hugh','Craft',NULL,'hugh.craft@msn.com','8716 Homewood Court ','Centereach','NY',11720);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Eleanor','Mendez',NULL,'eleanor.mendez@yahoo.com','4 West St. ','Port Chester','NY',10573);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lamar','Bush','(716) 294-7174','lamar.bush@msn.com','76 Lilac Drive ','Buffalo','NY',14215);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lurlene','Finch','(914) 367-7691','lurlene.finch@msn.com','849 Magnolia St. ','Yonkers','NY',10701);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Shanda','Stevenson',NULL,'shanda.stevenson@yahoo.com','9547 N. Courtland St. ','Freeport','NY',11520);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Adrien','Hunter',NULL,'adrien.hunter@yahoo.com','720 Thompson Lane ','Rego Park','NY',11374);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ophelia','Decker',NULL,'ophelia.decker@yahoo.com','69 Rockwell Court ','New Windsor','NY',12553);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Sonja','Walls',NULL,'sonja.walls@aol.com','30 Marshall Dr. ','Queensbury','NY',12804);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Harold','O''connor',NULL,'harold.o''connor@gmail.com','9530 Summerhouse Street ','Santa Cruz','CA',95060);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Miranda','Kennedy',NULL,'miranda.kennedy@gmail.com','726 East High St. ','Astoria','NY',11102);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jasper','Castro',NULL,'jasper.castro@aol.com','977 SE. Railroad Road ','Forney','TX',75126);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Penni','Best','(657) 611-2991','penni.best@msn.com','875 Second Drive ','Anaheim','CA',92806);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lurlene','Cotton',NULL,'lurlene.cotton@yahoo.com','8218 George St. ','Pleasanton','CA',94566);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Kelsey','Noble',NULL,'kelsey.noble@hotmail.com','36 Pearl Court ','Mount Vernon','NY',10550);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Edris','Barrett',NULL,'edris.barrett@hotmail.com','36 Pulaski Drive ','Plattsburgh','NY',12901);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tempie','Jacobson',NULL,'tempie.jacobson@hotmail.com','136 Old Fairview St. ','Smithtown','NY',11787);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Dollie','Cervantes','(682) 362-7457','dollie.cervantes@aol.com','8828 Applegate Drive ','Fort Worth','TX',76110);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lashunda','Cole',NULL,'lashunda.cole@hotmail.com','783 Baker St. ','Monsey','NY',10952);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Justina','Jenkins',NULL,'justina.jenkins@msn.com','345 SE. Green Lane ','Shirley','NY',11967);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Londa','Gould','(361) 206-5550','londa.gould@aol.com','9169 Beech Lane ','Corpus Christi','TX',78418);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mikel','Wilkerson',NULL,'mikel.wilkerson@msn.com','9233 Clinton St. ','Atwater','CA',95301);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Carola','Johns',NULL,'carola.johns@msn.com','7077 Fordham Rd. ','Santa Cruz','CA',95060);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lorrie','Justice',NULL,'lorrie.justice@gmail.com','8396 Brook Drive ','Pomona','CA',91768);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Tayna','Wade','(661) 858-1224','tayna.wade@hotmail.com','65 Smith Store Dr. ','Bakersfield','CA',93306);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Mark','Benton',NULL,'mark.benton@aol.com','83 Eagle St. ','East Elmhurst','NY',11369);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Zona','Cameron',NULL,'zona.cameron@aol.com','42 Bridle Court ','East Northport','NY',11731);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Nicola','Knight',NULL,'nicola.knight@aol.com','25 SE. Miles Lane ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Elana','Miles',NULL,'elana.miles@yahoo.com','7077 Euclid Ave. ','Liverpool','NY',13090);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Merrie','Fowler',NULL,'merrie.fowler@aol.com','532 Leatherwood Ave. ','Scarsdale','NY',10583);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Macie','Ayers',NULL,'macie.ayers@msn.com','8730 Longfellow St. ','Bellmore','NY',11710);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Son','Warner',NULL,'son.warner@hotmail.com','20 W. Rosewood Ave. ','Rockville Centre','NY',11570);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lee','Dunn','(408) 807-6157','lee.dunn@aol.com','8626 Grand Ave. ','San Jose','CA',95127);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Florrie','Little',NULL,'florrie.little@yahoo.com','8330 Marsh St. ','New Rochelle','NY',10801);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ernest','Rollins',NULL,'ernest.rollins@yahoo.com','4 West Ridge Dr. ','Oakland Gardens','NY',11364);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Jamaal','Morrison',NULL,'jamaal.morrison@msn.com','796 SE. Nut Swamp St. ','Staten Island','NY',10301);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Cassie','Cline',NULL,'cassie.cline@gmail.com','947 Lafayette Drive ','Brooklyn','NY',11201);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Lezlie','Lamb',NULL,'lezlie.lamb@gmail.com','401 Brandywine Street ','Central Islip','NY',11722);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ivette','Estes',NULL,'ivette.estes@gmail.com','88 N. Canterbury Ave. ','Canandaigua','NY',14424);
INSERT INTO sales.customers(first_name, last_name, phone, email, street, city, state, zip_code) VALUES('Ester','Acevedo',NULL,'ester.acevedo@gmail.com','671 Miles Court ','San Lorenzo','CA',94580);

-- stores

INSERT INTO sales.stores(store_name, phone, email, street, city, state, zip_code)
VALUES('Santa Cruz Bikes','(831) 476-4321','santacruz@bikes.shop','3700 Portola Drive', 'Santa Cruz','CA',95060),
      ('Baldwin Bikes','(516) 379-8888','baldwin@bikes.shop','4200 Chestnut Lane', 'Baldwin','NY',11432),
      ('Rowlett Bikes','(972) 530-5555','rowlett@bikes.shop','8000 Fairway Avenue', 'Rowlett','TX',75088);


-- production.stocks 
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,1,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,2,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,3,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,4,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,5,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,6,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,7,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,8,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,9,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,10,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,11,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,12,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,13,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,14,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,15,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,16,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,17,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,18,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,19,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,20,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,21,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,22,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,23,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,24,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,25,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,26,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,27,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,28,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,29,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,30,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,31,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,32,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,33,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,34,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,35,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,36,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,37,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,38,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,39,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,40,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,41,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,42,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,43,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,44,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,45,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,46,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,47,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,48,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,49,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,50,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,51,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,52,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,53,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,54,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,55,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,56,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,57,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,58,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,59,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,60,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,61,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,62,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,63,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,64,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,65,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,66,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,67,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,68,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,69,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,70,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,71,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,72,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,73,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,74,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,75,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,76,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,77,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,78,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,79,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,80,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,81,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,82,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,83,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,84,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,85,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,86,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,87,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,88,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,89,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,90,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,91,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,92,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,93,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,94,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,95,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,96,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,97,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,98,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,99,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,100,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,101,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,102,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,103,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,104,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,105,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,106,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,107,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,108,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,109,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,110,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,111,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,112,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,113,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,114,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,115,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,116,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,117,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,118,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,119,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,120,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,121,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,122,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,123,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,124,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,125,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,126,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,127,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,128,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,129,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,130,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,131,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,132,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,133,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,134,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,135,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,136,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,137,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,138,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,139,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,140,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,141,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,142,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,143,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,144,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,145,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,146,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,147,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,148,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,149,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,150,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,151,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,152,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,153,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,154,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,155,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,156,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,157,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,158,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,159,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,160,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,161,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,162,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,163,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,164,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,165,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,166,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,167,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,168,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,169,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,170,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,171,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,172,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,173,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,174,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,175,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,176,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,177,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,178,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,179,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,180,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,181,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,182,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,183,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,184,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,185,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,186,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,187,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,188,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,189,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,190,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,191,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,192,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,193,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,194,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,195,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,196,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,197,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,198,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,199,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,200,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,201,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,202,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,203,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,204,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,205,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,206,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,207,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,208,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,209,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,210,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,211,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,212,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,213,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,214,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,215,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,216,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,217,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,218,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,219,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,220,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,221,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,222,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,223,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,224,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,225,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,226,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,227,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,228,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,229,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,230,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,231,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,232,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,233,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,234,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,235,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,236,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,237,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,238,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,239,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,240,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,241,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,242,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,243,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,244,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,245,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,246,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,247,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,248,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,249,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,250,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,251,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,252,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,253,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,254,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,255,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,256,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,257,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,258,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,259,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,260,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,261,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,262,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,263,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,264,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,265,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,266,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,267,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,268,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,269,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,270,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,271,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,272,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,273,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,274,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,275,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,276,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,277,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,278,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,279,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,280,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,281,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,282,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,283,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,284,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,285,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,286,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,287,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,288,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,289,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,290,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,291,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,292,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,293,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,294,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,295,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,296,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,297,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,298,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,299,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,300,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,301,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,302,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,303,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,304,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,305,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,306,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,307,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,308,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,309,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,310,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,311,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,312,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(1,313,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,1,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,2,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,3,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,4,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,5,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,6,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,7,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,8,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,9,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,10,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,11,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,12,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,13,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,14,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,15,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,16,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,17,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,18,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,19,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,20,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,21,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,22,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,23,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,24,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,25,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,26,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,27,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,28,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,29,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,30,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,31,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,32,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,33,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,34,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,35,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,36,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,37,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,38,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,39,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,40,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,41,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,42,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,43,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,44,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,45,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,46,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,47,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,48,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,49,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,50,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,51,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,52,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,53,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,54,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,55,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,56,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,57,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,58,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,59,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,60,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,61,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,62,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,63,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,64,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,65,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,66,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,67,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,68,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,69,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,70,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,71,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,72,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,73,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,74,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,75,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,76,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,77,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,78,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,79,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,80,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,81,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,82,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,83,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,84,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,85,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,86,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,87,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,88,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,89,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,90,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,91,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,92,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,93,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,94,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,95,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,96,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,97,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,98,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,99,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,100,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,101,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,102,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,103,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,104,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,105,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,106,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,107,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,108,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,109,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,110,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,111,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,112,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,113,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,114,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,115,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,116,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,117,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,118,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,119,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,120,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,121,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,122,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,123,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,124,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,125,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,126,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,127,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,128,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,129,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,130,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,131,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,132,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,133,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,134,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,135,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,136,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,137,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,138,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,139,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,140,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,141,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,142,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,143,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,144,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,145,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,146,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,147,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,148,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,149,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,150,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,151,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,152,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,153,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,154,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,155,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,156,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,157,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,158,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,159,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,160,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,161,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,162,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,163,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,164,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,165,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,166,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,167,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,168,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,169,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,170,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,171,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,172,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,173,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,174,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,175,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,176,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,177,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,178,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,179,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,180,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,181,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,182,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,183,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,184,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,185,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,186,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,187,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,188,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,189,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,190,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,191,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,192,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,193,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,194,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,195,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,196,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,197,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,198,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,199,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,200,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,201,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,202,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,203,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,204,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,205,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,206,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,207,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,208,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,209,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,210,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,211,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,212,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,213,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,214,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,215,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,216,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,217,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,218,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,219,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,220,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,221,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,222,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,223,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,224,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,225,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,226,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,227,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,228,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,229,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,230,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,231,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,232,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,233,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,234,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,235,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,236,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,237,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,238,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,239,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,240,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,241,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,242,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,243,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,244,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,245,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,246,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,247,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,248,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,249,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,250,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,251,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,252,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,253,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,254,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,255,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,256,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,257,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,258,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,259,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,260,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,261,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,262,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,263,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,264,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,265,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,266,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,267,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,268,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,269,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,270,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,271,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,272,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,273,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,274,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,275,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,276,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,277,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,278,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,279,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,280,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,281,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,282,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,283,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,284,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,285,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,286,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,287,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,288,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,289,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,290,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,291,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,292,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,293,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,294,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,295,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,296,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,297,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,298,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,299,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,300,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,301,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,302,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,303,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,304,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,305,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,306,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,307,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,308,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,309,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,310,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,311,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,312,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(2,313,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,1,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,2,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,3,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,4,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,5,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,6,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,7,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,8,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,9,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,10,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,11,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,12,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,13,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,14,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,15,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,16,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,17,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,18,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,19,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,20,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,21,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,22,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,23,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,24,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,25,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,26,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,27,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,28,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,29,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,30,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,31,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,32,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,33,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,34,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,35,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,36,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,37,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,38,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,39,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,40,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,41,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,42,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,43,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,44,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,45,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,46,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,47,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,48,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,49,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,50,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,51,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,52,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,53,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,54,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,55,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,56,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,57,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,58,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,59,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,60,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,61,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,62,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,63,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,64,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,65,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,66,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,67,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,68,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,69,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,70,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,71,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,72,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,73,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,74,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,75,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,76,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,77,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,78,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,79,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,80,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,81,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,82,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,83,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,84,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,85,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,86,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,87,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,88,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,89,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,90,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,91,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,92,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,93,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,94,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,95,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,96,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,97,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,98,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,99,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,100,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,101,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,102,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,103,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,104,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,105,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,106,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,107,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,108,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,109,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,110,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,111,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,112,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,113,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,114,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,115,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,116,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,117,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,118,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,119,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,120,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,121,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,122,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,123,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,124,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,125,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,126,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,127,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,128,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,129,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,130,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,131,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,132,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,133,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,134,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,135,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,136,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,137,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,138,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,139,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,140,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,141,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,142,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,143,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,144,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,145,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,146,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,147,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,148,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,149,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,150,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,151,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,152,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,153,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,154,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,155,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,156,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,157,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,158,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,159,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,160,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,161,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,162,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,163,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,164,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,165,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,166,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,167,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,168,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,169,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,170,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,171,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,172,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,173,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,174,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,175,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,176,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,177,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,178,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,179,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,180,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,181,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,182,28);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,183,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,184,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,185,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,186,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,187,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,188,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,189,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,190,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,191,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,192,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,193,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,194,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,195,20);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,196,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,197,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,198,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,199,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,200,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,201,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,202,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,203,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,204,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,205,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,206,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,207,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,208,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,209,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,210,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,211,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,212,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,213,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,214,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,215,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,216,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,217,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,218,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,219,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,220,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,221,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,222,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,223,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,224,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,225,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,226,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,227,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,228,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,229,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,230,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,231,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,232,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,233,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,234,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,235,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,236,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,237,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,238,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,239,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,240,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,241,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,242,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,243,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,244,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,245,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,246,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,247,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,248,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,249,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,250,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,251,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,252,27);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,253,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,254,4);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,255,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,256,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,257,25);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,258,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,259,0);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,260,5);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,261,24);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,262,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,263,21);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,264,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,265,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,266,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,267,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,268,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,269,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,270,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,271,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,272,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,273,19);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,274,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,275,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,276,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,277,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,278,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,279,15);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,280,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,281,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,282,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,283,1);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,284,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,285,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,286,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,287,26);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,288,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,289,2);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,290,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,291,10);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,292,16);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,293,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,294,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,295,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,296,12);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,297,22);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,298,14);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,299,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,300,3);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,301,29);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,302,6);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,303,13);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,304,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,305,11);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,306,7);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,307,17);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,308,9);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,309,30);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,310,8);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,311,23);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,312,18);
INSERT INTO production.stocks(store_id, product_id, quantity) VALUES(3,313,0);

SET IDENTITY_INSERT sales.staffs ON;  

INSERT INTO sales.staffs(staff_id, first_name, last_name, email, phone, active, store_id, manager_id) VALUES(1,'Fabiola','Jackson','fabiola.jackson@bikes.shop','(831) 555-5554',1,1,NULL);
INSERT INTO sales.staffs(staff_id, first_name, last_name, email, phone, active, store_id, manager_id) VALUES(2,'Mireya','Copeland','mireya.copeland@bikes.shop','(831) 555-5555',1,1,1);
INSERT INTO sales.staffs(staff_id, first_name, last_name, email, phone, active, store_id, manager_id) VALUES(3,'Genna','Serrano','genna.serrano@bikes.shop','(831) 555-5556',1,1,2);
INSERT INTO sales.staffs(staff_id, first_name, last_name, email, phone, active, store_id, manager_id) VALUES(4,'Virgie','Wiggins','virgie.wiggins@bikes.shop','(831) 555-5557',1,1,2);
INSERT INTO sales.staffs(staff_id, first_name, last_name, email, phone, active, store_id, manager_id) VALUES(5,'Jannette','David','jannette.david@bikes.shop','(516) 379-4444',1,2,1);
INSERT INTO sales.staffs(staff_id, first_name, last_name, email, phone, active, store_id, manager_id) VALUES(6,'Marcelene','Boyer','marcelene.boyer@bikes.shop','(516) 379-4445',1,2,5);
INSERT INTO sales.staffs(staff_id, first_name, last_name, email, phone, active, store_id, manager_id) VALUES(7,'Venita','Daniel','venita.daniel@bikes.shop','(516) 379-4446',1,2,5);
INSERT INTO sales.staffs(staff_id, first_name, last_name, email, phone, active, store_id, manager_id) VALUES(8,'Kali','Vargas','kali.vargas@bikes.shop','(972) 530-5555',1,3,1);
INSERT INTO sales.staffs(staff_id, first_name, last_name, email, phone, active, store_id, manager_id) VALUES(9,'Layla','Terrell','layla.terrell@bikes.shop','(972) 530-5556',1,3,7);
INSERT INTO sales.staffs(staff_id, first_name, last_name, email, phone, active, store_id, manager_id) VALUES(10,'Bernardine','Houston','bernardine.houston@bikes.shop','(972) 530-5557',1,3,7);

SET IDENTITY_INSERT sales.staffs OFF;  

SET IDENTITY_INSERT sales.orders ON;  
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1,259,4,'20160101','20160103','20160103',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(2,1212,4,'20160101','20160104','20160103',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(3,523,4,'20160102','20160105','20160103',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(4,175,4,'20160103','20160104','20160105',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(5,1324,4,'20160103','20160106','20160106',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(6,94,4,'20160104','20160107','20160105',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(7,324,4,'20160104','20160107','20160105',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(8,1204,4,'20160104','20160105','20160105',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(9,60,4,'20160105','20160108','20160108',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(10,442,4,'20160105','20160106','20160106',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(11,1326,4,'20160105','20160108','20160107',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(12,91,4,'20160106','20160108','20160109',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(13,873,4,'20160108','20160111','20160111',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(14,258,4,'20160109','20160111','20160112',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(15,450,4,'20160109','20160110','20160112',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(16,552,4,'20160112','20160115','20160115',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(17,1175,4,'20160112','20160114','20160114',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(18,541,4,'20160114','20160117','20160115',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(19,696,4,'20160114','20160117','20160116',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(20,923,4,'20160114','20160116','20160117',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(21,1250,4,'20160115','20160116','20160118',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(22,1035,4,'20160116','20160118','20160117',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(23,1149,4,'20160116','20160119','20160119',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(24,636,4,'20160118','20160120','20160119',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(25,657,4,'20160118','20160121','20160121',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(26,1280,4,'20160118','20160121','20160119',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(27,57,4,'20160119','20160121','20160120',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(28,252,4,'20160119','20160120','20160121',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(29,437,4,'20160120','20160122','20160121',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(30,1348,4,'20160120','20160121','20160121',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(31,1238,4,'20160120','20160122','20160122',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(32,1259,4,'20160121','20160124','20160122',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(33,236,4,'20160121','20160122','20160122',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(34,80,4,'20160122','20160125','20160123',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(35,813,4,'20160122','20160125','20160124',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(36,1321,4,'20160123','20160124','20160124',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(37,164,4,'20160125','20160128','20160126',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(38,583,4,'20160125','20160127','20160126',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(39,1296,4,'20160125','20160126','20160126',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(40,348,4,'20160127','20160128','20160129',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(41,979,4,'20160127','20160130','20160129',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(42,1095,4,'20160127','20160128','20160130',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(43,1434,4,'20160127','20160128','20160130',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(44,861,4,'20160128','20160131','20160130',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(45,1220,4,'20160128','20160131','20160131',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(46,746,4,'20160129','20160131','20160131',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(47,1234,4,'20160129','20160130','20160131',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(48,1012,4,'20160130','20160201','20160202',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(49,608,4,'20160131','20160201','20160202',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(50,872,4,'20160131','20160203','20160202',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(51,1047,4,'20160201','20160202','20160203',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(52,767,4,'20160203','20160204','20160205',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(53,965,4,'20160203','20160204','20160205',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(54,535,4,'20160204','20160207','20160207',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(55,1173,4,'20160204','20160207','20160206',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(56,1241,4,'20160204','20160206','20160207',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(57,1305,4,'20160204','20160206','20160206',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(58,504,4,'20160205','20160207','20160207',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(59,563,4,'20160205','20160207','20160206',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(60,151,4,'20160206','20160208','20160207',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(61,277,4,'20160206','20160209','20160209',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(62,208,4,'20160207','20160210','20160210',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(63,1075,4,'20160207','20160209','20160209',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(64,1185,4,'20160207','20160208','20160209',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(65,996,4,'20160208','20160209','20160211',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(66,1253,4,'20160209','20160212','20160212',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(67,526,4,'20160209','20160211','20160210',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(68,381,4,'20160210','20160211','20160213',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(69,1413,4,'20160210','20160212','20160211',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(70,50,3,'20160211','20160211',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(71,797,4,'20160211','20160214','20160212',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(72,1386,4,'20160212','20160215','20160213',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(73,612,4,'20160212','20160215','20160214',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(74,264,4,'20160213','20160215','20160215',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(75,587,4,'20160214','20160215','20160217',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(76,9,3,'20160216','20160216',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(77,385,4,'20160216','20160219','20160219',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(78,1182,4,'20160216','20160218','20160219',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(79,529,4,'20160217','20160220','20160220',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(80,397,4,'20160217','20160220','20160219',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(81,521,4,'20160217','20160219','20160218',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(82,1223,4,'20160218','20160221','20160220',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(83,393,4,'20160219','20160220','20160220',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(84,317,4,'20160220','20160222','20160221',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(85,1174,4,'20160220','20160223','20160221',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(86,276,4,'20160221','20160222','20160223',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(87,516,4,'20160221','20160222','20160223',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(88,1069,4,'20160221','20160222','20160223',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(89,668,4,'20160221','20160224','20160224',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(90,414,4,'20160223','20160225','20160224',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(91,648,4,'20160225','20160227','20160228',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(92,1309,4,'20160225','20160228','20160228',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(93,1328,4,'20160226','20160228','20160227',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(94,929,4,'20160227','20160228','20160229',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(95,218,4,'20160227','20160229','20160228',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(96,1094,4,'20160227','20160229','20160228',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(97,204,4,'20160228','20160229','20160301',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(98,1194,4,'20160228','20160229','20160229',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(99,1165,4,'20160229','20160301','20160303',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(100,1237,4,'20160301','20160304','20160303',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(101,271,4,'20160301','20160304','20160304',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(102,336,4,'20160302','20160305','20160303',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(103,991,4,'20160303','20160306','20160305',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(104,7,4,'20160303','20160305','20160305',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(105,306,4,'20160303','20160305','20160304',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(106,422,4,'20160304','20160305','20160305',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(107,633,4,'20160306','20160309','20160309',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(108,12,4,'20160306','20160309','20160307',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(109,1255,4,'20160306','20160309','20160309',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(110,677,4,'20160306','20160308','20160309',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(111,630,4,'20160307','20160310','20160310',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(112,469,4,'20160308','20160311','20160310',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(113,1078,4,'20160308','20160311','20160311',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(114,1431,4,'20160308','20160310','20160311',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(115,1369,4,'20160309','20160311','20160311',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(116,471,4,'20160310','20160311','20160311',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(117,740,4,'20160310','20160313','20160311',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(118,577,4,'20160312','20160314','20160313',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(119,925,4,'20160312','20160314','20160314',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(120,327,4,'20160314','20160315','20160317',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(121,755,4,'20160314','20160315','20160316',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(122,786,4,'20160314','20160316','20160315',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(123,766,4,'20160315','20160318','20160317',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(124,403,4,'20160316','20160318','20160317',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(125,685,4,'20160316','20160319','20160317',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(126,1365,4,'20160316','20160318','20160318',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(127,484,4,'20160317','20160318','20160319',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(128,86,4,'20160318','20160320','20160321',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(129,84,4,'20160319','20160321','20160321',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(130,1049,4,'20160319','20160322','20160320',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(131,316,4,'20160319','20160322','20160320',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(132,46,4,'20160320','20160322','20160323',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(133,409,4,'20160320','20160322','20160321',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(134,679,4,'20160320','20160321','20160321',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(135,1354,4,'20160321','20160323','20160323',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(136,1192,4,'20160321','20160324','20160323',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(137,370,4,'20160323','20160326','20160325',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(138,438,4,'20160323','20160324','20160325',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(139,710,4,'20160323','20160324','20160326',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(140,1264,4,'20160323','20160326','20160326',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(141,557,4,'20160325','20160327','20160326',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(142,170,4,'20160326','20160327','20160327',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(143,693,4,'20160326','20160328','20160328',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(144,1124,4,'20160326','20160329','20160329',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(145,366,4,'20160327','20160329','20160330',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(146,288,4,'20160328','20160330','20160330',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(147,55,4,'20160328','20160331','20160331',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(148,714,4,'20160328','20160330','20160330',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(149,763,4,'20160328','20160330','20160329',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(150,332,4,'20160329','20160331','20160401',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(151,926,4,'20160329','20160401','20160331',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(152,76,4,'20160329','20160330','20160330',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(153,498,4,'20160330','20160402','20160401',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(154,1286,4,'20160331','20160401','20160401',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(155,371,4,'20160402','20160403','20160404',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(156,357,4,'20160403','20160406','20160405',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(157,43,4,'20160403','20160406','20160406',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(158,117,3,'20160404','20160404',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(159,32,4,'20160404','20160406','20160406',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(160,205,4,'20160404','20160406','20160406',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(161,251,4,'20160404','20160407','20160405',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(162,31,4,'20160406','20160408','20160407',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(163,1325,4,'20160406','20160407','20160407',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(164,610,4,'20160407','20160408','20160409',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(165,574,4,'20160408','20160410','20160410',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(166,338,4,'20160408','20160411','20160411',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(167,1034,4,'20160408','20160409','20160411',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(168,1147,4,'20160409','20160412','20160411',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(169,99,4,'20160410','20160411','20160411',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(170,1200,4,'20160410','20160411','20160413',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(171,237,4,'20160411','20160414','20160414',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(172,1079,4,'20160411','20160412','20160414',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(173,117,4,'20160411','20160414','20160413',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(174,1361,4,'20160412','20160413','20160415',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(175,951,4,'20160413','20160414','20160414',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(176,643,4,'20160415','20160416','20160417',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(177,121,4,'20160416','20160419','20160419',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(178,756,4,'20160416','20160417','20160418',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(179,616,4,'20160417','20160419','20160419',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(180,918,4,'20160417','20160420','20160419',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(181,459,4,'20160418','20160420','20160420',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(182,854,4,'20160418','20160419','20160420',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(183,22,4,'20160419','20160420','20160420',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(184,134,4,'20160419','20160421','20160422',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(185,24,3,'20160420','20160420',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(186,1127,4,'20160421','20160422','20160424',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(187,183,4,'20160422','20160423','20160424',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(188,390,4,'20160422','20160423','20160425',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(189,1288,4,'20160423','20160424','20160426',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(190,98,4,'20160423','20160425','20160425',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(191,919,4,'20160427','20160428','20160428',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(192,728,4,'20160427','20160428','20160429',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(193,1366,4,'20160428','20160430','20160430',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(194,558,4,'20160428','20160430','20160501',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(195,727,4,'20160428','20160501','20160501',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(196,1247,4,'20160428','20160430','20160501',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(197,127,4,'20160430','20160503','20160503',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(198,640,4,'20160501','20160504','20160503',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(199,760,4,'20160501','20160504','20160504',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(200,1074,4,'20160501','20160503','20160503',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(201,280,4,'20160501','20160504','20160502',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(202,600,4,'20160503','20160505','20160504',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(203,1102,4,'20160503','20160505','20160506',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(204,591,4,'20160504','20160507','20160506',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(205,635,4,'20160504','20160505','20160506',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(206,743,4,'20160504','20160506','20160505',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(207,105,4,'20160505','20160507','20160507',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(208,815,4,'20160506','20160507','20160509',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(209,514,4,'20160507','20160508','20160508',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(210,943,4,'20160507','20160508','20160509',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(211,1140,4,'20160507','20160509','20160508',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(212,1373,4,'20160508','20160509','20160511',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(213,788,4,'20160508','20160509','20160509',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(214,363,4,'20160510','20160512','20160511',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(215,1420,4,'20160510','20160513','20160512',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(216,267,4,'20160511','20160514','20160513',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(217,716,4,'20160511','20160512','20160514',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(218,1179,4,'20160512','20160514','20160514',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(219,1338,4,'20160512','20160515','20160515',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(220,1358,4,'20160512','20160514','20160515',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(221,1218,4,'20160513','20160516','20160514',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(222,51,4,'20160513','20160516','20160514',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(223,1368,4,'20160515','20160516','20160517',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(224,157,4,'20160517','20160518','20160519',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(225,307,4,'20160517','20160520','20160519',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(226,501,4,'20160517','20160519','20160520',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(227,489,4,'20160517','20160518','20160520',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(228,615,4,'20160517','20160520','20160520',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(229,742,4,'20160519','20160521','20160520',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(230,1167,4,'20160519','20160520','20160521',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(231,1257,4,'20160519','20160522','20160521',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(232,1360,4,'20160520','20160523','20160523',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(233,737,4,'20160521','20160522','20160524',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(234,1435,4,'20160522','20160524','20160524',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(235,649,4,'20160524','20160525','20160525',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(236,206,4,'20160525','20160527','20160526',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(237,1351,4,'20160525','20160526','20160527',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(238,1350,4,'20160526','20160529','20160529',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(239,13,3,'20160527','20160527',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(240,65,4,'20160527','20160529','20160530',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(241,1082,4,'20160527','20160529','20160529',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(242,1168,4,'20160527','20160530','20160530',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(243,802,4,'20160527','20160530','20160528',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(244,956,4,'20160528','20160529','20160529',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(245,223,4,'20160529','20160531','20160530',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(246,17,3,'20160530','20160530',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(247,928,4,'20160530','20160601','20160601',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(248,1376,4,'20160530','20160601','20160531',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(249,145,4,'20160601','20160604','20160604',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(250,150,4,'20160601','20160602','20160604',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(251,851,4,'20160601','20160604','20160604',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(252,66,4,'20160601','20160604','20160602',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(253,1267,4,'20160602','20160605','20160605',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(254,510,4,'20160603','20160606','20160605',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(255,801,4,'20160603','20160606','20160605',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(256,26,4,'20160604','20160605','20160607',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(257,1314,4,'20160605','20160606','20160608',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(258,107,4,'20160606','20160607','20160607',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(259,413,4,'20160606','20160609','20160609',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(260,632,4,'20160606','20160608','20160608',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(261,1045,4,'20160608','20160610','20160609',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(262,579,4,'20160608','20160611','20160610',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(263,1322,4,'20160609','20160610','20160612',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(264,5,3,'20160610','20160610',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(265,682,4,'20160610','20160612','20160611',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(266,933,4,'20160610','20160613','20160613',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(267,282,4,'20160611','20160614','20160614',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(268,540,4,'20160611','20160614','20160612',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(269,764,4,'20160612','20160613','20160615',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(270,879,4,'20160612','20160615','20160613',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(271,350,4,'20160613','20160616','20160614',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(272,497,4,'20160615','20160618','20160616',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(273,1340,4,'20160616','20160619','20160617',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(274,411,4,'20160617','20160620','20160618',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(275,1341,4,'20160617','20160619','20160618',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(276,1227,4,'20160618','20160619','20160619',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(277,546,4,'20160619','20160620','20160620',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(278,1301,4,'20160620','20160623','20160621',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(279,378,4,'20160621','20160622','20160622',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(280,638,4,'20160621','20160622','20160623',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(281,800,4,'20160621','20160622','20160623',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(282,159,4,'20160622','20160625','20160625',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(283,181,4,'20160623','20160626','20160626',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(284,1356,4,'20160623','20160625','20160625',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(285,319,4,'20160625','20160626','20160627',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(286,59,4,'20160625','20160626','20160626',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(287,133,4,'20160625','20160626','20160627',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(288,780,4,'20160625','20160628','20160628',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(289,849,4,'20160627','20160628','20160630',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(290,202,4,'20160628','20160629','20160630',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(291,158,4,'20160629','20160630','20160701',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(292,360,4,'20160629','20160630','20160702',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(293,573,4,'20160630','20160703','20160702',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(294,732,4,'20160701','20160702','20160702',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(295,1130,4,'20160701','20160704','20160704',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(296,1245,4,'20160704','20160707','20160706',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(297,1425,4,'20160704','20160705','20160706',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(298,885,4,'20160704','20160707','20160707',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(299,281,4,'20160705','20160706','20160707',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(300,1205,4,'20160705','20160708','20160708',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(301,17,4,'20160706','20160709','20160708',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(302,1375,4,'20160706','20160707','20160709',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(303,36,4,'20160707','20160708','20160709',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(304,230,4,'20160707','20160708','20160708',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(305,705,4,'20160707','20160708','20160708',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(306,424,4,'20160709','20160710','20160712',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(307,695,4,'20160709','20160711','20160711',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(308,156,4,'20160711','20160712','20160714',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(309,211,4,'20160711','20160713','20160713',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(310,627,4,'20160712','20160713','20160713',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(311,1400,4,'20160712','20160714','20160713',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(312,299,4,'20160713','20160715','20160716',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(313,565,4,'20160714','20160715','20160715',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(314,1019,4,'20160715','20160717','20160717',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(315,1263,4,'20160716','20160719','20160717',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(316,670,4,'20160717','20160720','20160719',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(317,795,4,'20160717','20160720','20160719',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(318,1141,4,'20160717','20160719','20160720',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(319,941,4,'20160718','20160721','20160721',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(320,1428,4,'20160719','20160720','20160721',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(321,568,4,'20160719','20160722','20160721',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(322,924,4,'20160719','20160722','20160720',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(323,1243,4,'20160719','20160722','20160721',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(324,480,4,'20160720','20160722','20160723',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(325,848,4,'20160720','20160721','20160721',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(326,1337,4,'20160720','20160721','20160722',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(327,83,4,'20160721','20160724','20160722',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(328,528,4,'20160723','20160726','20160725',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(329,274,4,'20160724','20160727','20160726',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(330,622,4,'20160724','20160727','20160727',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(331,642,4,'20160724','20160726','20160725',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(332,659,4,'20160724','20160726','20160726',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(333,779,4,'20160725','20160727','20160726',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(334,1112,4,'20160725','20160728','20160727',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(335,1193,4,'20160725','20160727','20160726',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(336,1030,4,'20160726','20160729','20160727',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(337,1252,4,'20160726','20160727','20160728',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(338,1333,4,'20160728','20160729','20160730',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(339,1110,4,'20160728','20160731','20160729',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(340,963,4,'20160729','20160730','20160731',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(341,1357,4,'20160731','20160803','20160801',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(342,806,4,'20160731','20160801','20160803',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(343,961,4,'20160731','20160802','20160801',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(344,750,4,'20160801','20160803','20160802',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(345,1299,4,'20160801','20160804','20160803',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(346,584,4,'20160801','20160803','20160802',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(347,1004,4,'20160802','20160803','20160805',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(348,907,4,'20160802','20160805','20160804',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(349,30,3,'20160803','20160803',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(350,31,3,'20160803','20160803',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(351,1307,4,'20160803','20160806','20160804',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(352,16,4,'20160803','20160804','20160806',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(353,1387,4,'20160803','20160806','20160806',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(354,551,4,'20160803','20160805','20160806',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(355,1011,4,'20160803','20160805','20160805',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(356,1189,4,'20160804','20160807','20160806',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(357,14,3,'20160805','20160805',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(358,1042,4,'20160805','20160807','20160807',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(359,441,4,'20160807','20160810','20160810',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(360,1300,4,'20160807','20160809','20160810',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(361,994,4,'20160808','20160809','20160811',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(362,187,4,'20160809','20160811','20160811',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(363,834,4,'20160811','20160812','20160813',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(364,373,4,'20160812','20160814','20160813',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(365,981,4,'20160813','20160814','20160815',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(366,1054,4,'20160813','20160814','20160814',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(367,527,4,'20160814','20160815','20160815',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(368,995,4,'20160814','20160815','20160817',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(369,1285,4,'20160815','20160818','20160818',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(370,758,4,'20160815','20160818','20160818',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(371,891,4,'20160815','20160816','20160818',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(372,132,4,'20160816','20160818','20160818',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(373,337,4,'20160816','20160819','20160817',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(374,1313,4,'20160817','20160819','20160818',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(375,536,4,'20160817','20160820','20160820',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(376,825,4,'20160817','20160819','20160818',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(377,1355,4,'20160817','20160819','20160820',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(378,475,4,'20160817','20160820','20160820',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(379,954,4,'20160818','20160821','20160821',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(380,1156,4,'20160819','20160820','20160821',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(381,1297,4,'20160819','20160821','20160821',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(382,199,4,'20160820','20160823','20160823',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(383,331,4,'20160820','20160823','20160822',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(384,410,4,'20160820','20160822','20160823',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(385,1274,4,'20160820','20160823','20160822',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(386,1362,4,'20160820','20160823','20160823',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(387,451,4,'20160820','20160821','20160821',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(388,1080,4,'20160821','20160824','20160823',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(389,53,4,'20160822','20160824','20160825',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(390,576,4,'20160822','20160824','20160825',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(391,61,3,'20160823','20160823',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(392,176,4,'20160823','20160826','20160824',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(393,368,4,'20160825','20160826','20160827',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(394,522,4,'20160826','20160828','20160829',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(395,144,4,'20160826','20160827','20160829',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(396,542,4,'20160827','20160830','20160829',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(397,1437,4,'20160828','20160831','20160829',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(398,447,4,'20160829','20160830','20160901',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(399,1001,4,'20160829','20160901','20160901',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(400,1295,4,'20160829','20160830','20160831',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(401,103,4,'20160830','20160902','20160901',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(402,1335,4,'20160830','20160901','20160831',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(403,578,4,'20160831','20160901','20160902',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(404,396,4,'20160831','20160903','20160901',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(405,603,4,'20160831','20160901','20160901',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(406,1380,4,'20160831','20160902','20160901',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(407,77,3,'20160901','20160901',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(408,1071,4,'20160901','20160902','20160902',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(409,416,4,'20160901','20160904','20160904',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(410,1151,4,'20160901','20160903','20160902',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(411,261,4,'20160902','20160904','20160904',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(412,1202,4,'20160902','20160904','20160904',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(413,717,4,'20160902','20160905','20160903',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(414,917,4,'20160903','20160906','20160906',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(415,1265,4,'20160903','20160906','20160906',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(416,1377,4,'20160903','20160904','20160906',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(417,359,4,'20160904','20160905','20160906',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(418,88,4,'20160904','20160905','20160905',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(419,14,4,'20160904','20160907','20160906',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(420,72,4,'20160905','20160906','20160907',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(421,240,4,'20160905','20160906','20160908',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(422,398,4,'20160906','20160907','20160909',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(423,1397,4,'20160906','20160909','20160909',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(424,67,4,'20160908','20160911','20160911',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(425,843,4,'20160908','20160911','20160911',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(426,944,4,'20160908','20160910','20160910',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(427,434,4,'20160909','20160910','20160911',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(428,1039,4,'20160909','20160912','20160910',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(429,153,4,'20160910','20160912','20160912',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(430,272,4,'20160911','20160913','20160912',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(431,1217,4,'20160911','20160912','20160912',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(432,169,4,'20160912','20160915','20160914',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(433,1062,4,'20160912','20160915','20160913',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(434,726,4,'20160913','20160915','20160914',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(435,77,4,'20160914','20160915','20160916',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(436,791,4,'20160916','20160919','20160919',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(437,1085,4,'20160916','20160918','20160918',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(438,314,4,'20160916','20160919','20160918',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(439,149,4,'20160917','20160920','20160918',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(440,882,4,'20160917','20160918','20160919',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(441,704,4,'20160918','20160919','20160919',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(442,667,4,'20160918','20160921','20160921',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(443,1371,4,'20160918','20160919','20160920',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(444,30,4,'20160919','20160920','20160921',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(445,362,4,'20160919','20160922','20160922',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(446,399,4,'20160919','20160921','20160920',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(447,808,4,'20160920','20160923','20160922',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(448,101,4,'20160921','20160922','20160924',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(449,492,4,'20160921','20160924','20160922',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(450,575,4,'20160921','20160924','20160923',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(451,1146,4,'20160921','20160923','20160922',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(452,997,4,'20160922','20160923','20160924',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(453,1028,4,'20160922','20160924','20160925',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(454,988,4,'20160923','20160925','20160926',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(455,1055,4,'20160923','20160924','20160924',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(456,1061,4,'20160923','20160926','20160925',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(457,1349,4,'20160924','20160927','20160927',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(458,197,4,'20160925','20160928','20160926',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(459,874,4,'20160925','20160928','20160926',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(460,691,4,'20160925','20160927','20160926',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(461,853,4,'20160926','20160927','20160927',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(462,852,4,'20160927','20160928','20160929',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(463,964,4,'20160927','20160928','20160928',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(464,74,4,'20160928','20160930','20160929',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(465,1198,4,'20160928','20161001','20161001',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(466,1440,4,'20160928','20160929','20161001',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(467,555,4,'20160928','20160930','20160930',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(468,1261,4,'20160929','20161002','20160930',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(469,1089,4,'20160929','20161002','20161002',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(470,641,4,'20160930','20161002','20161002',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(471,697,4,'20160930','20161002','20161001',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(472,468,4,'20160930','20161001','20161001',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(473,549,4,'20160930','20161002','20161003',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(474,553,4,'20161001','20161004','20161004',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(475,241,4,'20161001','20161004','20161003',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(476,559,4,'20161001','20161004','20161002',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(477,449,4,'20161002','20161005','20161004',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(478,304,4,'20161002','20161005','20161003',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(479,984,4,'20161003','20161004','20161004',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(480,686,4,'20161004','20161007','20161005',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(481,481,4,'20161004','20161007','20161006',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(482,513,4,'20161005','20161006','20161006',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(483,703,4,'20161006','20161007','20161009',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(484,421,4,'20161006','20161009','20161007',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(485,465,4,'20161006','20161008','20161007',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(486,709,4,'20161006','20161008','20161009',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(487,827,4,'20161006','20161009','20161009',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(488,921,4,'20161006','20161009','20161008',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(489,899,4,'20161006','20161008','20161008',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(490,876,4,'20161007','20161010','20161009',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(491,1048,4,'20161008','20161010','20161011',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(492,191,4,'20161009','20161010','20161012',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(493,796,4,'20161009','20161012','20161011',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(494,875,4,'20161009','20161010','20161011',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(495,712,4,'20161010','20161012','20161013',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(496,193,4,'20161010','20161012','20161011',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(497,785,4,'20161010','20161011','20161011',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(498,1331,4,'20161010','20161012','20161011',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(499,260,4,'20161011','20161014','20161013',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(500,148,4,'20161011','20161012','20161013',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(501,977,4,'20161011','20161012','20161013',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(502,401,4,'20161012','20161013','20161013',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(503,932,4,'20161013','20161016','20161014',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(504,1381,4,'20161014','20161015','20161015',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(505,721,4,'20161014','20161016','20161017',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(506,831,4,'20161014','20161016','20161016',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(507,1378,4,'20161015','20161017','20161017',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(508,1359,4,'20161015','20161018','20161018',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(509,235,4,'20161016','20161017','20161017',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(510,586,4,'20161017','20161018','20161018',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(511,377,4,'20161018','20161020','20161019',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(512,8,4,'20161019','20161022','20161020',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(513,155,4,'20161019','20161021','20161021',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(514,927,4,'20161019','20161021','20161020',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(515,986,4,'20161019','20161020','20161022',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(516,111,4,'20161021','20161023','20161024',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(517,613,4,'20161021','20161022','20161024',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(518,1374,4,'20161022','20161024','20161025',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(519,54,4,'20161022','20161023','20161024',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(520,639,4,'20161023','20161026','20161024',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(521,664,4,'20161023','20161025','20161025',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(522,724,4,'20161023','20161024','20161024',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(523,1056,4,'20161024','20161026','20161027',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(524,569,4,'20161025','20161026','20161027',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(525,1315,4,'20161026','20161028','20161029',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(526,1096,4,'20161026','20161028','20161028',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(527,506,4,'20161027','20161029','20161028',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(528,676,4,'20161028','20161031','20161031',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(529,753,4,'20161028','20161030','20161031',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(530,773,4,'20161028','20161031','20161031',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(531,116,4,'20161028','20161029','20161030',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(532,817,4,'20161029','20161031','20161030',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(533,1334,4,'20161029','20161101','20161101',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(534,1406,4,'20161029','20161030','20161031',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(535,835,4,'20161029','20161031','20161101',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(536,759,4,'20161031','20161102','20161101',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(537,1353,4,'20161031','20161101','20161103',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(538,341,4,'20161102','20161105','20161105',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(539,1144,4,'20161102','20161104','20161103',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(540,1429,4,'20161103','20161105','20161106',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(541,1228,4,'20161104','20161107','20161107',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(542,313,4,'20161104','20161106','20161105',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(543,62,4,'20161106','20161109','20161108',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(544,321,4,'20161106','20161107','20161108',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(545,1108,4,'20161108','20161110','20161109',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(546,470,4,'20161109','20161112','20161110',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(547,20,4,'20161109','20161111','20161110',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(548,739,4,'20161111','20161113','20161113',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(549,64,3,'20161112','20161112',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(550,892,4,'20161112','20161114','20161115',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(551,1169,4,'20161112','20161113','20161113',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(552,1282,4,'20161112','20161115','20161113',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(553,913,4,'20161112','20161113','20161115',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(554,104,4,'20161113','20161114','20161116',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(555,212,4,'20161113','20161114','20161116',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(556,61,4,'20161113','20161114','20161115',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(557,1248,4,'20161114','20161117','20161115',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(558,1443,4,'20161115','20161116','20161117',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(559,959,4,'20161116','20161117','20161117',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(560,1405,4,'20161118','20161119','20161121',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(561,90,4,'20161119','20161122','20161122',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(562,942,4,'20161119','20161120','20161122',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(563,365,4,'20161120','20161122','20161121',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(564,1058,4,'20161120','20161123','20161122',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(565,894,4,'20161121','20161122','20161122',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(566,298,4,'20161122','20161125','20161123',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(567,1430,4,'20161122','20161123','20161123',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(568,1275,4,'20161123','20161125','20161124',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(569,707,4,'20161123','20161124','20161125',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(570,989,4,'20161123','20161124','20161125',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(571,5,4,'20161124','20161125','20161127',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(572,178,4,'20161124','20161126','20161126',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(573,423,4,'20161124','20161126','20161127',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(574,833,4,'20161126','20161127','20161129',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(575,33,4,'20161127','20161128','20161130',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(576,1272,4,'20161127','20161130','20161128',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(577,445,4,'20161127','20161130','20161129',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(578,819,4,'20161127','20161128','20161129',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(579,160,4,'20161127','20161130','20161129',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(580,581,4,'20161130','20161202','20161202',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(581,688,4,'20161203','20161205','20161206',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(582,32,3,'20161204','20161204',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(583,792,4,'20161204','20161205','20161207',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(584,1209,4,'20161204','20161205','20161205',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(585,1219,4,'20161204','20161205','20161205',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(586,1306,4,'20161204','20161206','20161205',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(587,487,4,'20161206','20161208','20161208',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(588,102,4,'20161206','20161207','20161207',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(589,719,4,'20161206','20161207','20161207',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(590,990,4,'20161206','20161209','20161207',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(591,1211,4,'20161206','20161209','20161209',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(592,1232,4,'20161206','20161208','20161208',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(593,50,4,'20161207','20161210','20161208',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(594,1318,4,'20161207','20161208','20161208',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(595,538,4,'20161208','20161209','20161211',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(596,952,4,'20161208','20161209','20161209',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(597,1121,4,'20161208','20161209','20161210',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(598,40,3,'20161209','20161209',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(599,1,4,'20161209','20161210','20161212',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(600,624,4,'20161209','20161212','20161211',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(601,683,4,'20161209','20161210','20161210',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(602,823,4,'20161209','20161210','20161211',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(603,1032,4,'20161209','20161210','20161210',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(604,96,4,'20161210','20161213','20161212',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(605,1208,4,'20161210','20161211','20161212',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(606,18,4,'20161211','20161212','20161213',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(607,309,4,'20161211','20161214','20161213',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(608,1103,4,'20161212','20161215','20161214',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(609,896,4,'20161212','20161213','20161214',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(610,711,4,'20161213','20161215','20161214',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(611,1073,4,'20161215','20161217','20161218',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(612,634,4,'20161216','20161217','20161217',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(613,1159,4,'20161217','20161219','20161219',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(614,654,4,'20161218','20161221','20161221',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(615,560,4,'20161219','20161222','20161221',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(616,1444,4,'20161220','20161223','20161223',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(617,118,4,'20161221','20161223','20161223',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(618,131,4,'20161221','20161222','20161222',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(619,454,4,'20161222','20161225','20161225',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(620,466,4,'20161222','20161224','20161224',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(621,1157,4,'20161223','20161225','20161224',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(622,1398,4,'20161223','20161226','20161225',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(623,678,4,'20161224','20161226','20161227',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(624,814,4,'20161224','20161225','20161227',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(625,1163,4,'20161225','20161228','20161226',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(626,130,4,'20161225','20161228','20161227',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(627,1119,4,'20161225','20161226','20161228',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(628,561,4,'20161226','20161229','20161227',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(629,973,4,'20161226','20161227','20161229',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(630,1404,4,'20161226','20161227','20161228',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(631,855,4,'20161227','20161229','20161229',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(632,163,4,'20161227','20161229','20161229',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(633,1040,4,'20161228','20161231','20161230',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(634,27,4,'20161229','20170101','20161230',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(635,520,4,'20161230','20170102','20161231',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(636,532,4,'20170103','20170104','20170105',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(637,512,4,'20170103','20170105','20170105',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(638,1302,4,'20170104','20170105','20170106',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(639,550,4,'20170106','20170107','20170107',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(640,1093,4,'20170106','20170108','20170107',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(641,673,4,'20170107','20170110','20170108',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(642,847,4,'20170107','20170109','20170110',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(643,901,4,'20170108','20170109','20170111',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(644,439,4,'20170108','20170111','20170110',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(645,1199,4,'20170108','20170111','20170110',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(646,975,4,'20170109','20170112','20170111',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(647,283,4,'20170109','20170110','20170111',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(648,684,4,'20170109','20170111','20170111',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(649,1153,4,'20170110','20170111','20170113',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(650,729,4,'20170111','20170114','20170112',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(651,190,4,'20170111','20170113','20170113',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(652,985,4,'20170112','20170115','20170113',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(653,1249,4,'20170114','20170117','20170115',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(654,1129,4,'20170114','20170115','20170117',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(655,347,4,'20170116','20170117','20170118',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(656,949,4,'20170116','20170117','20170118',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(657,349,4,'20170117','20170119','20170120',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(658,1051,4,'20170117','20170118','20170118',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(659,1391,4,'20170117','20170119','20170118',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(660,383,4,'20170118','20170119','20170119',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(661,626,4,'20170118','20170119','20170120',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(662,1125,4,'20170119','20170120','20170120',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(663,344,4,'20170120','20170122','20170123',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(664,681,4,'20170120','20170123','20170122',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(665,29,4,'20170121','20170122','20170123',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(666,770,4,'20170121','20170122','20170124',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(667,858,4,'20170122','20170124','20170125',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(668,297,4,'20170122','20170123','20170124',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(669,745,4,'20170123','20170124','20170126',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(670,361,4,'20170124','20170125','20170125',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(671,922,4,'20170125','20170128','20170126',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(672,908,4,'20170126','20170129','20170129',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(673,64,4,'20170126','20170128','20170127',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(674,733,4,'20170127','20170128','20170129',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(675,291,4,'20170128','20170131','20170130',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(676,790,4,'20170128','20170130','20170131',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(677,809,4,'20170128','20170131','20170130',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(678,250,4,'20170128','20170129','20170131',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(679,81,4,'20170129','20170130','20170130',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(680,245,4,'20170129','20170201','20170130',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(681,499,4,'20170129','20170201','20170131',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(682,614,4,'20170129','20170130','20170130',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(683,741,4,'20170129','20170131','20170201',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(684,762,4,'20170131','20170201','20170202',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(685,976,4,'20170131','20170203','20170202',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(686,380,4,'20170201','20170203','20170204',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(687,530,4,'20170202','20170205','20170204',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(688,343,4,'20170202','20170203','20170205',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(689,884,4,'20170202','20170203','20170205',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(690,1097,4,'20170203','20170204','20170206',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(691,1081,4,'20170204','20170206','20170206',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(692,2,3,'20170205','20170205',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(693,1233,4,'20170205','20170207','20170206',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(694,58,4,'20170205','20170206','20170208',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(695,606,4,'20170205','20170208','20170207',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(696,1242,4,'20170205','20170208','20170208',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(697,562,4,'20170206','20170208','20170209',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(698,543,4,'20170206','20170208','20170209',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(699,958,4,'20170206','20170208','20170209',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(700,4,4,'20170207','20170210','20170208',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(701,850,4,'20170207','20170208','20170209',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(702,1352,4,'20170208','20170209','20170211',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(703,417,4,'20170208','20170209','20170209',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(704,1137,4,'20170208','20170209','20170211',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(705,1196,4,'20170208','20170211','20170211',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(706,1271,4,'20170209','20170212','20170210',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(707,79,4,'20170209','20170211','20170211',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(708,660,4,'20170210','20170212','20170211',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(709,1162,4,'20170211','20170213','20170212',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(710,295,4,'20170213','20170215','20170216',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(711,1246,4,'20170213','20170216','20170214',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(712,173,4,'20170213','20170214','20170216',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(713,207,4,'20170213','20170214','20170215',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(714,805,4,'20170214','20170217','20170215',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(715,12,3,'20170215','20170215',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(716,672,4,'20170215','20170217','20170218',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(717,1312,4,'20170215','20170218','20170217',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(718,38,4,'20170216','20170217','20170217',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(719,200,4,'20170216','20170219','20170218',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(720,382,4,'20170216','20170219','20170219',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(721,625,4,'20170216','20170219','20170217',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(722,1399,4,'20170218','20170220','20170221',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(723,845,4,'20170219','20170221','20170222',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(724,864,4,'20170219','20170222','20170221',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(725,870,4,'20170219','20170222','20170222',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(726,969,4,'20170219','20170222','20170220',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(727,962,4,'20170219','20170222','20170221',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(728,1138,4,'20170220','20170221','20170223',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(729,897,4,'20170220','20170222','20170221',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(730,500,4,'20170221','20170224','20170222',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(731,910,4,'20170225','20170227','20170227',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(732,147,4,'20170226','20170227','20170301',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(733,832,4,'20170226','20170301','20170227',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(734,939,4,'20170226','20170228','20170301',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(735,20,3,'20170227','20170227',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(736,184,4,'20170227','20170228','20170228',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(737,694,4,'20170227','20170301','20170228',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(738,124,4,'20170228','20170301','20170303',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(739,49,4,'20170228','20170301','20170302',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(740,1113,4,'20170228','20170301','20170302',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(741,119,4,'20170228','20170301','20170301',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(742,433,4,'20170228','20170301','20170301',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(743,137,4,'20170301','20170304','20170304',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(744,166,4,'20170301','20170302','20170302',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(745,698,4,'20170301','20170303','20170303',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(746,391,4,'20170302','20170304','20170305',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(747,87,4,'20170303','20170304','20170305',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(748,1072,4,'20170303','20170305','20170304',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(749,255,4,'20170304','20170307','20170305',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(750,232,4,'20170304','20170307','20170305',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(751,731,4,'20170305','20170308','20170307',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(752,335,4,'20170305','20170306','20170307',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(753,1201,4,'20170305','20170308','20170308',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(754,646,4,'20170306','20170307','20170308',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(755,531,4,'20170306','20170307','20170307',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(756,1143,4,'20170306','20170307','20170309',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(757,1336,4,'20170306','20170308','20170309',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(758,953,4,'20170306','20170308','20170307',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(759,284,4,'20170307','20170309','20170308',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(760,1104,4,'20170307','20170310','20170310',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(761,1291,4,'20170307','20170308','20170310',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(762,572,4,'20170308','20170309','20170309',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(763,842,4,'20170308','20170310','20170309',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(764,701,4,'20170309','20170310','20170312',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(765,1152,4,'20170309','20170311','20170312',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(766,141,4,'20170309','20170311','20170312',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(767,564,4,'20170309','20170310','20170311',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(768,841,4,'20170309','20170312','20170310',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(769,946,4,'20170309','20170311','20170311',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(770,135,4,'20170309','20170311','20170311',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(771,671,4,'20170311','20170314','20170312',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(772,448,4,'20170311','20170312','20170313',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(773,1385,4,'20170311','20170312','20170312',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(774,690,4,'20170312','20170314','20170314',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(775,968,4,'20170312','20170313','20170313',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(776,490,4,'20170313','20170315','20170316',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(777,496,4,'20170313','20170316','20170316',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(778,56,3,'20170315','20170315',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(779,367,4,'20170315','20170316','20170318',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(780,592,4,'20170315','20170317','20170317',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(781,1018,4,'20170315','20170316','20170317',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(782,1298,4,'20170315','20170316','20170318',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(783,1343,4,'20170316','20170319','20170317',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(784,430,4,'20170316','20170319','20170319',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(785,794,4,'20170318','20170319','20170320',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(786,249,4,'20170318','20170320','20170319',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(787,700,4,'20170318','20170320','20170319',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(788,1363,4,'20170318','20170320','20170320',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(789,772,4,'20170319','20170320','20170320',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(790,1015,4,'20170319','20170321','20170322',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(791,432,4,'20170320','20170322','20170323',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(792,479,4,'20170322','20170323','20170324',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(793,653,4,'20170323','20170324','20170324',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(794,863,4,'20170323','20170325','20170324',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(795,992,4,'20170323','20170325','20170326',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(796,154,4,'20170323','20170326','20170325',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(797,374,4,'20170324','20170326','20170326',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(798,619,4,'20170326','20170328','20170329',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(799,607,4,'20170327','20170328','20170329',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(800,1057,4,'20170327','20170329','20170328',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(801,78,4,'20170328','20170329','20170330',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(802,340,4,'20170328','20170329','20170330',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(803,1105,4,'20170328','20170331','20170330',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(804,95,4,'20170329','20170331','20170330',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(805,420,4,'20170329','20170330','20170401',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(806,234,4,'20170330','20170331','20170331',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(807,1148,4,'20170330','20170401','20170402',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(808,315,4,'20170331','20170402','20170402',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(809,1222,4,'20170331','20170403','20170403',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(810,153,3,'20170401','20170401',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(811,524,4,'20170401','20170404','20170404',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(812,1164,4,'20170401','20170402','20170403',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(813,1203,4,'20170401','20170403','20170402',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(814,629,4,'20170402','20170405','20170403',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(815,1251,4,'20170403','20170405','20170404',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(816,811,4,'20170403','20170405','20170405',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(817,301,4,'20170404','20170405','20170407',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(818,1319,4,'20170404','20170407','20170407',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(819,221,4,'20170404','20170407','20170405',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(820,725,4,'20170405','20170408','20170407',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(821,1181,4,'20170405','20170407','20170408',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(822,294,4,'20170406','20170408','20170409',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(823,415,4,'20170406','20170407','20170408',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(824,993,4,'20170407','20170409','20170410',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(825,10,4,'20170407','20170408','20170409',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(826,45,4,'20170407','20170410','20170410',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(827,666,4,'20170407','20170410','20170410',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(828,246,4,'20170409','20170410','20170412',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(829,674,4,'20170409','20170410','20170410',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(830,431,4,'20170411','20170414','20170412',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(831,1000,4,'20170411','20170412','20170412',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(832,1215,4,'20170411','20170412','20170412',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(833,406,4,'20170412','20170414','20170415',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(834,890,4,'20170412','20170413','20170415',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(835,940,4,'20170413','20170415','20170414',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(836,455,4,'20170413','20170416','20170414',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(837,948,4,'20170413','20170416','20170414',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(838,1395,4,'20170414','20170417','20170415',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(839,1332,4,'20170415','20170418','20170416',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(840,372,4,'20170415','20170416','20170416',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(841,428,4,'20170415','20170418','20170417',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(842,1133,4,'20170415','20170418','20170416',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(843,1059,4,'20170416','20170417','20170419',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(844,1436,4,'20170416','20170417','20170418',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(845,662,4,'20170417','20170418','20170418',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(846,715,4,'20170417','20170419','20170419',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(847,329,4,'20170418','20170419','20170419',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(848,597,4,'20170418','20170420','20170420',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(849,776,4,'20170419','20170420','20170421',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(850,1346,4,'20170419','20170422','20170422',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(851,1139,4,'20170420','20170421','20170422',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(852,13,4,'20170421','20170423','20170422',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(853,883,4,'20170421','20170424','20170424',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(854,177,4,'20170422','20170425','20170423',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(855,775,4,'20170422','20170423','20170425',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(856,477,4,'20170423','20170425','20170426',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(857,1402,4,'20170424','20170425','20170426',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(858,162,4,'20170425','20170427','20170428',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(859,644,4,'20170425','20170426','20170426',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(860,473,4,'20170427','20170429','20170428',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(861,1177,4,'20170427','20170429','20170430',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(862,1230,4,'20170427','20170430','20170429',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(863,446,4,'20170428','20170430','20170501',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(864,902,4,'20170428','20170430','20170429',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(865,974,4,'20170429','20170502','20170501',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(866,1410,4,'20170429','20170430','20170501',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(867,97,4,'20170501','20170503','20170502',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(868,868,4,'20170501','20170504','20170502',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(869,844,4,'20170501','20170504','20170502',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(870,1416,4,'20170501','20170504','20170502',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(871,358,4,'20170502','20170504','20170503',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(872,394,4,'20170503','20170506','20170506',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(873,829,4,'20170503','20170505','20170505',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(874,661,4,'20170504','20170505','20170506',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(875,386,4,'20170505','20170506','20170508',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(876,1046,4,'20170505','20170508','20170506',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(877,784,4,'20170506','20170507','20170508',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(878,224,4,'20170507','20170510','20170509',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(879,214,4,'20170508','20170509','20170509',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(880,1206,4,'20170508','20170511','20170510',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(881,1024,4,'20170508','20170511','20170511',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(882,196,4,'20170509','20170512','20170510',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(883,507,4,'20170511','20170513','20170514',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(884,871,4,'20170511','20170513','20170512',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(885,66,3,'20170513','20170513',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(886,1396,4,'20170513','20170514','20170515',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(887,1195,4,'20170513','20170515','20170515',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(888,1038,4,'20170514','20170516','20170516',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(889,830,4,'20170514','20170517','20170515',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(890,171,4,'20170515','20170518','20170518',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(891,384,4,'20170515','20170518','20170516',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(892,651,4,'20170515','20170518','20170517',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(893,1293,4,'20170516','20170519','20170519',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(894,1320,4,'20170516','20170519','20170519',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(895,857,4,'20170518','20170521','20170519',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(896,376,4,'20170519','20170522','20170521',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(897,47,4,'20170520','20170521','20170521',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(898,352,4,'20170520','20170521','20170522',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(899,605,4,'20170520','20170521','20170521',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(900,971,4,'20170520','20170521','20170522',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(901,345,4,'20170521','20170522','20170524',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(902,1278,4,'20170521','20170524','20170522',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(903,179,4,'20170522','20170523','20170524',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(904,1020,4,'20170523','20170526','20170524',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(905,609,4,'20170523','20170526','20170524',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(906,877,4,'20170523','20170526','20170526',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(907,120,4,'20170524','20170526','20170527',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(908,402,4,'20170525','20170528','20170527',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(909,188,4,'20170526','20170527','20170528',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(910,342,4,'20170526','20170528','20170528',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(911,887,4,'20170526','20170529','20170529',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(912,519,4,'20170527','20170529','20170529',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(913,699,4,'20170527','20170529','20170529',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(914,1068,4,'20170528','20170531','20170531',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(915,215,4,'20170528','20170530','20170530',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(916,718,4,'20170528','20170529','20170529',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(917,881,4,'20170529','20170531','20170601',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(918,242,4,'20170530','20170531','20170531',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(919,781,4,'20170530','20170531','20170531',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(920,966,4,'20170530','20170601','20170602',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(921,628,4,'20170531','20170602','20170602',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(922,656,4,'20170531','20170601','20170603',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(923,769,4,'20170531','20170603','20170602',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(924,68,3,'20170602','20170602',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(925,1316,4,'20170602','20170605','20170603',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(926,233,4,'20170603','20170605','20170606',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(927,1438,4,'20170603','20170605','20170606',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(928,957,4,'20170605','20170606','20170606',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(929,472,4,'20170605','20170606','20170608',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(930,1224,4,'20170605','20170606','20170606',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(931,631,4,'20170607','20170608','20170608',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(932,804,4,'20170607','20170608','20170609',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(933,909,4,'20170607','20170610','20170608',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(934,93,4,'20170609','20170610','20170612',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(935,43,3,'20170610','20170610',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(936,265,4,'20170610','20170613','20170612',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(937,73,4,'20170611','20170614','20170613',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(938,129,4,'20170611','20170612','20170612',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(939,1407,4,'20170611','20170612','20170614',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(940,585,4,'20170612','20170614','20170613',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(941,736,4,'20170612','20170614','20170614',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(942,537,4,'20170613','20170616','20170615',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(943,1025,4,'20170613','20170615','20170615',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(944,138,4,'20170614','20170615','20170617',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(945,167,4,'20170614','20170615','20170616',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(946,525,4,'20170614','20170616','20170615',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(947,278,4,'20170615','20170618','20170617',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(948,618,4,'20170615','20170617','20170617',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(949,867,4,'20170616','20170618','20170617',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(950,142,4,'20170616','20170619','20170618',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(951,339,4,'20170616','20170619','20170619',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(952,355,4,'20170616','20170618','20170618',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(953,658,4,'20170616','20170618','20170617',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(954,611,4,'20170617','20170620','20170620',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(955,880,4,'20170617','20170619','20170618',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(956,1184,4,'20170617','20170619','20170620',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(957,722,4,'20170617','20170620','20170620',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(958,1276,4,'20170618','20170620','20170619',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(959,650,4,'20170618','20170621','20170621',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(960,1390,4,'20170618','20170619','20170619',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(961,82,4,'20170619','20170621','20170622',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(962,570,4,'20170619','20170622','20170620',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(963,1432,4,'20170619','20170621','20170621',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(964,404,4,'20170620','20170622','20170622',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(965,457,4,'20170620','20170622','20170623',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(966,389,4,'20170620','20170622','20170622',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(967,1323,4,'20170621','20170624','20170624',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(968,1403,4,'20170621','20170623','20170623',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(969,248,4,'20170621','20170624','20170622',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(970,836,4,'20170622','20170625','20170623',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(971,1426,4,'20170622','20170623','20170624',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(972,270,4,'20170623','20170624','20170625',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(973,238,4,'20170624','20170627','20170627',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(974,511,4,'20170624','20170627','20170627',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(975,1092,4,'20170625','20170627','20170628',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(976,1266,4,'20170625','20170628','20170627',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(977,400,4,'20170626','20170628','20170627',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(978,1123,4,'20170626','20170628','20170627',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(979,1190,4,'20170626','20170629','20170627',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(980,328,4,'20170626','20170628','20170627',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(981,687,4,'20170626','20170629','20170628',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(982,1423,4,'20170626','20170629','20170628',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(983,1158,4,'20170627','20170628','20170629',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(984,1287,4,'20170627','20170628','20170629',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(985,461,4,'20170630','20170702','20170701',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(986,556,4,'20170630','20170703','20170701',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(987,172,4,'20170702','20170704','20170704',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(988,436,4,'20170702','20170704','20170705',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(989,1145,4,'20170702','20170704','20170703',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(990,706,4,'20170704','20170707','20170707',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(991,751,4,'20170706','20170707','20170709',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(992,723,4,'20170707','20170710','20170709',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(993,1415,4,'20170709','20170711','20170711',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(994,419,4,'20170709','20170711','20170711',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(995,621,4,'20170711','20170713','20170714',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(996,915,4,'20170711','20170712','20170712',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(997,485,4,'20170711','20170713','20170714',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(998,219,4,'20170712','20170713','20170714',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(999,590,4,'20170712','20170713','20170714',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1000,645,4,'20170712','20170714','20170715',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1001,354,4,'20170713','20170716','20170715',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1002,1418,4,'20170714','20170716','20170716',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1003,503,4,'20170714','20170716','20170716',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1004,1389,4,'20170714','20170717','20170716',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1005,266,4,'20170715','20170717','20170716',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1006,1070,4,'20170715','20170718','20170717',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1007,1115,4,'20170716','20170717','20170717',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1008,1345,4,'20170716','20170718','20170718',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1009,1064,4,'20170716','20170719','20170719',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1010,8,3,'20170718','20170718',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1011,495,4,'20170718','20170721','20170721',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1012,620,4,'20170718','20170720','20170720',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1013,174,4,'20170719','20170722','20170721',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1014,748,4,'20170719','20170721','20170721',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1015,799,4,'20170719','20170722','20170721',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1016,1417,4,'20170719','20170720','20170721',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1017,168,4,'20170720','20170721','20170723',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1018,290,4,'20170722','20170723','20170723',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1019,408,4,'20170722','20170723','20170724',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1020,16,3,'20170723','20170723',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1021,125,4,'20170723','20170724','20170726',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1022,353,4,'20170723','20170726','20170724',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1023,356,4,'20170723','20170726','20170725',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1024,837,4,'20170723','20170725','20170726',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1025,1304,4,'20170723','20170726','20170726',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1026,1370,4,'20170726','20170728','20170729',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1027,588,4,'20170726','20170728','20170728',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1028,1273,4,'20170727','20170728','20170730',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1029,407,4,'20170729','20170730','20170801',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1030,161,4,'20170729','20170730','20170731',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1031,1308,4,'20170730','20170801','20170802',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1032,429,4,'20170730','20170802','20170801',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1033,582,4,'20170730','20170731','20170802',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1034,895,4,'20170730','20170731','20170731',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1035,1283,4,'20170730','20170802','20170802',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1036,1442,4,'20170730','20170801','20170731',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1037,1229,4,'20170731','20170802','20170803',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1038,1281,4,'20170731','20170801','20170803',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1039,1077,4,'20170802','20170804','20170803',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1040,1225,4,'20170804','20170807','20170805',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1041,70,4,'20170804','20170806','20170805',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1042,539,4,'20170806','20170807','20170807',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1043,1235,4,'20170806','20170809','20170808',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1044,1270,4,'20170807','20170810','20170808',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1045,185,4,'20170807','20170809','20170810',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1046,1134,4,'20170807','20170809','20170808',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1047,116,3,'20170808','20170808',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1048,777,4,'20170808','20170810','20170809',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1049,194,4,'20170809','20170811','20170810',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1050,239,4,'20170809','20170812','20170812',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1051,209,4,'20170810','20170811','20170811',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1052,460,4,'20170810','20170812','20170813',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1053,1439,4,'20170810','20170811','20170812',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1054,189,4,'20170811','20170812','20170812',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1055,140,4,'20170812','20170815','20170815',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1056,325,4,'20170812','20170815','20170813',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1057,456,4,'20170812','20170815','20170813',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1058,782,4,'20170813','20170816','20170814',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1059,6,4,'20170814','20170817','20170817',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1060,182,4,'20170815','20170818','20170817',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1061,655,4,'20170815','20170818','20170818',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1062,1210,4,'20170815','20170817','20170818',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1063,198,4,'20170816','20170819','20170819',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1064,898,4,'20170816','20170818','20170819',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1065,25,4,'20170817','20170819','20170819',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1066,106,4,'20170817','20170820','20170819',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1067,225,4,'20170817','20170819','20170819',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1068,453,4,'20170817','20170820','20170819',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1069,493,4,'20170817','20170819','20170818',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1070,596,4,'20170817','20170820','20170818',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1071,602,4,'20170817','20170820','20170818',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1072,47,3,'20170818','20170818',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1073,911,4,'20170818','20170819','20170821',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1074,11,3,'20170819','20170819',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1075,1003,4,'20170819','20170821','20170822',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1076,42,4,'20170819','20170822','20170822',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1077,412,4,'20170819','20170820','20170821',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1078,793,4,'20170819','20170821','20170820',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1079,812,4,'20170819','20170820','20170820',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1080,1086,4,'20170819','20170820','20170820',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1081,1106,4,'20170819','20170822','20170822',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1082,1327,4,'20170820','20170822','20170821',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1083,1372,4,'20170820','20170823','20170823',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1084,2,4,'20170821','20170824','20170823',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1085,305,4,'20170821','20170823','20170823',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1086,220,4,'20170821','20170823','20170824',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1087,675,4,'20170822','20170823','20170825',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1088,1160,4,'20170822','20170823','20170823',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1089,46,3,'20170823','20170823',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1090,1427,4,'20170824','20170826','20170826',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1091,1260,4,'20170824','20170825','20170825',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1092,40,4,'20170825','20170828','20170827',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1093,326,4,'20170825','20170828','20170826',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1094,828,4,'20170825','20170827','20170828',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1095,1382,4,'20170826','20170828','20170827',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1096,589,4,'20170827','20170829','20170829',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1097,1311,4,'20170827','20170830','20170828',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1098,752,4,'20170828','20170830','20170830',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1099,1128,4,'20170828','20170829','20170830',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1100,1392,4,'20170828','20170829','20170829',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1101,379,4,'20170829','20170830','20170830',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1102,1317,4,'20170829','20170831','20170831',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1103,1394,4,'20170831','20170902','20170902',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1104,268,4,'20170901','20170904','20170903',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1105,747,4,'20170901','20170904','20170903',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1106,1009,4,'20170902','20170904','20170904',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1107,1424,4,'20170902','20170905','20170905',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1108,735,4,'20170903','20170905','20170904',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1109,23,4,'20170903','20170904','20170904',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1110,912,4,'20170904','20170907','20170907',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1111,930,4,'20170904','20170906','20170905',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1112,798,4,'20170905','20170908','20170907',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1113,388,4,'20170906','20170908','20170907',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1114,1036,4,'20170906','20170908','20170908',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1115,1100,4,'20170907','20170909','20170909',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1116,52,4,'20170908','20170910','20170910',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1117,334,4,'20170908','20170910','20170910',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1118,1023,4,'20170908','20170911','20170911',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1119,749,4,'20170910','20170912','20170913',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1120,1269,4,'20170910','20170912','20170913',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1121,143,4,'20170911','20170913','20170912',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1122,1132,4,'20170912','20170914','20170914',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1123,598,4,'20170913','20170914','20170914',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1124,275,4,'20170913','20170914','20170916',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1125,945,4,'20170914','20170915','20170915',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1126,1213,4,'20170914','20170916','20170915',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1127,494,4,'20170915','20170916','20170916',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1128,936,4,'20170915','20170917','20170916',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1129,663,4,'20170917','20170918','20170920',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1130,69,4,'20170918','20170920','20170920',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1131,1178,4,'20170918','20170920','20170919',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1132,351,4,'20170919','20170920','20170920',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1133,517,4,'20170919','20170921','20170921',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1134,978,4,'20170919','20170922','20170920',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1135,1347,4,'20170919','20170921','20170920',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1136,1050,4,'20170920','20170921','20170921',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1137,810,4,'20170920','20170923','20170923',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1138,254,4,'20170921','20170923','20170922',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1139,1006,4,'20170921','20170922','20170923',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1140,1063,4,'20170921','20170922','20170922',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1141,1076,4,'20170922','20170923','20170924',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1142,554,4,'20170923','20170926','20170926',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1143,1087,4,'20170924','20170926','20170927',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1144,1414,4,'20170924','20170927','20170927',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1145,617,4,'20170925','20170927','20170926',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1146,757,4,'20170925','20170926','20170928',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1147,1344,4,'20170925','20170926','20170927',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1148,1379,4,'20170925','20170926','20170927',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1149,787,4,'20170927','20170930','20170930',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1150,1183,4,'20170928','20171001','20170930',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1151,708,4,'20170929','20170930','20170930',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1152,1244,4,'20170929','20171002','20171001',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1153,720,4,'20170930','20171003','20171003',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1154,789,4,'20170930','20171003','20171003',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1155,865,4,'20170930','20171001','20171001',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1156,869,4,'20170930','20171003','20171003',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1157,24,4,'20171001','20171003','20171004',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1158,889,4,'20171001','20171003','20171002',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1159,1221,4,'20171001','20171002','20171003',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1160,1262,4,'20171001','20171002','20171004',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1161,41,4,'20171001','20171004','20171002',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1162,888,4,'20171001','20171003','20171003',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1163,934,4,'20171001','20171002','20171002',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1164,1067,4,'20171001','20171002','20171003',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1165,652,4,'20171002','20171003','20171005',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1166,286,4,'20171003','20171004','20171004',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1167,900,4,'20171004','20171007','20171006',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1168,1031,4,'20171004','20171005','20171006',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1169,1421,4,'20171004','20171006','20171007',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1170,534,4,'20171005','20171007','20171006',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1171,826,4,'20171005','20171006','20171008',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1172,1339,4,'20171007','20171010','20171009',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1173,548,4,'20171008','20171010','20171009',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1174,1109,4,'20171008','20171010','20171011',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1175,292,4,'20171009','20171011','20171012',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1176,1111,4,'20171010','20171013','20171011',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1177,21,3,'20171012','20171012',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1178,771,4,'20171012','20171015','20171013',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1179,1150,4,'20171012','20171015','20171015',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1180,1065,4,'20171013','20171016','20171016',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1181,1022,4,'20171013','20171016','20171015',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1182,1422,4,'20171013','20171014','20171016',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1183,216,4,'20171014','20171017','20171017',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1184,369,4,'20171014','20171015','20171016',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1185,960,4,'20171014','20171016','20171017',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1186,1120,4,'20171014','20171016','20171015',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1187,486,4,'20171015','20171018','20171016',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1188,647,4,'20171015','20171018','20171017',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1189,1090,4,'20171015','20171017','20171018',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1190,34,4,'20171016','20171019','20171017',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1191,186,4,'20171017','20171018','20171018',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1192,1114,4,'20171017','20171019','20171018',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1193,1412,4,'20171017','20171019','20171019',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1194,192,4,'20171019','20171022','20171022',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1195,229,4,'20171019','20171021','20171021',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1196,508,4,'20171019','20171021','20171020',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1197,269,4,'20171021','20171023','20171023',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1198,1289,4,'20171022','20171024','20171024',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1199,318,4,'20171023','20171024','20171026',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1200,48,4,'20171023','20171025','20171026',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1201,201,4,'20171023','20171024','20171024',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1202,593,4,'20171024','20171025','20171025',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1203,1191,4,'20171025','20171027','20171026',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1204,1277,4,'20171025','20171028','20171028',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1205,1091,4,'20171026','20171028','20171028',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1206,222,4,'20171026','20171029','20171029',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1207,1002,4,'20171026','20171028','20171027',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1208,1226,4,'20171026','20171028','20171027',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1209,1342,4,'20171026','20171027','20171029',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1210,730,4,'20171026','20171027','20171029',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1211,19,4,'20171027','20171028','20171029',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1212,213,4,'20171027','20171030','20171029',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1213,669,4,'20171027','20171029','20171029',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1214,783,4,'20171028','20171029','20171029',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1215,807,4,'20171028','20171031','20171030',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1216,886,4,'20171028','20171030','20171029',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1217,1155,4,'20171028','20171031','20171030',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1218,1017,4,'20171030','20171101','20171031',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1219,840,4,'20171030','20171102','20171102',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1220,803,4,'20171031','20171103','20171103',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1221,1290,4,'20171031','20171102','20171101',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1222,482,4,'20171101','20171104','20171103',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1223,1207,4,'20171102','20171103','20171103',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1224,544,4,'20171103','20171104','20171104',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1225,768,4,'20171104','20171105','20171107',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1226,226,4,'20171104','20171107','20171106',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1227,702,4,'20171104','20171107','20171106',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1228,1041,4,'20171104','20171106','20171106',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1229,89,4,'20171105','20171108','20171106',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1230,1107,4,'20171105','20171106','20171107',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1231,1180,4,'20171105','20171107','20171106',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1232,665,4,'20171106','20171107','20171109',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1233,462,4,'20171106','20171107','20171108',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1234,19,3,'20171107','20171107',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1235,210,4,'20171107','20171108','20171109',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1236,243,4,'20171108','20171111','20171109',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1237,571,4,'20171109','20171112','20171111',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1238,998,4,'20171109','20171110','20171111',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1239,1197,4,'20171109','20171110','20171111',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1240,903,4,'20171110','20171111','20171111',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1241,1170,4,'20171110','20171112','20171111',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1242,303,4,'20171111','20171112','20171112',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1243,346,4,'20171111','20171113','20171114',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1244,333,4,'20171112','20171114','20171113',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1245,1166,4,'20171113','20171116','20171114',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1246,1329,4,'20171113','20171116','20171116',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1247,426,4,'20171116','20171118','20171117',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1248,1367,4,'20171116','20171117','20171118',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1249,545,4,'20171117','20171118','20171120',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1250,1188,4,'20171117','20171119','20171118',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1251,289,4,'20171117','20171119','20171119',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1252,110,4,'20171118','20171120','20171121',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1253,44,4,'20171118','20171121','20171121',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1254,1098,4,'20171118','20171119','20171119',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1255,375,4,'20171119','20171120','20171121',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1256,458,4,'20171119','20171120','20171122',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1257,1136,4,'20171119','20171122','20171120',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1258,1099,4,'20171120','20171121','20171122',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1259,4,3,'20171121','20171121',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1260,1117,4,'20171122','20171123','20171124',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1261,435,4,'20171123','20171125','20171124',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1262,509,4,'20171123','20171126','20171126',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1263,1408,4,'20171123','20171126','20171126',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1264,113,4,'20171124','20171127','20171125',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1265,950,4,'20171124','20171127','20171127',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1266,387,4,'20171125','20171128','20171127',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1267,467,4,'20171125','20171126','20171126',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1268,774,4,'20171126','20171128','20171129',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1269,1236,4,'20171126','20171129','20171129',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1270,1388,4,'20171126','20171129','20171129',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1271,734,4,'20171127','20171130','20171130',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1272,935,4,'20171127','20171129','20171130',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1273,1268,4,'20171127','20171129','20171129',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1274,1364,4,'20171128','20171129','20171201',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1275,165,4,'20171129','20171201','20171130',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1276,893,4,'20171130','20171203','20171202',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1277,227,4,'20171201','20171204','20171202',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1278,980,4,'20171201','20171202','20171204',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1279,1014,4,'20171201','20171204','20171203',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1280,123,4,'20171201','20171203','20171203',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1281,1060,4,'20171202','20171205','20171205',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1282,320,4,'20171203','20171205','20171205',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1283,85,4,'20171204','20171207','20171207',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1284,128,4,'20171204','20171206','20171207',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1285,262,4,'20171204','20171207','20171207',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1286,1033,4,'20171204','20171207','20171206',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1287,279,4,'20171207','20171210','20171209',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1288,778,4,'20171207','20171210','20171209',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1289,1292,4,'20171208','20171211','20171210',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1290,967,4,'20171208','20171210','20171210',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1291,1284,4,'20171209','20171211','20171212',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1292,285,4,'20171210','20171213','20171211',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1293,1401,4,'20171210','20171212','20171211',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1294,947,4,'20171211','20171213','20171214',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1295,37,4,'20171211','20171212','20171214',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1296,231,4,'20171214','20171217','20171215',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1297,108,4,'20171214','20171217','20171216',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1298,533,4,'20171214','20171217','20171216',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1299,1216,4,'20171215','20171218','20171216',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1300,824,4,'20171215','20171217','20171217',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1301,1088,4,'20171216','20171219','20171219',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1302,322,4,'20171216','20171218','20171219',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1303,878,4,'20171216','20171219','20171218',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1304,1409,4,'20171216','20171217','20171217',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1305,257,4,'20171217','20171219','20171218',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1306,28,4,'20171220','20171221','20171222',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1307,1384,4,'20171222','20171223','20171225',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1308,713,4,'20171222','20171224','20171224',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1309,821,4,'20171222','20171225','20171224',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1310,444,4,'20171224','20171225','20171226',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1311,1021,4,'20171224','20171226','20171227',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1312,311,4,'20171225','20171228','20171226',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1313,1294,4,'20171225','20171227','20171227',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1314,1027,4,'20171225','20171226','20171228',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1315,931,4,'20171225','20171227','20171228',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1316,846,4,'20171226','20171229','20171227',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1317,418,4,'20171227','20171228','20171229',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1318,75,4,'20171227','20171230','20171229',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1319,604,4,'20171227','20171230','20171230',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1320,244,4,'20171228','20171230','20171229',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1321,217,4,'20171230','20171231','20171231',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1322,39,4,'20171231','20180103','20180102',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1323,273,4,'20171231','20180101','20180101',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1324,862,4,'20180101','20180104','20180103',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1325,68,4,'20180101','20180102','20180103',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1326,567,4,'20180101','20180103','20180102',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1327,1026,4,'20180102','20180103','20180105',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1328,1083,4,'20180102','20180103','20180103',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1329,443,4,'20180104','20180105','20180106',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1330,761,4,'20180104','20180105','20180107',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1331,1122,4,'20180105','20180106','20180108',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1332,256,4,'20180106','20180107','20180109',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1333,203,4,'20180106','20180107','20180107',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1334,425,4,'20180107','20180109','20180110',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1335,955,4,'20180107','20180108','20180108',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1336,904,4,'20180109','20180110','20180112',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1337,970,4,'20180109','20180112','20180112',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1338,905,4,'20180110','20180111','20180113',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1339,580,4,'20180111','20180114','20180113',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1340,1066,4,'20180112','20180113','20180113',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1341,1258,4,'20180112','20180113','20180114',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1342,1393,4,'20180112','20180113','20180115',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1343,594,4,'20180113','20180115','20180114',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1344,916,4,'20180113','20180116','20180115',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1345,1037,4,'20180114','20180115','20180115',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1346,136,4,'20180114','20180115','20180115',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1347,247,4,'20180115','20180118','20180118',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1348,1214,4,'20180115','20180117','20180117',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1349,464,4,'20180115','20180117','20180116',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1350,637,4,'20180115','20180118','20180117',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1351,1016,4,'20180116','20180119','20180119',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1352,1433,4,'20180116','20180118','20180118',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1353,502,4,'20180117','20180119','20180118',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1354,476,4,'20180119','20180120','20180121',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1355,1010,4,'20180119','20180121','20180120',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1356,1161,4,'20180119','20180121','20180122',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1357,440,4,'20180120','20180123','20180121',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1358,253,4,'20180121','20180123','20180124',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1359,1008,4,'20180121','20180122','20180122',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1360,71,4,'20180122','20180125','20180124',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1361,1084,4,'20180122','20180124','20180123',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1362,310,4,'20180123','20180124','20180125',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1363,860,4,'20180124','20180125','20180125',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1364,122,4,'20180125','20180128','20180128',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1365,689,4,'20180125','20180128','20180127',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1366,1441,4,'20180126','20180127','20180128',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1367,1118,4,'20180127','20180128','20180128',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1368,765,4,'20180127','20180128','20180129',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1369,92,4,'20180128','20180130','20180130',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1370,115,4,'20180128','20180129','20180129',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1371,937,4,'20180129','20180130','20180201',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1372,1013,4,'20180129','20180201','20180130',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1373,427,4,'20180129','20180131','20180131',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1374,1330,4,'20180130','20180201','20180201',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1375,312,4,'20180130','20180201','20180201',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1376,1186,4,'20180201','20180202','20180203',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1377,1007,4,'20180201','20180203','20180203',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1378,983,4,'20180202','20180205','20180204',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1379,1256,4,'20180202','20180205','20180205',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1380,818,4,'20180205','20180208','20180208',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1381,680,4,'20180205','20180206','20180208',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1382,1303,4,'20180206','20180209','20180208',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1383,488,4,'20180207','20180208','20180208',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1384,1126,4,'20180208','20180210','20180209',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1385,866,4,'20180208','20180211','20180209',3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1386,1254,4,'20180209','20180210','20180211',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1387,11,4,'20180209','20180211','20180211',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1388,323,4,'20180209','20180212','20180212',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1389,491,4,'20180211','20180212','20180214',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1390,63,4,'20180212','20180213','20180213',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1391,914,4,'20180213','20180214','20180214',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1392,1187,4,'20180213','20180214','20180214',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1393,547,4,'20180214','20180215','20180215',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1394,906,4,'20180214','20180216','20180216',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1395,1052,4,'20180215','20180218','20180216',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1396,856,4,'20180215','20180218','20180216',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1397,920,4,'20180215','20180217','20180216',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1398,1383,4,'20180216','20180219','20180219',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1399,146,4,'20180216','20180218','20180218',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1400,987,4,'20180217','20180218','20180218',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1401,15,4,'20180218','20180219','20180220',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1402,1171,4,'20180219','20180221','20180221',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1403,452,4,'20180221','20180222','20180222',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1404,1240,4,'20180223','20180226','20180224',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1405,100,4,'20180225','20180228','20180227',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1406,1053,4,'20180225','20180227','20180227',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1407,18,3,'20180226','20180226',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1408,1172,4,'20180226','20180227','20180301',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1409,21,4,'20180226','20180228','20180228',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1410,1005,4,'20180227','20180228','20180228',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1411,109,4,'20180301','20180302','20180302',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1412,1043,4,'20180301','20180302','20180304',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1413,56,4,'20180301','20180303','20180304',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1414,293,4,'20180303','20180305','20180306',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1415,839,4,'20180303','20180304','20180305',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1416,566,4,'20180303','20180304','20180306',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1417,300,4,'20180304','20180306','20180307',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1418,364,4,'20180304','20180305','20180307',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1419,474,4,'20180304','20180307','20180307',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1420,838,4,'20180304','20180305','20180307',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1421,1176,4,'20180305','20180307','20180307',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1422,599,4,'20180305','20180306','20180308',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1423,1231,4,'20180306','20180307','20180307',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1424,1445,4,'20180307','20180310','20180310',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1425,126,4,'20180307','20180309','20180309',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1426,938,4,'20180307','20180308','20180310',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1427,999,4,'20180307','20180308','20180308',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1428,195,4,'20180308','20180310','20180311',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1429,1116,4,'20180308','20180309','20180309',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1430,1239,4,'20180310','20180313','20180311',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1431,308,4,'20180311','20180312','20180314',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1432,483,4,'20180311','20180312','20180314',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1433,1142,4,'20180311','20180313','20180312',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1434,595,4,'20180314','20180316','20180316',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1435,744,4,'20180314','20180315','20180316',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1436,1044,4,'20180314','20180317','20180316',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1437,518,4,'20180315','20180316','20180316',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1438,263,4,'20180315','20180317','20180316',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1439,463,4,'20180315','20180316','20180317',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1440,859,4,'20180315','20180318','20180316',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1441,982,4,'20180315','20180316','20180318',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1442,478,4,'20180316','20180317','20180317',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1443,972,4,'20180316','20180317','20180317',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1444,1154,4,'20180316','20180317','20180319',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1445,515,4,'20180317','20180318','20180320',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1446,820,4,'20180317','20180318','20180318',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1447,1419,4,'20180318','20180320','20180320',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1448,228,4,'20180318','20180319','20180321',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1449,330,4,'20180318','20180319','20180320',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1450,296,4,'20180319','20180320','20180322',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1451,822,4,'20180319','20180322','20180320',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1452,287,4,'20180320','20180323','20180323',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1453,601,4,'20180320','20180323','20180322',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1454,395,4,'20180320','20180321','20180322',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1455,405,4,'20180320','20180322','20180321',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1456,754,4,'20180320','20180321','20180323',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1457,1411,4,'20180320','20180323','20180323',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1458,1029,4,'20180320','20180322','20180321',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1459,9,4,'20180321','20180322','20180322',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1460,1131,4,'20180321','20180323','20180323',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1461,139,4,'20180322','20180325','20180323',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1462,1101,4,'20180322','20180324','20180324',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1463,692,4,'20180323','20180324','20180324',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1464,1279,4,'20180324','20180325','20180325',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1465,623,4,'20180325','20180328','20180328',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1466,738,4,'20180326','20180329','20180328',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1467,152,4,'20180326','20180327','20180329',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1468,3,4,'20180327','20180330','20180329',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1469,1135,4,'20180327','20180328','20180330',3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1470,505,4,'20180328','20180331','20180331',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1471,1310,4,'20180328','20180330','20180329',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1472,114,4,'20180329','20180330','20180331',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1473,302,4,'20180330','20180401','20180402',1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1474,816,4,'20180330','20180401','20180402',1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1475,112,4,'20180330','20180401','20180331',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1476,35,4,'20180331','20180401','20180401',2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1477,180,4,'20180331','20180403','20180401',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1478,392,4,'20180331','20180402','20180402',2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1479,23,2,'20180401','20180401',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1480,27,2,'20180401','20180401',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1481,62,1,'20180401','20180401',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1482,94,1,'20180401','20180401',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1483,15,1,'20180402','20180402',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1484,35,2,'20180402','20180402',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1485,51,2,'20180402','20180402',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1486,84,2,'20180402','20180402',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1487,33,1,'20180403','20180403',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1488,181,2,'20180403','20180403',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1489,194,1,'20180403','20180403',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1490,217,2,'20180403','20180403',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1491,82,1,'20180404','20180404',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1492,41,1,'20180404','20180404',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1493,64,2,'20180404','20180404',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1494,69,2,'20180405','20180405',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1495,86,2,'20180405','20180405',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1496,3,1,'20180406','20180406',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1497,31,2,'20180406','20180406',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1498,81,1,'20180406','20180406',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1499,120,2,'20180406','20180406',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1500,151,2,'20180406','20180406',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1501,52,1,'20180406','20180406',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1502,83,2,'20180406','20180406',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1503,208,2,'20180407','20180407',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1504,237,2,'20180408','20180408',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1505,22,1,'20180408','20180408',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1506,75,1,'20180408','20180408',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1507,85,2,'20180408','20180408',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1508,92,2,'20180408','20180408',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1509,2,1,'20180409','20180409',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1510,16,2,'20180409','20180409',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1511,25,1,'20180409','20180409',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1512,68,1,'20180409','20180409',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1513,32,2,'20180410','20180410',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1514,87,2,'20180410','20180410',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1515,61,1,'20180410','20180410',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1516,47,2,'20180411','20180411',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1517,97,1,'20180411','20180411',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1518,175,1,'20180411','20180411',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1519,26,2,'20180411','20180411',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1520,66,2,'20180411','20180411',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1521,53,1,'20180412','20180412',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1522,78,1,'20180412','20180412',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1523,8,1,'20180412','20180412',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1524,37,1,'20180412','20180412',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1525,38,2,'20180412','20180412',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1526,59,2,'20180412','20180412',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1527,13,2,'20180412','20180412',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1528,20,1,'20180412','20180412',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1529,50,1,'20180412','20180412',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1530,110,1,'20180413','20180413',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1531,233,1,'20180413','20180413',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1532,7,2,'20180413','20180413',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1533,28,2,'20180413','20180413',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1534,18,2,'20180414','20180414',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1535,19,2,'20180414','20180414',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1536,34,2,'20180414','20180414',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1537,36,1,'20180415','20180415',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1538,79,2,'20180415','20180415',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1539,116,1,'20180415','20180415',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1540,187,1,'20180416','20180416',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1541,10,2,'20180416','20180416',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1542,58,2,'20180416','20180416',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1543,76,1,'20180416','20180416',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1544,5,1,'20180417','20180417',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1545,67,1,'20180417','20180417',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1546,91,2,'20180417','20180417',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1547,169,1,'20180417','20180417',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1548,170,1,'20180417','20180417',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1549,17,1,'20180417','20180417',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1550,39,1,'20180417','20180417',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1551,70,1,'20180417','20180417',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1552,73,1,'20180417','20180417',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1553,30,2,'20180418','20180418',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1554,172,1,'20180418','20180418',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1555,1,1,'20180418','20180418',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1556,4,2,'20180418','20180418',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1557,121,2,'20180419','20180419',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1558,63,1,'20180419','20180419',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1559,42,2,'20180420','20180420',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1560,57,1,'20180420','20180420',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1561,65,2,'20180420','20180420',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1562,88,1,'20180420','20180420',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1563,77,2,'20180420','20180420',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1564,46,1,'20180421','20180421',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1565,60,2,'20180421','20180421',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1566,72,1,'20180421','20180421',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1567,89,2,'20180421','20180421',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1568,192,2,'20180421','20180421',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1569,29,2,'20180422','20180422',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1570,54,2,'20180422','20180422',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1571,80,1,'20180422','20180422',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1572,14,1,'20180422','20180422',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1573,24,2,'20180423','20180423',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1574,124,1,'20180423','20180423',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1575,224,2,'20180423','20180423',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1576,12,2,'20180423','20180423',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1577,48,1,'20180423','20180423',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1578,93,2,'20180423','20180423',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1579,104,2,'20180424','20180424',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1580,191,2,'20180424','20180424',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1581,188,2,'20180425','20180425',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1582,240,1,'20180425','20180425',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1583,44,1,'20180425','20180425',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1584,109,2,'20180426','20180426',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1585,157,1,'20180426','20180426',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1586,176,1,'20180426','20180426',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1587,231,2,'20180426','20180426',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1588,11,1,'20180426','20180426',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1589,40,2,'20180427','20180427',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1590,138,1,'20180427','20180427',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1591,165,2,'20180427','20180427',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1592,6,2,'20180427','20180427',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1593,9,1,'20180427','20180427',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1594,45,1,'20180428','20180428',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1595,71,2,'20180428','20180428',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1596,21,2,'20180428','20180428',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1597,56,1,'20180428','20180428',NULL,3,9);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1598,239,2,'20180429','20180429',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1599,49,1,'20180429','20180429',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1600,90,1,'20180429','20180429',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1601,43,1,'20180429','20180429',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1602,55,1,'20180430','20180430',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1603,74,2,'20180430','20180430',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1604,7,3,'20180617','20180617',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1605,123,3,'20180701','20180701',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1606,119,3,'20180710','20180710',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1607,33,3,'20180711','20180711',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1608,53,3,'20180712','20180712',NULL,1,2);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1609,10,3,'20180823','20180823',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1610,15,3,'20180825','20180825',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1611,6,3,'20180906','20180906',NULL,2,7);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1612,3,3,'20181021','20181021',NULL,1,3);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1613,1,3,'20181118','20181118',NULL,2,6);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1614,135,3,'20181128','20181128',NULL,3,8);
INSERT INTO sales.orders(order_id, customer_id, order_status, order_date, required_date, shipped_date, store_id,staff_id) VALUES(1615,136,3,'20181228','20181228',NULL,3,8);

SET IDENTITY_INSERT sales.orders OFF;  

INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(1,1,20,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(1,2,8,2,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(1,3,10,2,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(1,4,16,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(1,5,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(2,1,20,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(2,2,16,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(3,1,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(3,2,20,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(4,1,2,2,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(5,1,10,2,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(5,2,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(5,3,26,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(6,1,18,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(6,2,12,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(6,3,20,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(6,4,3,2,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(6,5,9,2,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(7,1,15,1,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(7,2,3,1,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(7,3,17,2,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(8,1,22,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(8,2,20,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(9,1,7,2,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(10,1,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(11,1,8,1,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(11,2,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(11,3,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(12,1,4,2,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(12,2,11,1,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(13,1,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(13,2,17,2,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(13,3,20,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(13,4,16,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(14,1,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(15,1,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(15,2,8,1,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(15,3,18,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(15,4,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(16,1,8,1,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(16,2,21,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(16,3,13,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(16,4,14,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(17,1,8,1,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(17,2,23,1,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(17,3,5,1,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(17,4,20,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(18,1,2,2,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(18,2,22,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(18,3,7,1,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(18,4,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(18,5,9,2,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(19,1,10,1,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(19,2,9,2,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(20,1,9,1,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(20,2,10,2,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(21,1,14,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(21,2,17,1,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(21,3,10,1,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(22,1,15,2,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(22,2,22,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(23,1,4,2,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(23,2,23,2,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(23,3,13,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(24,1,3,2,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(24,2,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(25,1,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(25,2,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(25,3,22,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(25,4,14,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(25,5,21,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(26,1,7,1,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(26,2,2,1,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(26,3,12,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(26,4,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(27,1,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(27,2,19,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(27,3,26,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(27,4,8,1,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(28,1,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(28,2,7,2,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(28,3,14,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(28,4,6,1,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(29,1,24,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(29,2,6,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(29,3,21,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(29,4,8,1,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(29,5,14,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(30,1,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(30,2,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(30,3,19,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(30,4,4,1,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(30,5,7,2,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(31,1,11,2,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(31,2,9,2,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(32,1,8,2,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(32,2,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(32,3,25,2,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(33,1,23,2,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(33,2,7,1,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(34,1,8,2,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(34,2,10,2,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(34,3,17,2,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(35,1,18,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(35,2,20,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(35,3,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(35,4,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(35,5,22,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(36,1,9,1,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(36,2,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(36,3,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(37,1,16,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(38,1,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(38,2,23,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(38,3,25,1,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(38,4,10,2,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(38,5,24,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(39,1,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(39,2,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(39,3,3,2,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(39,4,15,1,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(40,1,17,1,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(40,2,8,2,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(41,1,5,1,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(41,2,19,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(41,3,26,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(42,1,19,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(43,1,13,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(43,2,12,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(44,1,7,1,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(44,2,16,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(45,1,4,2,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(45,2,22,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(45,3,21,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(46,1,17,1,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(47,1,6,1,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(47,2,15,1,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(47,3,25,2,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(47,4,13,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(48,1,11,1,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(48,2,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(48,3,5,2,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(48,4,14,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(49,1,13,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(50,1,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(50,2,26,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(50,3,13,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(51,1,13,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(51,2,20,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(51,3,26,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(52,1,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(53,1,8,2,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(53,2,23,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(53,3,14,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(53,4,25,2,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(54,1,26,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(54,2,3,1,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(55,1,21,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(55,2,25,2,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(55,3,15,2,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(56,1,20,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(57,1,23,2,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(57,2,19,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(57,3,13,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(58,1,14,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(58,2,18,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(58,3,23,1,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(59,1,21,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(59,2,2,1,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(59,3,17,2,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(60,1,14,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(60,2,4,1,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(60,3,15,1,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(60,4,22,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(61,1,25,1,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(61,2,15,2,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(61,3,5,2,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(62,1,14,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(62,2,8,2,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(62,3,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(63,1,25,2,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(63,2,19,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(63,3,3,1,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(64,1,25,2,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(64,2,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(64,3,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(64,4,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(65,1,12,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(66,1,2,1,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(66,2,23,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(66,3,12,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(67,1,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(67,2,12,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(67,3,21,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(67,4,5,2,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(67,5,19,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(68,1,13,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(68,2,17,1,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(69,1,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(69,2,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(69,3,10,1,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(70,1,3,2,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(70,2,18,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(70,3,20,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(71,1,26,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(71,2,24,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(71,3,18,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(72,1,17,2,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(72,2,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(72,3,13,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(73,1,22,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(73,2,26,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(73,3,3,2,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(73,4,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(73,5,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(74,1,16,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(74,2,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(75,1,3,1,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(75,2,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(75,3,15,1,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(76,1,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(76,2,11,2,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(76,3,5,1,1320.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(77,1,20,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(77,2,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(77,3,26,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(77,4,25,1,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(78,1,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(78,2,19,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(78,3,18,2,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(78,4,14,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(79,1,9,2,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(79,2,17,2,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(79,3,6,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(79,4,25,2,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(80,1,26,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(80,2,24,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(80,3,17,1,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(81,1,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(81,2,23,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(81,3,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(82,1,25,2,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(82,2,11,2,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(83,1,20,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(83,2,3,2,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(84,1,23,2,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(84,2,15,2,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(85,1,4,2,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(85,2,18,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(86,1,9,2,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(86,2,23,2,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(86,3,21,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(86,4,15,1,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(87,1,20,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(87,2,23,2,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(88,1,10,1,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(88,2,8,2,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(88,3,7,1,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(89,1,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(89,2,6,2,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(90,1,3,1,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(90,2,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(91,1,11,1,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(91,2,25,1,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(91,3,15,2,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(91,4,13,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(92,1,8,1,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(93,1,22,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(93,2,17,1,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(93,3,21,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(93,4,2,1,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(93,5,10,2,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(94,1,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(94,2,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(94,3,11,1,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(94,4,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(95,1,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(95,2,19,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(95,3,8,2,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(95,4,20,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(96,1,26,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(96,2,23,1,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(97,1,20,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(97,2,2,1,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(97,3,6,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(97,4,19,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(98,1,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(98,2,21,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(98,3,2,1,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(98,4,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(99,1,13,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(99,2,21,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(99,3,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(99,4,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(99,5,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(100,1,12,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(100,2,11,2,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(100,3,7,2,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(100,4,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(100,5,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(101,1,12,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(102,1,15,1,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(102,2,22,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(103,1,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(103,2,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(103,3,18,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(103,4,15,2,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(103,5,9,2,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(104,1,19,2,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(104,2,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(105,1,11,2,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(105,2,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(105,3,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(106,1,17,1,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(106,2,13,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(107,1,19,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(107,2,13,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(108,1,11,1,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(108,2,22,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(108,3,16,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(109,1,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(109,2,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(110,1,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(111,1,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(111,2,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(112,1,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(112,2,25,2,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(112,3,24,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(112,4,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(113,1,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(113,2,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(113,3,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(113,4,23,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(113,5,5,2,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(114,1,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(114,2,2,1,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(114,3,13,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(115,1,22,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(115,2,19,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(116,1,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(117,1,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(117,2,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(117,3,14,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(117,4,19,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(118,1,18,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(118,2,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(118,3,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(118,4,3,2,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(118,5,23,2,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(119,1,25,1,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(120,1,13,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(120,2,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(120,3,10,2,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(120,4,17,1,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(120,5,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(121,1,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(121,2,14,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(121,3,4,2,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(121,4,24,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(121,5,2,2,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(122,1,16,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(123,1,12,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(124,1,16,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(124,2,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(124,3,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(125,1,17,1,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(126,1,9,2,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(127,1,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(127,2,20,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(127,3,4,2,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(128,1,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(128,2,16,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(128,3,4,2,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(128,4,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(129,1,18,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(129,2,9,1,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(130,1,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(130,2,5,2,1320.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(131,1,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(131,2,4,2,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(131,3,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(132,1,2,2,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(132,2,20,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(132,3,9,1,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(133,1,13,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(133,2,22,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(134,1,19,2,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(134,2,2,2,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(134,3,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(135,1,5,2,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(135,2,18,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(135,3,25,1,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(135,4,2,1,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(136,1,7,2,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(136,2,3,2,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(137,1,23,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(137,2,22,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(138,1,16,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(138,2,6,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(139,1,19,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(139,2,3,1,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(140,1,15,1,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(140,2,21,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(140,3,12,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(140,4,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(141,1,18,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(142,1,16,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(142,2,11,2,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(142,3,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(143,1,6,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(144,1,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(145,1,11,1,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(145,2,9,2,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(146,1,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(146,2,12,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(146,3,20,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(146,4,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(146,5,2,1,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(147,1,26,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(148,1,14,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(149,1,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(149,2,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(150,1,7,1,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(150,2,3,1,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(150,3,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(150,4,25,2,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(151,1,17,1,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(151,2,26,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(152,1,6,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(152,2,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(152,3,16,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(153,1,16,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(153,2,8,1,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(153,3,15,2,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(154,1,12,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(155,1,8,1,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(156,1,18,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(156,2,17,2,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(156,3,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(157,1,4,1,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(157,2,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(158,1,24,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(159,1,13,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(160,1,21,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(160,2,15,2,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(160,3,18,2,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(160,4,11,1,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(161,1,24,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(161,2,22,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(161,3,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(162,1,18,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(162,2,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(162,3,3,2,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(163,1,12,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(163,2,18,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(164,1,4,2,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(164,2,10,2,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(164,3,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(165,1,4,2,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(165,2,23,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(165,3,2,1,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(166,1,10,2,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(166,2,11,1,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(167,1,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(167,2,10,1,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(167,3,13,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(167,4,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(168,1,6,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(168,2,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(168,3,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(168,4,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(169,1,20,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(169,2,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(169,3,10,1,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(169,4,11,1,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(169,5,14,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(170,1,12,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(170,2,24,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(170,3,7,1,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(170,4,18,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(171,1,8,1,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(172,1,23,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(172,2,16,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(173,1,14,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(173,2,16,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(173,3,20,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(174,1,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(174,2,19,2,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(175,1,5,1,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(175,2,2,2,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(175,3,21,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(175,4,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(176,1,2,2,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(176,2,11,2,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(176,3,16,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(177,1,20,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(178,1,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(178,2,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(178,3,3,1,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(178,4,18,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(179,1,13,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(179,2,26,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(179,3,18,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(179,4,12,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(179,5,20,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(180,1,16,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(181,1,10,1,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(181,2,11,1,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(181,3,15,2,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(181,4,24,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(182,1,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(182,2,24,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(183,1,11,2,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(183,2,12,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(183,3,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(183,4,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(184,1,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(184,2,5,1,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(184,3,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(185,1,20,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(185,2,8,1,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(186,1,4,1,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(186,2,6,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(187,1,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(188,1,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(189,1,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(190,1,24,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(190,2,15,1,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(190,3,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(191,1,25,1,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(191,2,12,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(191,3,3,1,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(191,4,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(191,5,23,1,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(192,1,8,2,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(192,2,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(192,3,2,1,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(192,4,24,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(192,5,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(193,1,12,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(194,1,21,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(195,1,18,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(195,2,14,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(195,3,5,2,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(195,4,4,2,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(195,5,21,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(196,1,6,1,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(196,2,3,2,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(196,3,10,2,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(196,4,12,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(196,5,20,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(197,1,4,2,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(197,2,2,2,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(198,1,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(198,2,20,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(198,3,8,2,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(198,4,13,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(198,5,17,1,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(199,1,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(199,2,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(199,3,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(200,1,23,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(200,2,22,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(201,1,24,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(201,2,7,1,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(201,3,14,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(201,4,17,1,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(202,1,8,1,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(202,2,17,1,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(202,3,15,2,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(202,4,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(203,1,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(203,2,3,2,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(203,3,17,2,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(203,4,19,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(204,1,6,2,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(204,2,17,2,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(205,1,22,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(205,2,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(206,1,25,1,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(206,2,20,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(207,1,12,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(207,2,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(207,3,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(207,4,7,2,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(208,1,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(208,2,4,2,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(208,3,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(208,4,12,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(208,5,10,2,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(209,1,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(210,1,14,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(210,2,13,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(211,1,10,1,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(211,2,2,2,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(212,1,16,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(212,2,12,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(212,3,19,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(212,4,7,1,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(213,1,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(214,1,21,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(215,1,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(215,2,12,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(216,1,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(216,2,16,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(217,1,18,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(217,2,10,2,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(217,3,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(218,1,2,2,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(218,2,13,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(218,3,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(219,1,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(219,2,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(220,1,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(220,2,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(220,3,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(220,4,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(221,1,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(222,1,10,1,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(222,2,2,2,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(223,1,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(223,2,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(223,3,21,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(223,4,20,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(223,5,15,1,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(224,1,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(224,2,11,2,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(224,3,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(224,4,25,1,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(225,1,21,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(225,2,9,1,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(226,1,2,1,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(227,1,3,2,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(227,2,15,2,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(228,1,25,1,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(228,2,2,2,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(228,3,23,2,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(228,4,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(228,5,22,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(229,1,25,2,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(229,2,5,2,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(229,3,8,1,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(230,1,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(231,1,8,2,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(231,2,14,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(231,3,5,2,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(232,1,18,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(232,2,11,2,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(232,3,26,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(232,4,8,2,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(233,1,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(233,2,16,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(233,3,12,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(233,4,15,2,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(234,1,11,2,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(234,2,17,2,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(234,3,12,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(234,4,7,1,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(234,5,23,1,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(235,1,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(235,2,13,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(235,3,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(236,1,3,2,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(236,2,2,2,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(236,3,4,2,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(237,1,15,1,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(237,2,24,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(237,3,20,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(237,4,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(238,1,20,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(238,2,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(238,3,13,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(238,4,22,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(238,5,7,1,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(239,1,16,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(239,2,21,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(239,3,18,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(239,4,4,2,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(240,1,9,1,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(240,2,8,1,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(240,3,5,1,1320.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(240,4,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(241,1,7,1,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(242,1,3,1,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(243,1,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(243,2,19,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(243,3,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(244,1,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(244,2,25,1,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(244,3,22,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(245,1,10,2,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(245,2,8,1,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(246,1,17,2,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(247,1,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(247,2,3,1,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(248,1,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(248,2,26,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(248,3,17,1,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(248,4,9,1,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(249,1,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(249,2,18,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(249,3,22,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(250,1,17,2,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(250,2,11,2,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(251,1,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(251,2,22,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(252,1,11,2,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(252,2,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(252,3,19,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(253,1,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(254,1,6,2,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(254,2,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(254,3,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(255,1,5,2,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(255,2,14,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(255,3,2,2,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(255,4,21,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(256,1,11,1,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(256,2,21,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(257,1,8,2,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(257,2,13,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(257,3,10,2,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(257,4,15,1,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(258,1,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(258,2,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(258,3,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(258,4,18,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(259,1,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(259,2,6,2,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(259,3,2,2,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(259,4,4,1,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(260,1,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(260,2,10,1,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(260,3,24,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(261,1,16,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(261,2,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(261,3,17,2,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(262,1,2,1,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(262,2,9,2,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(263,1,9,1,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(263,2,3,1,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(263,3,2,2,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(264,1,10,1,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(264,2,24,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(264,3,15,2,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(264,4,3,2,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(265,1,9,2,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(266,1,6,2,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(266,2,19,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(266,3,25,1,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(267,1,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(267,2,23,2,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(267,3,24,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(267,4,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(267,5,21,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(268,1,7,1,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(268,2,6,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(268,3,9,1,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(269,1,5,1,1320.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(269,2,23,2,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(269,3,18,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(269,4,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(270,1,25,2,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(270,2,15,1,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(271,1,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(271,2,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(271,3,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(271,4,7,2,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(272,1,2,2,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(272,2,11,1,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(273,1,21,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(274,1,11,2,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(274,2,25,2,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(274,3,9,2,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(275,1,18,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(275,2,25,1,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(275,3,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(276,1,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(276,2,17,1,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(276,3,9,2,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(277,1,20,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(277,2,6,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(277,3,13,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(278,1,16,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(278,2,19,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(278,3,13,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(278,4,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(279,1,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(280,1,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(280,2,26,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(280,3,13,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(281,1,22,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(281,2,14,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(281,3,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(282,1,20,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(282,2,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(282,3,3,2,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(282,4,16,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(283,1,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(283,2,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(284,1,24,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(284,2,20,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(285,1,16,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(285,2,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(285,3,2,1,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(286,1,26,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(286,2,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(286,3,16,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(286,4,7,1,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(287,1,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(287,2,10,1,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(287,3,2,1,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(287,4,20,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(288,1,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(288,2,10,1,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(288,3,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(289,1,13,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(289,2,24,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(289,3,17,1,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(290,1,2,2,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(290,2,5,2,1320.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(290,3,21,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(291,1,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(291,2,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(292,1,18,2,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(292,2,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(292,3,10,2,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(293,1,19,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(293,2,6,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(294,1,18,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(294,2,14,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(294,3,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(294,4,25,2,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(295,1,22,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(296,1,25,2,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(296,2,12,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(296,3,11,2,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(296,4,9,1,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(297,1,4,2,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(298,1,23,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(298,2,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(298,3,22,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(298,4,9,1,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(298,5,14,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(299,1,11,2,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(299,2,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(300,1,16,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(300,2,9,2,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(300,3,10,1,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(300,4,11,2,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(301,1,6,1,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(301,2,22,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(302,1,24,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(302,2,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(302,3,2,2,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(303,1,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(303,2,24,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(304,1,10,1,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(304,2,7,2,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(304,3,20,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(305,1,10,1,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(305,2,6,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(305,3,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(306,1,10,1,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(306,2,22,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(307,1,15,2,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(308,1,7,1,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(308,2,18,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(308,3,14,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(309,1,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(309,2,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(310,1,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(310,2,14,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(310,3,5,2,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(310,4,8,1,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(311,1,17,2,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(311,2,5,2,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(312,1,24,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(312,2,14,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(312,3,16,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(313,1,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(313,2,10,2,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(314,1,5,1,1320.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(314,2,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(314,3,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(314,4,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(315,1,11,1,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(315,2,9,1,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(316,1,2,2,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(316,2,16,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(316,3,20,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(316,4,19,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(316,5,17,1,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(317,1,10,1,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(317,2,22,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(317,3,15,1,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(317,4,13,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(318,1,13,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(318,2,25,2,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(318,3,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(319,1,11,1,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(319,2,21,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(319,3,15,2,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(319,4,23,1,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(320,1,2,1,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(321,1,4,2,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(321,2,12,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(321,3,26,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(321,4,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(322,1,13,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(322,2,21,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(323,1,13,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(323,2,26,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(324,1,2,2,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(324,2,17,1,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(324,3,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(324,4,19,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(324,5,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(325,1,7,1,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(325,2,12,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(325,3,6,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(326,1,12,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(326,2,23,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(327,1,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(327,2,13,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(327,3,4,1,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(328,1,6,2,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(329,1,14,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(329,2,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(329,3,23,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(329,4,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(329,5,26,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(330,1,21,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(331,1,17,2,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(332,1,18,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(333,1,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(333,2,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(333,3,3,1,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(334,1,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(334,2,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(334,3,3,2,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(335,1,6,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(335,2,2,2,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(335,3,21,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(336,1,4,1,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(336,2,12,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(337,1,18,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(337,2,4,1,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(338,1,6,2,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(338,2,10,1,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(338,3,22,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(338,4,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(338,5,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(339,1,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(339,2,15,2,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(340,1,11,1,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(340,2,24,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(340,3,13,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(340,4,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(340,5,10,2,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(341,1,23,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(342,1,26,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(342,2,9,1,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(342,3,16,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(343,1,20,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(343,2,25,1,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(343,3,5,2,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(343,4,10,1,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(344,1,22,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(344,2,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(344,3,14,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(345,1,18,2,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(345,2,24,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(346,1,13,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(346,2,23,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(346,3,21,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(346,4,15,1,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(346,5,18,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(347,1,23,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(348,1,5,2,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(348,2,15,2,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(349,1,20,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(350,1,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(350,2,20,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(350,3,3,1,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(351,1,4,2,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(351,2,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(351,3,20,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(351,4,22,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(352,1,11,1,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(352,2,14,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(353,1,2,2,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(354,1,21,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(354,2,19,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(355,1,16,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(355,2,14,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(356,1,23,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(356,2,4,1,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(356,3,13,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(357,1,17,2,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(357,2,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(357,3,24,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(357,4,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(358,1,21,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(358,2,6,2,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(358,3,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(358,4,18,2,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(359,1,15,2,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(359,2,9,2,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(359,3,7,2,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(360,1,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(360,2,7,2,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(360,3,13,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(360,4,25,1,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(361,1,24,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(361,2,6,2,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(361,3,11,1,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(362,1,2,1,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(363,1,21,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(363,2,14,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(363,3,15,1,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(363,4,20,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(364,1,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(365,1,24,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(366,1,21,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(366,2,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(366,3,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(367,1,26,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(367,2,14,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(367,3,10,2,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(368,1,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(368,2,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(368,3,21,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(368,4,19,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(369,1,10,2,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(370,1,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(370,2,4,2,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(371,1,14,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(371,2,12,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(372,1,11,1,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(372,2,14,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(372,3,5,1,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(373,1,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(373,2,22,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(373,3,19,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(373,4,12,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(373,5,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(374,1,10,1,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(374,2,7,1,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(375,1,21,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(375,2,2,2,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(375,3,4,2,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(375,4,12,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(376,1,2,2,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(376,2,23,2,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(377,1,8,1,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(377,2,14,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(378,1,26,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(379,1,9,1,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(379,2,16,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(380,1,16,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(380,2,11,2,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(381,1,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(382,1,8,1,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(382,2,9,1,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(382,3,13,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(383,1,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(383,2,22,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(383,3,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(383,4,21,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(383,5,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(384,1,20,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(384,2,21,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(384,3,8,1,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(384,4,15,1,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(384,5,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(385,1,21,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(385,2,7,2,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(385,3,26,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(386,1,8,1,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(386,2,3,2,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(386,3,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(387,1,18,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(388,1,19,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(388,2,13,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(388,3,2,1,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(388,4,11,1,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(389,1,2,1,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(389,2,15,2,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(389,3,10,2,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(389,4,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(389,5,9,1,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(390,1,23,1,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(390,2,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(390,3,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(391,1,8,1,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(391,2,5,2,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(391,3,24,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(392,1,14,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(392,2,3,2,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(393,1,6,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(394,1,23,1,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(394,2,16,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(394,3,14,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(395,1,14,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(396,1,12,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(396,2,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(396,3,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(397,1,7,1,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(398,1,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(398,2,18,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(398,3,25,1,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(398,4,17,1,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(399,1,25,1,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(399,2,11,2,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(399,3,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(400,1,24,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(400,2,9,1,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(400,3,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(401,1,23,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(401,2,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(402,1,6,2,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(402,2,5,1,1320.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(402,3,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(403,1,12,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(403,2,7,2,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(403,3,22,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(403,4,24,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(404,1,9,1,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(404,2,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(404,3,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(405,1,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(405,2,10,2,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(405,3,14,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(406,1,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(407,1,20,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(407,2,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(408,1,18,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(408,2,3,1,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(408,3,2,2,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(408,4,17,2,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(409,1,15,1,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(409,2,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(409,3,21,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(410,1,25,1,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(410,2,9,2,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(410,3,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(411,1,2,1,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(411,2,26,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(412,1,7,1,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(412,2,24,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(412,3,17,1,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(413,1,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(413,2,25,1,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(413,3,9,1,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(414,1,4,2,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(415,1,3,1,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(415,2,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(415,3,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(415,4,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(416,1,22,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(416,2,14,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(416,3,24,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(417,1,26,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(417,2,6,2,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(418,1,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(418,2,20,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(419,1,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(420,1,17,2,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(420,2,15,2,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(420,3,3,2,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(421,1,6,2,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(421,2,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(421,3,20,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(421,4,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(421,5,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(422,1,20,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(423,1,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(423,2,17,1,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(423,3,23,2,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(423,4,2,1,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(424,1,22,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(424,2,6,1,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(425,1,6,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(425,2,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(425,3,19,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(426,1,10,1,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(426,2,23,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(427,1,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(427,2,15,2,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(427,3,26,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(428,1,5,2,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(428,2,14,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(429,1,11,1,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(429,2,4,2,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(429,3,5,2,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(429,4,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(429,5,2,1,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(430,1,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(430,2,11,1,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(430,3,4,2,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(430,4,13,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(430,5,8,1,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(431,1,14,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(431,2,6,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(431,3,18,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(431,4,13,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(431,5,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(432,1,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(432,2,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(433,1,6,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(433,2,10,1,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(433,3,24,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(433,4,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(434,1,21,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(434,2,20,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(434,3,9,1,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(434,4,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(434,5,18,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(435,1,22,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(435,2,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(435,3,18,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(436,1,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(436,2,23,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(437,1,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(437,2,10,1,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(437,3,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(438,1,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(438,2,22,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(438,3,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(438,4,13,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(439,1,6,2,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(439,2,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(440,1,19,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(440,2,4,2,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(441,1,12,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(441,2,15,1,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(442,1,16,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(442,2,26,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(442,3,6,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(443,1,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(443,2,26,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(444,1,22,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(444,2,15,2,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(444,3,20,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(444,4,16,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(444,5,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(445,1,7,1,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(445,2,16,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(445,3,23,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(446,1,22,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(446,2,16,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(447,1,4,2,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(447,2,3,1,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(447,3,8,1,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(448,1,13,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(448,2,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(449,1,17,2,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(449,2,2,1,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(449,3,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(449,4,26,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(450,1,24,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(450,2,12,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(450,3,5,1,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(451,1,14,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(452,1,11,1,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(452,2,16,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(452,3,7,2,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(452,4,8,1,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(453,1,23,1,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(453,2,20,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(453,3,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(454,1,25,2,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(454,2,13,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(454,3,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(455,1,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(456,1,17,2,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(456,2,23,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(457,1,24,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(457,2,2,1,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(457,3,7,2,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(457,4,17,1,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(458,1,2,1,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(458,2,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(458,3,11,1,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(458,4,24,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(458,5,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(459,1,11,1,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(460,1,19,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(460,2,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(460,3,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(460,4,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(461,1,16,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(461,2,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(461,3,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(461,4,24,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(461,5,18,2,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(462,1,12,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(463,1,13,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(464,1,7,1,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(465,1,6,2,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(465,2,25,2,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(466,1,19,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(466,2,6,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(466,3,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(466,4,15,1,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(466,5,5,1,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(467,1,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(467,2,10,1,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(467,3,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(467,4,17,2,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(467,5,11,1,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(468,1,19,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(468,2,9,2,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(468,3,10,2,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(468,4,25,1,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(469,1,8,2,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(469,2,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(469,3,15,2,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(470,1,18,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(470,2,13,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(470,3,8,2,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(471,1,14,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(471,2,13,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(472,1,15,1,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(472,2,21,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(473,1,26,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(474,1,19,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(474,2,11,1,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(475,1,17,2,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(475,2,26,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(475,3,25,1,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(476,1,22,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(476,2,4,2,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(476,3,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(476,4,20,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(477,1,6,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(477,2,10,1,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(478,1,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(479,1,26,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(479,2,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(479,3,21,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(479,4,7,1,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(479,5,10,1,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(480,1,4,1,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(480,2,15,1,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(480,3,23,2,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(481,1,13,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(481,2,16,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(481,3,9,2,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(482,1,13,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(482,2,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(483,1,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(484,1,8,2,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(484,2,24,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(484,3,9,2,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(484,4,6,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(485,1,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(485,2,26,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(486,1,9,1,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(486,2,23,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(487,1,6,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(488,1,13,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(488,2,23,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(488,3,22,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(489,1,8,2,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(490,1,12,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(490,2,23,1,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(490,3,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(490,4,13,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(491,1,9,2,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(491,2,21,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(491,3,15,2,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(492,1,6,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(492,2,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(492,3,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(493,1,15,1,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(493,2,18,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(493,3,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(494,1,23,1,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(495,1,22,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(495,2,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(496,1,23,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(496,2,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(496,3,21,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(497,1,25,2,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(498,1,24,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(498,2,21,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(498,3,10,1,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(499,1,11,1,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(499,2,15,1,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(499,3,14,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(499,4,20,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(500,1,12,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(500,2,14,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(501,1,19,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(501,2,8,1,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(501,3,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(501,4,23,2,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(502,1,13,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(503,1,13,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(503,2,10,1,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(504,1,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(504,2,2,2,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(505,1,26,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(506,1,25,1,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(506,2,7,1,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(507,1,11,2,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(507,2,13,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(507,3,20,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(508,1,8,1,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(508,2,2,2,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(508,3,10,2,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(508,4,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(509,1,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(509,2,4,2,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(510,1,17,1,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(511,1,22,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(511,2,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(512,1,21,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(513,1,7,1,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(513,2,13,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(513,3,23,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(514,1,18,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(514,2,17,2,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(515,1,8,1,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(515,2,5,1,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(515,3,25,2,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(515,4,6,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(516,1,7,1,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(516,2,5,2,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(517,1,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(518,1,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(518,2,5,2,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(518,3,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(518,4,15,2,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(518,5,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(519,1,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(519,2,16,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(519,3,23,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(519,4,18,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(519,5,7,1,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(520,1,26,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(520,2,24,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(520,3,10,1,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(521,1,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(521,2,14,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(522,1,4,2,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(522,2,22,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(522,3,21,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(523,1,12,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(523,2,20,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(523,3,5,2,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(523,4,16,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(524,1,11,1,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(524,2,2,1,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(524,3,9,1,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(524,4,3,2,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(524,5,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(525,1,9,2,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(525,2,6,2,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(525,3,10,1,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(526,1,3,2,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(526,2,8,1,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(526,3,21,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(526,4,15,1,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(527,1,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(527,2,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(527,3,19,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(527,4,9,2,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(528,1,21,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(529,1,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(530,1,2,2,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(530,2,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(530,3,6,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(531,1,6,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(531,2,12,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(531,3,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(532,1,17,2,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(532,2,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(532,3,12,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(533,1,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(533,2,12,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(533,3,10,1,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(533,4,25,1,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(534,1,21,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(534,2,9,2,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(534,3,2,1,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(534,4,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(535,1,24,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(535,2,15,1,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(535,3,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(536,1,22,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(536,2,2,1,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(536,3,12,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(536,4,14,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(537,1,10,1,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(537,2,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(537,3,17,2,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(537,4,25,2,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(538,1,2,2,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(539,1,9,2,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(539,2,23,1,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(539,3,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(540,1,19,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(540,2,26,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(540,3,23,2,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(541,1,22,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(542,1,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(542,2,9,1,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(542,3,20,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(542,4,19,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(543,1,25,1,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(543,2,18,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(543,3,26,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(544,1,12,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(544,2,17,1,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(544,3,21,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(545,1,25,2,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(545,2,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(545,3,24,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(545,4,20,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(546,1,17,2,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(546,2,8,1,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(546,3,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(547,1,11,2,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(547,2,9,1,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(547,3,5,1,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(548,1,8,1,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(548,2,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(549,1,15,1,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(549,2,16,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(549,3,3,1,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(549,4,7,1,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(549,5,13,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(550,1,4,1,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(551,1,16,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(551,2,26,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(551,3,11,2,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(551,4,15,2,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(552,1,23,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(552,2,2,1,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(552,3,24,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(552,4,18,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(552,5,19,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(553,1,24,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(553,2,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(553,3,12,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(554,1,3,2,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(554,2,22,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(554,3,4,2,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(555,1,8,1,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(555,2,7,1,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(555,3,20,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(556,1,16,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(556,2,4,2,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(557,1,9,2,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(557,2,10,1,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(558,1,7,1,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(558,2,16,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(558,3,9,1,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(558,4,21,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(558,5,10,2,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(559,1,15,2,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(559,2,6,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(559,3,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(560,1,16,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(560,2,26,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(561,1,15,2,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(561,2,18,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(561,3,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(561,4,17,2,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(562,1,25,2,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(562,2,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(563,1,6,2,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(563,2,19,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(563,3,13,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(564,1,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(564,2,15,1,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(565,1,18,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(565,2,25,2,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(565,3,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(565,4,17,1,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(566,1,24,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(566,2,7,2,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(566,3,8,1,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(566,4,21,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(567,1,9,1,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(567,2,5,1,1320.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(568,1,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(568,2,10,1,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(569,1,16,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(569,2,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(570,1,18,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(570,2,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(570,3,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(570,4,11,1,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(570,5,16,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(571,1,4,1,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(571,2,9,1,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(572,1,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(572,2,13,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(572,3,11,2,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(573,1,2,1,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(574,1,26,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(574,2,13,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(574,3,12,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(574,4,23,2,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(574,5,11,2,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(575,1,4,2,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(575,2,12,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(576,1,9,1,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(577,1,3,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(578,1,21,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(578,2,25,2,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(578,3,18,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(578,4,8,2,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(579,1,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(579,2,6,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(580,1,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(580,2,15,1,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(580,3,21,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(580,4,9,2,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(580,5,19,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(581,1,8,2,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(582,1,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(582,2,17,2,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(583,1,15,2,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(584,1,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(584,2,23,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(584,3,15,1,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(584,4,22,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(584,5,8,2,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(585,1,10,1,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(585,2,18,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(585,3,15,1,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(585,4,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(586,1,11,2,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(586,2,23,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(587,1,24,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(587,2,23,1,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(587,3,18,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(587,4,21,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(588,1,10,2,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(588,2,23,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(589,1,15,2,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(590,1,2,2,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(590,2,20,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(590,3,8,2,1799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(590,4,5,2,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(590,5,24,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(591,1,16,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(591,2,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(591,3,2,2,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(592,1,21,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(592,2,16,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(592,3,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(593,1,3,2,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(593,2,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(594,1,26,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(594,2,21,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(595,1,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(595,2,19,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(595,3,3,1,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(595,4,10,1,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(595,5,26,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(596,1,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(596,2,23,2,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(596,3,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(597,1,17,2,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(597,2,8,1,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(598,1,4,2,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(598,2,16,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(598,3,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(599,1,9,2,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(599,2,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(599,3,23,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(599,4,10,2,1549.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(600,1,26,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(600,2,4,1,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(600,3,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(601,1,12,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(602,1,15,2,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(602,2,5,2,1320.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(603,1,12,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(603,2,4,1,2899.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(604,1,10,2,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(604,2,9,2,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(605,1,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(605,2,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(605,3,13,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(605,4,11,1,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(606,1,6,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(606,2,18,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(607,1,11,2,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(607,2,26,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(607,3,14,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(608,1,4,2,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(608,2,7,2,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(608,3,24,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(609,1,10,1,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(609,2,7,1,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(609,3,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(609,4,5,1,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(610,1,26,1,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(610,2,24,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(610,3,18,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(610,4,3,1,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(610,5,8,1,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(611,1,16,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(612,1,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(612,2,14,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(612,3,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(612,4,20,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(613,1,9,2,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(613,2,18,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(613,3,12,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(614,1,18,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(614,2,21,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(615,1,11,1,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(615,2,23,1,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(615,3,6,2,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(615,4,19,2,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(616,1,24,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(616,2,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(617,1,15,2,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(617,2,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(618,1,17,2,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(618,2,11,1,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(619,1,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(620,1,5,2,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(621,1,17,2,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(622,1,9,2,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(622,2,18,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(622,3,10,1,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(622,4,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(623,1,8,1,1799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(624,1,21,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(624,2,16,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(624,3,22,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(624,4,14,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(625,1,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(625,2,11,2,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(625,3,26,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(625,4,23,2,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(626,1,15,1,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(627,1,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(627,2,9,2,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(627,3,26,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(628,1,15,2,529.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(629,1,19,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(629,2,5,2,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(629,3,23,2,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(629,4,14,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(629,5,6,2,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(630,1,5,1,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(630,2,25,1,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(630,3,18,2,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(630,4,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(631,1,24,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(631,2,15,2,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(632,1,25,1,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(632,2,11,2,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(632,3,15,1,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(632,4,6,1,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(632,5,22,2,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(633,1,12,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(633,2,13,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(633,3,5,2,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(633,4,10,2,1549.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(634,1,4,2,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(634,2,12,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(635,1,4,1,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(636,1,85,2,329.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(637,1,9,1,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(637,2,106,2,449.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(638,1,103,1,551.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(638,2,56,1,5499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(638,3,53,2,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(639,1,15,1,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(639,2,73,1,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(639,3,72,1,619.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(639,4,61,2,4999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(640,1,106,2,449.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(640,2,32,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(640,3,30,1,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(640,4,76,2,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(640,5,109,2,416.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(641,1,15,1,529.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(641,2,62,1,3499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(641,3,64,1,489.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(642,1,68,2,449.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(643,1,53,1,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(644,1,9,1,2999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(645,1,99,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(645,2,42,2,2299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(645,3,6,1,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(645,4,47,2,5299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(645,5,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(646,1,15,2,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(646,2,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(646,3,95,1,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(646,4,12,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(647,1,25,2,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(647,2,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(648,1,24,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(649,1,97,2,349.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(649,2,90,1,209.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(649,3,11,2,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(649,4,78,1,647.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(650,1,3,1,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(651,1,79,1,402.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(651,2,85,1,329.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(651,3,102,2,489.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(651,4,94,2,249.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(652,1,102,1,489.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(652,2,62,2,3499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(652,3,67,2,250.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(652,4,23,1,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(652,5,74,1,439.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(653,1,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(653,2,43,1,5299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(653,3,2,2,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(653,4,80,1,761.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(653,5,88,2,189.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(654,1,9,1,2999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(654,2,95,1,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(654,3,110,2,470.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(654,4,97,2,349.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(655,1,67,1,250.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(656,1,83,1,149.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(656,2,22,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(656,3,33,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(657,1,52,1,875.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(657,2,54,2,3199.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(658,1,49,2,3499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(658,2,29,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(658,3,9,1,2999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(659,1,42,2,2299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(659,2,39,2,1499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(659,3,70,1,659.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(659,4,61,2,4999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(660,1,30,1,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(660,2,59,2,2599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(660,3,47,2,5299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(660,4,29,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(661,1,63,2,3499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(661,2,22,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(662,1,55,2,2699.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(662,2,95,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(662,3,102,2,489.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(662,4,22,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(662,5,106,2,449.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(663,1,41,2,1469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(663,2,17,2,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(663,3,94,1,249.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(663,4,71,1,416.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(663,5,106,1,449.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(664,1,52,2,875.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(664,2,5,1,1320.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(664,3,50,1,5999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(664,4,101,2,339.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(664,5,47,1,5299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(665,1,58,1,4999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(665,2,42,2,2299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(665,3,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(666,1,98,2,489.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(666,2,39,1,1499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(667,1,79,1,402.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(667,2,84,1,109.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(667,3,3,1,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(667,4,99,1,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(667,5,85,1,329.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(668,1,48,2,1499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(668,2,19,2,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(669,1,16,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(669,2,72,1,619.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(670,1,108,1,449.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(670,2,28,1,2499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(670,3,104,2,481.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(670,4,45,2,869.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(671,1,30,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(671,2,69,1,416.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(671,3,55,1,2699.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(671,4,4,1,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(671,5,109,2,416.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(672,1,51,2,6499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(672,2,96,2,349.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(672,3,48,2,1499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(673,1,66,1,250.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(673,2,38,1,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(673,3,5,1,1320.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(673,4,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(674,1,26,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(675,1,17,1,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(675,2,89,2,209.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(675,3,19,1,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(675,4,32,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(676,1,70,1,659.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(676,2,104,2,481.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(676,3,24,1,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(676,4,29,1,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(677,1,75,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(677,2,7,2,3999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(677,3,105,2,533.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(677,4,91,2,349.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(677,5,54,2,3199.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(678,1,52,2,875.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(678,2,37,2,379.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(679,1,15,2,529.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(679,2,83,2,149.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(680,1,81,2,1099.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(680,2,7,1,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(680,3,50,1,5999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(681,1,82,1,659.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(681,2,63,1,3499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(681,3,61,1,4999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(681,4,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(681,5,30,1,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(682,1,39,1,1499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(682,2,60,2,1559.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(682,3,99,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(683,1,2,2,749.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(684,1,56,1,5499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(684,2,33,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(685,1,59,1,2599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(685,2,48,2,1499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(685,3,107,1,416.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(685,4,98,2,489.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(685,5,56,2,5499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(686,1,16,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(686,2,30,1,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(686,3,88,2,189.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(686,4,19,2,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(686,5,104,1,481.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(687,1,48,2,1499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(687,2,95,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(687,3,5,2,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(687,4,83,1,149.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(688,1,8,1,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(688,2,88,1,189.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(689,1,33,2,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(690,1,84,1,109.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(690,2,11,2,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(690,3,85,1,329.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(690,4,109,2,416.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(691,1,23,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(691,2,5,2,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(691,3,55,2,2699.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(691,4,20,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(692,1,59,1,2599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(692,2,75,1,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(692,3,15,2,529.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(692,4,56,2,5499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(693,1,104,2,481.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(693,2,13,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(693,3,5,2,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(693,4,31,1,1632.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(694,1,48,1,1499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(694,2,39,1,1499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(694,3,55,2,2699.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(694,4,103,2,551.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(694,5,45,2,869.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(695,1,82,2,659.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(695,2,57,2,1999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(696,1,88,2,189.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(696,2,7,1,3999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(696,3,45,1,869.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(697,1,5,2,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(698,1,96,1,349.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(698,2,12,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(698,3,40,2,4999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(699,1,106,2,449.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(699,2,48,1,1499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(699,3,31,1,1632.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(699,4,24,2,549.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(699,5,82,2,659.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(700,1,7,2,3999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(700,2,63,1,3499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(701,1,84,1,109.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(702,1,25,2,499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(702,2,104,1,481.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(702,3,3,2,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(703,1,45,2,869.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(703,2,66,2,250.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(703,3,72,1,619.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(703,4,4,2,2899.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(704,1,10,2,1549.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(704,2,62,1,3499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(704,3,100,2,489.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(705,1,61,1,4999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(706,1,27,1,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(706,2,23,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(706,3,60,1,1559.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(707,1,106,2,449.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(707,2,100,1,489.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(707,3,11,2,1680.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(707,4,26,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(708,1,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(708,2,47,1,5299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(708,3,34,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(709,1,55,2,2699.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(709,2,101,2,339.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(709,3,48,1,1499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(710,1,42,1,2299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(710,2,60,2,1559.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(710,3,39,2,1499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(710,4,57,1,1999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(710,5,28,1,2499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(711,1,5,2,1320.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(711,2,95,2,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(711,3,72,2,619.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(712,1,44,2,539.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(712,2,74,2,439.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(712,3,35,1,832.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(712,4,76,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(712,5,4,2,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(713,1,93,2,209.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(713,2,97,2,349.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(713,3,53,1,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(713,4,108,2,449.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(714,1,92,2,209.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(715,1,61,2,4999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(715,2,50,1,5999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(716,1,111,2,470.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(716,2,93,2,209.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(716,3,79,1,402.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(716,4,4,2,2899.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(717,1,56,2,5499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(717,2,93,1,209.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(718,1,92,2,209.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(718,2,40,2,4999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(718,3,64,2,489.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(719,1,100,1,489.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(720,1,111,1,470.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(720,2,6,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(721,1,45,2,869.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(721,2,102,1,489.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(721,3,73,2,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(721,4,33,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(722,1,22,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(722,2,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(722,3,104,2,481.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(723,1,24,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(723,2,16,1,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(723,3,108,1,449.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(724,1,23,1,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(724,2,75,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(724,3,102,1,489.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(724,4,55,1,2699.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(725,1,90,1,209.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(725,2,91,1,349.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(725,3,77,2,799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(725,4,62,2,3499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(726,1,64,1,489.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(727,1,78,1,647.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(727,2,82,2,659.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(728,1,70,1,659.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(728,2,56,1,5499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(728,3,91,1,349.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(728,4,58,1,4999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(729,1,101,2,339.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(730,1,59,2,2599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(730,2,79,1,402.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(730,3,96,2,349.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(730,4,13,1,269.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(731,1,91,1,349.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(731,2,49,1,3499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(731,3,67,2,250.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(731,4,29,1,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(732,1,47,1,5299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(732,2,4,2,2899.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(733,1,84,1,109.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(733,2,55,1,2699.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(733,3,102,2,489.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(734,1,26,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(734,2,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(734,3,84,2,109.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(734,4,65,2,346.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(735,1,71,2,416.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(735,2,10,2,1549.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(736,1,56,2,5499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(736,2,17,1,429.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(736,3,62,2,3499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(737,1,52,1,875.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(737,2,19,2,449.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(737,3,77,2,799.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(737,4,34,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(738,1,82,2,659.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(738,2,38,2,549.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(738,3,25,1,499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(738,4,63,1,3499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(739,1,3,1,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(740,1,81,1,1099.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(740,2,94,2,249.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(740,3,11,1,1680.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(740,4,19,1,449.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(740,5,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(741,1,58,1,4999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(741,2,76,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(741,3,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(741,4,56,2,5499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(742,1,107,2,416.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(742,2,45,1,869.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(743,1,80,1,761.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(744,1,33,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(745,1,95,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(745,2,22,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(745,3,78,1,647.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(746,1,99,1,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(747,1,110,1,470.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(747,2,86,1,149.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(747,3,33,2,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(747,4,81,1,1099.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(748,1,16,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(748,2,83,2,149.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(748,3,41,1,1469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(748,4,35,2,832.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(749,1,9,1,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(749,2,28,1,2499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(749,3,79,1,402.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(749,4,24,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(749,5,40,1,4999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(750,1,72,1,619.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(750,2,78,2,647.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(751,1,45,2,869.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(752,1,12,2,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(752,2,31,2,1632.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(753,1,105,2,533.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(753,2,7,2,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(753,3,36,2,832.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(753,4,95,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(753,5,66,1,250.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(754,1,74,2,439.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(754,2,12,2,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(754,3,3,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(754,4,67,2,250.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(754,5,7,1,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(755,1,80,2,761.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(755,2,43,2,5299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(755,3,57,2,1999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(756,1,64,1,489.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(756,2,17,2,429.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(757,1,95,1,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(758,1,22,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(758,2,99,1,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(758,3,27,1,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(758,4,65,2,346.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(758,5,109,1,416.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(759,1,93,2,209.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(759,2,78,1,647.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(760,1,21,2,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(760,2,29,2,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(761,1,43,1,5299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(761,2,52,2,875.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(762,1,102,2,489.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(763,1,90,1,209.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(763,2,103,1,551.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(764,1,55,1,2699.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(764,2,95,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(764,3,81,2,1099.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(765,1,28,2,2499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(765,2,12,1,549.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(765,3,25,1,499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(765,4,53,1,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(765,5,65,1,346.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(766,1,111,1,470.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(767,1,63,1,3499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(767,2,29,1,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(767,3,41,2,1469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(767,4,77,2,799.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(768,1,31,1,1632.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(768,2,76,1,299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(769,1,8,1,1799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(769,2,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(769,3,36,2,832.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(770,1,110,1,470.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(770,2,42,1,2299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(770,3,103,1,551.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(770,4,11,2,1680.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(771,1,13,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(771,2,88,1,189.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(772,1,103,1,551.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(773,1,92,1,209.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(773,2,14,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(773,3,17,2,429.00,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(773,4,33,2,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(774,1,65,1,346.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(774,2,36,2,832.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(774,3,20,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(774,4,73,1,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(774,5,58,2,4999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(775,1,39,1,1499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(776,1,28,1,2499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(776,2,42,2,2299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(776,3,71,1,416.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(776,4,35,1,832.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(777,1,5,1,1320.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(777,2,7,2,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(777,3,2,1,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(778,1,64,1,489.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(778,2,85,1,329.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(779,1,101,1,339.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(779,2,90,2,209.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(779,3,47,1,5299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(779,4,8,1,1799.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(779,5,85,1,329.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(780,1,32,1,469.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(781,1,109,2,416.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(781,2,7,2,3999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(781,3,57,2,1999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(782,1,20,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(782,2,57,1,1999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(782,3,99,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(782,4,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(783,1,92,1,209.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(783,2,22,2,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(783,3,94,1,249.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(783,4,29,1,999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(784,1,22,1,269.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(784,2,72,2,619.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(784,3,16,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(785,1,59,2,2599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(785,2,40,1,4999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(785,3,25,1,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(786,1,80,1,761.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(787,1,51,2,6499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(787,2,66,2,250.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(788,1,48,1,1499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(788,2,19,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(788,3,13,1,269.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(789,1,100,2,489.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(789,2,93,2,209.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(790,1,62,2,3499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(790,2,91,1,349.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(791,1,54,1,3199.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(791,2,25,2,499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(792,1,16,2,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(792,2,39,1,1499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(792,3,56,1,5499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(792,4,30,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(792,5,2,1,749.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(793,1,60,1,1559.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(793,2,95,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(793,3,75,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(794,1,41,2,1469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(794,2,68,1,449.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(794,3,17,1,429.00,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(794,4,28,1,2499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(795,1,95,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(795,2,99,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(796,1,6,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(797,1,11,1,1680.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(797,2,69,1,416.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(797,3,74,1,439.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(797,4,54,2,3199.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(797,5,62,2,3499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(798,1,23,1,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(798,2,90,1,209.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(798,3,91,2,349.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(798,4,42,1,2299.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(798,5,26,2,599.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(799,1,5,2,1320.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(799,2,34,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(799,3,29,2,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(799,4,63,1,3499.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(799,5,58,2,4999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(800,1,65,2,346.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(800,2,54,1,3199.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(800,3,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(800,4,52,1,875.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(800,5,95,2,299.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(801,1,101,1,339.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(802,1,30,1,999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(802,2,36,2,832.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(802,3,40,1,4999.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(802,4,28,1,2499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(803,1,111,1,470.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(803,2,52,2,875.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(803,3,102,1,489.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(803,4,83,2,149.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(804,1,89,2,209.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(804,2,53,1,749.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(804,3,50,2,5999.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(805,1,24,1,549.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(805,2,33,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(805,3,62,2,3499.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(805,4,32,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(805,5,6,2,469.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(806,1,93,2,209.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(806,2,97,1,349.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(806,3,77,2,799.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(806,4,82,2,659.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(806,5,91,2,349.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(807,1,21,2,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(807,2,6,1,469.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(807,3,3,2,999.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(807,4,9,2,2999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(807,5,16,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(808,1,96,2,349.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(808,2,18,1,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(808,3,85,1,329.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(808,4,19,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(809,1,78,1,647.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(809,2,26,1,599.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(809,3,92,2,209.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(810,1,103,2,551.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(810,2,100,1,489.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(810,3,56,1,5499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(810,4,22,1,269.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(811,1,45,2,869.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(811,2,54,1,3199.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(811,3,70,1,659.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(811,4,66,1,250.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(812,1,76,2,299.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(812,2,40,1,4999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(813,1,96,2,349.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(813,2,85,2,329.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(813,3,33,2,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(813,4,26,2,599.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(813,5,71,2,416.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(814,1,69,2,416.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(814,2,100,1,489.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(814,3,65,1,346.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(814,4,83,2,149.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(815,1,105,2,533.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(815,2,102,2,489.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(815,3,87,2,189.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(815,4,23,1,299.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(816,1,75,2,599.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(816,2,64,2,489.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(817,1,85,1,329.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(817,2,105,2,533.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(817,3,48,2,1499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(818,1,103,1,551.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(818,2,44,2,539.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(818,3,19,2,449.00,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(818,4,48,2,1499.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(819,1,94,1,249.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(820,1,107,1,416.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(821,1,102,1,489.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(821,2,70,2,659.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(821,3,6,1,469.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(821,4,107,1,416.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(822,1,53,1,749.99,0.05);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(822,2,72,1,619.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(823,1,56,2,5499.99,0.07);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(823,2,86,2,149.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(823,3,81,1,1099.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(824,1,92,2,209.99,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(825,1,19,1,449.00,0.1);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(825,2,30,2,999.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(826,1,45,2,869.99,0.2);
INSERT INTO sales.order_items(order_id, item_id, product_id, quantity, list_price,discount) VALUES(8